/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.budget.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.budget.core.BudgetServiceImpl;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwardPeriodDetail;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwards;
import org.kuali.kra.proposaldevelopment.budget.service.impl.BudgetSubAwardServiceImpl;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

public class BudgetSubAwardServiceTest {
    protected static String directLt = "4";
    protected static String directGt = "3";
    protected static String indirectLt = "2";
    protected static String indirectGt = "1";
    protected BudgetSubAwardServiceImpl service;
    protected BudgetSubAwards subAward;
    protected Budget budget;
    protected int budgetLineItem = 28;
    protected String budgetDocumentNumber = "1498";
    protected Mockery context;

    @Before
    public void setUp() throws Exception {
        this.context = new JUnit4Mockery();
        this.service = new BudgetSubAwardServiceImpl();
        this.budget = new Budget();
        this.budget.setBudgetId(Long.valueOf(13L));
        this.subAward = new BudgetSubAwards();
        this.subAward.setBudgetId(this.budget.getBudgetId());
        this.subAward.setSubAwardNumber(Integer.valueOf(207));
        this.subAward.setOrganizationName("My Testing Organization");
        this.budget.getBudgetSubAwards().add(this.subAward);
        for (int i = 0; i < 2; ++i) {
            BudgetPeriod period = new BudgetPeriod();
            period.setBudgetId(this.budget.getBudgetId());
            period.setBudgetPeriod(Integer.valueOf(i));
            period.setBudgetPeriodId(Long.valueOf((long)i + 1029L));
            this.budget.getBudgetPeriods().add(period);
            BudgetSubAwardPeriodDetail detail = new BudgetSubAwardPeriodDetail(this.subAward, period);
            detail.setSubAwardNumber(this.subAward.getSubAwardNumber());
            this.subAward.getBudgetSubAwardPeriodDetails().add(detail);
        }
        final ParameterService parmService = (ParameterService)this.context.mock(ParameterService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ParameterService)this.one(parmService)).getParameterValueAsString(BudgetDocument.class, "SUBCONTRACTOR_DIRECT_LT_25K");
                this.will(1.returnValue((Object)directLt));
                ((ParameterService)this.one(parmService)).getParameterValueAsString(BudgetDocument.class, "SUBCONTRACTOR_DIRECT_GT_25K");
                this.will(1.returnValue((Object)directGt));
                ((ParameterService)this.one(parmService)).getParameterValueAsString(BudgetDocument.class, "SUBCONTRACTOR_F_AND_A_LT_25K");
                this.will(1.returnValue((Object)indirectLt));
                ((ParameterService)this.one(parmService)).getParameterValueAsString(BudgetDocument.class, "SUBCONTRACTOR_F_AND_A_GT_25K");
                this.will(1.returnValue((Object)indirectGt));
            }
        });
        this.service.setParameterService(parmService);
        this.service.setBudgetService((BudgetService)new BudgetServiceMock());
    }

    @Test
    public void testExample1WithNoLineItems() throws Exception {
        ((BudgetSubAwardPeriodDetail)this.subAward.getBudgetSubAwardPeriodDetails().get(0)).setDirectCost(new BudgetDecimal(150000.0));
        ((BudgetSubAwardPeriodDetail)this.subAward.getBudgetSubAwardPeriodDetails().get(0)).setIndirectCost(new BudgetDecimal(75000.0));
        ((BudgetSubAwardPeriodDetail)this.subAward.getBudgetSubAwardPeriodDetails().get(1)).setDirectCost(new BudgetDecimal(150000.0));
        ((BudgetSubAwardPeriodDetail)this.subAward.getBudgetSubAwardPeriodDetails().get(1)).setIndirectCost(new BudgetDecimal(75000.0));
        ArrayList<Map<String, BudgetDecimal>> expectedResults = new ArrayList<Map<String, BudgetDecimal>>();
        expectedResults.add(new HashMap());
        expectedResults.add(new HashMap());
        expectedResults.add(new HashMap());
        ((Map)expectedResults.get(0)).put(indirectGt, new BudgetDecimal(75000.0));
        ((Map)expectedResults.get(0)).put(indirectLt, new BudgetDecimal(0));
        ((Map)expectedResults.get(0)).put(directGt, new BudgetDecimal(125000.0));
        ((Map)expectedResults.get(0)).put(directLt, new BudgetDecimal(25000.0));
        ((Map)expectedResults.get(1)).put(indirectGt, new BudgetDecimal(75000.0));
        ((Map)expectedResults.get(1)).put(indirectLt, new BudgetDecimal(0));
        ((Map)expectedResults.get(1)).put(directGt, new BudgetDecimal(150000.0));
        ((Map)expectedResults.get(1)).put(directLt, new BudgetDecimal(0));
        this.service.generateSubAwardLineItems(this.subAward, this.budget);
        this.assertExpectedResults(expectedResults);
        this.assertCostShare(0L);
    }

    @Test
    public void testExample2WithNoLineItems() throws Exception {
        ((BudgetSubAwardPeriodDetail)this.subAward.getBudgetSubAwardPeriodDetails().get(0)).setDirectCost(new BudgetDecimal(15000.0));
        ((BudgetSubAwardPeriodDetail)this.subAward.getBudgetSubAwardPeriodDetails().get(0)).setIndirectCost(new BudgetDecimal(7500.0));
        ((BudgetSubAwardPeriodDetail)this.subAward.getBudgetSubAwardPeriodDetails().get(1)).setDirectCost(new BudgetDecimal(15000.0));
        ((BudgetSubAwardPeriodDetail)this.subAward.getBudgetSubAwardPeriodDetails().get(1)).setIndirectCost(new BudgetDecimal(7500.0));
        ArrayList<Map<String, BudgetDecimal>> expectedResults = new ArrayList<Map<String, BudgetDecimal>>();
        expectedResults.add(new HashMap());
        expectedResults.add(new HashMap());
        expectedResults.add(new HashMap());
        ((Map)expectedResults.get(0)).put(indirectGt, new BudgetDecimal(0.0));
        ((Map)expectedResults.get(0)).put(indirectLt, new BudgetDecimal(7500.0));
        ((Map)expectedResults.get(0)).put(directGt, new BudgetDecimal(0));
        ((Map)expectedResults.get(0)).put(directLt, new BudgetDecimal(15000.0));
        ((Map)expectedResults.get(1)).put(indirectGt, new BudgetDecimal(7500.0));
        ((Map)expectedResults.get(1)).put(indirectLt, new BudgetDecimal(0.0));
        ((Map)expectedResults.get(1)).put(directGt, new BudgetDecimal(12500.0));
        ((Map)expectedResults.get(1)).put(directLt, new BudgetDecimal(2500.0));
        this.service.generateSubAwardLineItems(this.subAward, this.budget);
        this.assertExpectedResults(expectedResults);
        this.assertCostShare(0L);
    }

    @Test
    public void testExample3WithNoLineItems() throws Exception {
        ((BudgetSubAwardPeriodDetail)this.subAward.getBudgetSubAwardPeriodDetails().get(0)).setDirectCost(new BudgetDecimal(20000));
        ((BudgetSubAwardPeriodDetail)this.subAward.getBudgetSubAwardPeriodDetails().get(0)).setIndirectCost(new BudgetDecimal(10000));
        ((BudgetSubAwardPeriodDetail)this.subAward.getBudgetSubAwardPeriodDetails().get(1)).setDirectCost(new BudgetDecimal(20000));
        ((BudgetSubAwardPeriodDetail)this.subAward.getBudgetSubAwardPeriodDetails().get(1)).setIndirectCost(new BudgetDecimal(10000));
        ArrayList<Map<String, BudgetDecimal>> expectedResults = new ArrayList<Map<String, BudgetDecimal>>();
        expectedResults.add(new HashMap());
        expectedResults.add(new HashMap());
        expectedResults.add(new HashMap());
        ((Map)expectedResults.get(0)).put(indirectGt, new BudgetDecimal(5000));
        ((Map)expectedResults.get(0)).put(indirectLt, new BudgetDecimal(5000));
        ((Map)expectedResults.get(0)).put(directGt, new BudgetDecimal(0));
        ((Map)expectedResults.get(0)).put(directLt, new BudgetDecimal(20000));
        ((Map)expectedResults.get(1)).put(indirectGt, new BudgetDecimal(10000));
        ((Map)expectedResults.get(1)).put(indirectLt, new BudgetDecimal(0.0));
        ((Map)expectedResults.get(1)).put(directGt, new BudgetDecimal(20000));
        ((Map)expectedResults.get(1)).put(directLt, new BudgetDecimal(0));
        this.service.generateSubAwardLineItems(this.subAward, this.budget);
        this.assertExpectedResults(expectedResults);
        this.assertCostShare(0L);
    }

    @Test
    public void testExample1WithCostShare() throws Exception {
        ((BudgetSubAwardPeriodDetail)this.subAward.getBudgetSubAwardPeriodDetails().get(0)).setDirectCost(new BudgetDecimal(150000.0));
        ((BudgetSubAwardPeriodDetail)this.subAward.getBudgetSubAwardPeriodDetails().get(0)).setIndirectCost(new BudgetDecimal(75000.0));
        ((BudgetSubAwardPeriodDetail)this.subAward.getBudgetSubAwardPeriodDetails().get(0)).setCostShare(new BudgetDecimal(1000.0));
        ((BudgetSubAwardPeriodDetail)this.subAward.getBudgetSubAwardPeriodDetails().get(1)).setDirectCost(new BudgetDecimal(150000.0));
        ((BudgetSubAwardPeriodDetail)this.subAward.getBudgetSubAwardPeriodDetails().get(1)).setIndirectCost(new BudgetDecimal(75000.0));
        ((BudgetSubAwardPeriodDetail)this.subAward.getBudgetSubAwardPeriodDetails().get(1)).setCostShare(new BudgetDecimal(1000.0));
        ArrayList<Map<String, BudgetDecimal>> expectedResults = new ArrayList<Map<String, BudgetDecimal>>();
        expectedResults.add(new HashMap());
        expectedResults.add(new HashMap());
        expectedResults.add(new HashMap());
        ((Map)expectedResults.get(0)).put(indirectGt, new BudgetDecimal(75000.0));
        ((Map)expectedResults.get(0)).put(indirectLt, new BudgetDecimal(0));
        ((Map)expectedResults.get(0)).put(directGt, new BudgetDecimal(125000.0));
        ((Map)expectedResults.get(0)).put(directLt, new BudgetDecimal(25000.0));
        ((Map)expectedResults.get(1)).put(indirectGt, new BudgetDecimal(75000.0));
        ((Map)expectedResults.get(1)).put(indirectLt, new BudgetDecimal(0));
        ((Map)expectedResults.get(1)).put(directGt, new BudgetDecimal(150000.0));
        ((Map)expectedResults.get(1)).put(directLt, new BudgetDecimal(0));
        this.service.generateSubAwardLineItems(this.subAward, this.budget);
        this.assertExpectedResults(expectedResults);
        this.assertCostShare(1000L);
    }

    @Test
    public void testExample1WithLineItems() throws Exception {
        ((BudgetSubAwardPeriodDetail)this.subAward.getBudgetSubAwardPeriodDetails().get(0)).setDirectCost(new BudgetDecimal(150000.0));
        ((BudgetSubAwardPeriodDetail)this.subAward.getBudgetSubAwardPeriodDetails().get(0)).setIndirectCost(new BudgetDecimal(75000.0));
        ((BudgetSubAwardPeriodDetail)this.subAward.getBudgetSubAwardPeriodDetails().get(1)).setDirectCost(new BudgetDecimal(150000.0));
        ((BudgetSubAwardPeriodDetail)this.subAward.getBudgetSubAwardPeriodDetails().get(1)).setIndirectCost(new BudgetDecimal(75000.0));
        for (BudgetPeriod period : this.budget.getBudgetPeriods()) {
            BudgetLineItem newLineItem = new BudgetLineItem();
            newLineItem.setSubAwardNumber(this.subAward.getSubAwardNumber());
            newLineItem.setDirectCost(new BudgetDecimal(100.0));
            newLineItem.setCostSharingAmount(new BudgetDecimal(100.0));
            newLineItem.setCostElement(directLt);
            newLineItem.setLineItemNumber(Integer.valueOf(1));
            period.getBudgetLineItems().add(newLineItem);
            newLineItem = (BudgetLineItem)org.kuali.rice.krad.util.ObjectUtils.deepCopy((Serializable)newLineItem);
            newLineItem.setCostElement(directGt);
            newLineItem.setLineItemNumber(Integer.valueOf(2));
            period.getBudgetLineItems().add(newLineItem);
            newLineItem = (BudgetLineItem)org.kuali.rice.krad.util.ObjectUtils.deepCopy((Serializable)newLineItem);
            newLineItem.setCostElement(indirectLt);
            newLineItem.setLineItemNumber(Integer.valueOf(3));
            period.getBudgetLineItems().add(newLineItem);
            newLineItem = (BudgetLineItem)org.kuali.rice.krad.util.ObjectUtils.deepCopy((Serializable)newLineItem);
            newLineItem.setCostElement(indirectGt);
            newLineItem.setLineItemNumber(Integer.valueOf(4));
            period.getBudgetLineItems().add(newLineItem);
        }
        ArrayList<Map<String, BudgetDecimal>> expectedResults = new ArrayList<Map<String, BudgetDecimal>>();
        expectedResults.add(new HashMap());
        expectedResults.add(new HashMap());
        expectedResults.add(new HashMap());
        ((Map)expectedResults.get(0)).put(indirectGt, new BudgetDecimal(75000.0));
        ((Map)expectedResults.get(0)).put(indirectLt, new BudgetDecimal(0));
        ((Map)expectedResults.get(0)).put(directGt, new BudgetDecimal(125000.0));
        ((Map)expectedResults.get(0)).put(directLt, new BudgetDecimal(25000.0));
        ((Map)expectedResults.get(1)).put(indirectGt, new BudgetDecimal(75000.0));
        ((Map)expectedResults.get(1)).put(indirectLt, new BudgetDecimal(0));
        ((Map)expectedResults.get(1)).put(directGt, new BudgetDecimal(150000.0));
        ((Map)expectedResults.get(1)).put(directLt, new BudgetDecimal(0));
        this.service.generateSubAwardLineItems(this.subAward, this.budget);
        this.assertExpectedResults(expectedResults);
        this.assertCostShare(0L);
    }

    protected void assertExpectedResults(List<Map<String, BudgetDecimal>> results) {
        int index = 0;
        for (BudgetPeriod period : this.budget.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : period.getBudgetLineItems()) {
                Assert.assertEquals((Object)this.subAward.getSubAwardNumber(), (Object)budgetLineItem.getSubAwardNumber());
                Assert.assertEquals((Object)results.get(index).get(budgetLineItem.getCostElement()), (Object)budgetLineItem.getLineItemCost());
            }
            for (Map.Entry entry : results.get(index).entrySet()) {
                if (((BudgetDecimal)entry.getValue()).isZero()) {
                    Assert.assertNull((Object)this.findLineItemByCostElement(period.getBudgetLineItems(), (String)entry.getKey()));
                    continue;
                }
                Assert.assertEquals(entry.getValue(), (Object)this.findLineItemByCostElement(period.getBudgetLineItems(), (String)entry.getKey()).getLineItemCost());
            }
            ++index;
        }
    }

    protected void assertCostShare(long costShareAmount) {
        for (BudgetPeriod period : this.budget.getBudgetPeriods()) {
            Collections.sort(period.getBudgetLineItems(), new Comparator<BudgetLineItem>(){

                @Override
                public int compare(BudgetLineItem arg0, BudgetLineItem arg1) {
                    return arg0.getLineItemNumber().compareTo(arg1.getLineItemNumber());
                }
            });
            Assert.assertEquals((Object)new BudgetDecimal((double)costShareAmount), (Object)((BudgetLineItem)period.getBudgetLineItems().get(0)).getCostSharingAmount());
            for (int i = 1; i < this.budget.getBudgetPeriods().size(); ++i) {
                Assert.assertEquals((Object)BudgetDecimal.ZERO, (Object)((BudgetLineItem)period.getBudgetLineItems().get(i)).getCostSharingAmount());
            }
        }
    }

    protected BudgetLineItem findLineItemByCostElement(List<BudgetLineItem> lineItems, String costElement) {
        for (BudgetLineItem lineItem : lineItems) {
            if (!StringUtils.equals((String)lineItem.getCostElement(), (String)costElement) || !ObjectUtils.equals((Object)lineItem.getSubAwardNumber(), (Object)this.subAward.getSubAwardNumber())) continue;
            return lineItem;
        }
        return null;
    }

    protected class BudgetServiceMock
    extends BudgetServiceImpl {
        int newLineItemNumber = 28;

        protected BudgetServiceMock() {
        }

        public void populateNewBudgetLineItem(BudgetLineItem newBudgetLineItem, BudgetPeriod budgetPeriod) {
            newBudgetLineItem.setBudgetPeriod(budgetPeriod.getBudgetPeriod());
            newBudgetLineItem.setBudgetPeriodId(budgetPeriod.getBudgetPeriodId());
            newBudgetLineItem.setStartDate(budgetPeriod.getStartDate());
            newBudgetLineItem.setEndDate(budgetPeriod.getEndDate());
            newBudgetLineItem.setBudgetId(BudgetSubAwardServiceTest.this.budget.getBudgetId());
            newBudgetLineItem.setLineItemNumber(Integer.valueOf(this.newLineItemNumber++));
            newBudgetLineItem.setApplyInRateFlag(Boolean.valueOf(true));
            newBudgetLineItem.setSubmitCostSharingFlag(BudgetSubAwardServiceTest.this.budget.getSubmitCostSharingFlag());
        }
    }
}

