/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.document;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.ProposalColumnsToAlter;
import org.kuali.kra.proposaldevelopment.document.ProposalColumnsToAlterMaintainableImpl;
import org.kuali.kra.service.KraPersistenceStructureService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalColumnsToAlterMaintainableImplTest
extends KcUnitTestBase {
    private ProposalColumnsToAlterMaintainableImpl columnsToAlterMaintainable;
    private Map<String, String> columnToAttrMap;

    @Override
    @Before
    public void setUp() throws Exception {
        KraPersistenceStructureService persistenceStructureService = (KraPersistenceStructureService)KraServiceLocator.getService(KraPersistenceStructureService.class);
        this.columnToAttrMap = persistenceStructureService.getDBColumnToObjectAttributeMap(DevelopmentProposal.class);
        this.columnsToAlterMaintainable = new ProposalColumnsToAlterMaintainableImpl();
        GlobalVariables.setUserSession((UserSession)new UserSession("admin"));
    }

    @Override
    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testAllProposalDevColumns() throws Exception {
        for (String cols : this.columnToAttrMap.keySet()) {
            ProposalColumnsToAlter testBo = new ProposalColumnsToAlter();
            testBo.setColumnName(cols);
            this.columnsToAlterMaintainable.setBusinessObject((PersistableBusinessObject)testBo);
            this.columnsToAlterMaintainable.prepareForSave();
        }
    }

    @Test
    public void testSpecificProposalColumns() throws Exception {
        ProposalColumnsToAlter testBo = new ProposalColumnsToAlter();
        testBo.setColumnName("MAIL_BY");
        this.columnsToAlterMaintainable.setBusinessObject((PersistableBusinessObject)testBo);
        this.columnsToAlterMaintainable.prepareForSave();
        ProposalColumnsToAlterMaintainableImplTest.assertTrue((String)"Label was not set as expected", (boolean)StringUtils.isNotBlank((String)testBo.getColumnLabel()));
        ProposalColumnsToAlterMaintainableImplTest.assertTrue((String)"Data length not set properly", (testBo.getDataLength() > 0 ? 1 : 0) != 0);
        testBo.setColumnName("TITLE");
        this.columnsToAlterMaintainable.setBusinessObject((PersistableBusinessObject)testBo);
        this.columnsToAlterMaintainable.prepareForSave();
        ProposalColumnsToAlterMaintainableImplTest.assertTrue((String)"Label was not set as expected", (boolean)StringUtils.isNotBlank((String)testBo.getColumnLabel()));
        ProposalColumnsToAlterMaintainableImplTest.assertTrue((String)"Data length not set properly", (testBo.getDataLength() > 0 ? 1 : 0) != 0);
        testBo.setColumnName("ACTIVITY_TYPE_CODE");
        this.columnsToAlterMaintainable.setBusinessObject((PersistableBusinessObject)testBo);
        this.columnsToAlterMaintainable.prepareForSave();
        ProposalColumnsToAlterMaintainableImplTest.assertTrue((String)"Label was not set as expected", (boolean)StringUtils.isNotBlank((String)testBo.getColumnLabel()));
        ProposalColumnsToAlterMaintainableImplTest.assertTrue((String)"Data length not set properly", (testBo.getDataLength() > 0 ? 1 : 0) != 0);
    }
}

