/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.lookup.keyvalue;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.lookup.keyvalue.CopyBudgetVersionsValuesFinder;
import org.kuali.rice.core.api.util.KeyValue;

public class CopyBudgetVersionsValuesFinderTest {
    private CopyBudgetVersionsValuesFinder finalVerFinder;
    private CopyBudgetVersionsValuesFinder nonFinalVerFinder;

    @Before
    public void setupfinalFinder() {
        this.finalVerFinder = new CopyBudgetVersionsValuesFinder(){

            ProposalDevelopmentDocument getDocument() {
                ArrayList<BudgetDocumentVersion> overviews = new ArrayList<BudgetDocumentVersion>();
                overviews.add(new BudgetDocumentVersion());
                BudgetDocumentVersion o = new BudgetDocumentVersion();
                o.getBudgetVersionOverview().setFinalVersionFlag(true);
                overviews.add(o);
                ProposalDevelopmentDocument document = new ProposalDevelopmentDocument();
                document.setBudgetDocumentVersions(overviews);
                return document;
            }
        };
    }

    @Before
    public void setupNofinalFinder() {
        this.nonFinalVerFinder = new CopyBudgetVersionsValuesFinder(){

            ProposalDevelopmentDocument getDocument() {
                ArrayList<BudgetDocumentVersion> overviews = new ArrayList<BudgetDocumentVersion>();
                overviews.add(new BudgetDocumentVersion());
                BudgetDocumentVersion o = new BudgetDocumentVersion();
                overviews.add(o);
                ProposalDevelopmentDocument document = new ProposalDevelopmentDocument();
                document.setBudgetDocumentVersions(overviews);
                return document;
            }
        };
    }

    @Test
    public void isFinalVersionFinal() {
        Assert.assertTrue((String)"final version should be present", (boolean)this.finalVerFinder.finalVersionPresent());
    }

    @Test
    public void isFinalVersionNotFinal() {
        Assert.assertTrue((String)"final version should NOT be present", (!this.nonFinalVerFinder.finalVersionPresent() ? 1 : 0) != 0);
    }

    @Test
    public void finalVersionVerify() {
        List keyValues = this.finalVerFinder.getKeyValues();
        Assert.assertEquals((String)"should be two key/label pair", (int)2, (int)keyValues.size());
        Assert.assertEquals((String)"key should be", (String)"all versions", (String)((KeyValue)keyValues.get(0)).getKey());
        Assert.assertEquals((String)"Label should be", (String)"all versions", (String)((KeyValue)keyValues.get(0)).getValue());
        Assert.assertEquals((String)"key should be", (String)"final version", (String)((KeyValue)keyValues.get(1)).getKey());
        Assert.assertEquals((String)"Label should be", (String)"final version", (String)((KeyValue)keyValues.get(1)).getValue());
    }

    @Test
    public void nonFinalVersionVerify() {
        List keyValues = this.nonFinalVerFinder.getKeyValues();
        Assert.assertEquals((String)"should only be one key/label pair", (int)1, (int)keyValues.size());
        Assert.assertEquals((String)"key should be", (String)"all versions", (String)((KeyValue)keyValues.get(0)).getKey());
        Assert.assertEquals((String)"Label should be", (String)"all versions", (String)((KeyValue)keyValues.get(0)).getValue());
    }
}

