/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.NarrativeType;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.lookup.keyvalue.ProposalNarrativeTypeValuesFinder;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;

public class ProposalNarrativeTypeValuesFinderTest
extends KcUnitTestBase {
    private static final String QUICKSTART = "quickstart";
    private static final String NO = "N";
    private static final String YES = "Y";
    private NarrativeType bioNarrativeType;
    private ProposalDevelopmentDocument document;
    private ProposalNarrativeTypeValuesFinder finder;
    private NarrativeType otherNarrativeType;
    private NarrativeType proposalNarrativeType;
    private List<KeyValue> allNarrativeTypesAsKeyValues;
    private Collection<NarrativeType> allNarrativeTypes;

    @Override
    @Before
    public void setUp() throws Exception {
        this.initNarrativeTypes();
        this.initDocument();
        this.finder = this.getFinder();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.document = null;
        this.otherNarrativeType = null;
    }

    @Test
    public void testFindingNarrativeValues() throws Exception {
        this.document.getDevelopmentProposal().getNarratives().add(this.createNarrative(this.proposalNarrativeType));
        Assert.assertEquals((long)3L, (long)this.finder.getFilteredKeyValues(this.copyMasterNarrativeTypeList()).size());
        this.document.getDevelopmentProposal().getNarratives().clear();
        this.document.getDevelopmentProposal().getNarratives().add(this.createNarrative(this.bioNarrativeType));
        Assert.assertEquals((long)3L, (long)this.finder.getFilteredKeyValues(this.copyMasterNarrativeTypeList()).size());
        this.document.getDevelopmentProposal().getNarratives().clear();
        this.document.getDevelopmentProposal().getNarratives().add(this.createNarrative(this.otherNarrativeType));
        Assert.assertEquals((long)4L, (long)this.finder.getFilteredKeyValues(this.copyMasterNarrativeTypeList()).size());
        this.document.getDevelopmentProposal().getNarratives().clear();
    }

    private ArrayList<NarrativeType> copyMasterNarrativeTypeList() {
        return new ArrayList<NarrativeType>(this.allNarrativeTypes);
    }

    private Narrative createNarrative(NarrativeType narrativeType) {
        MockNarrative narrative = new MockNarrative();
        narrative.setNarrativeType(narrativeType);
        narrative.setNarrativeTypeCode(narrativeType.getNarrativeTypeCode());
        return narrative;
    }

    private NarrativeType createNarrativeType(String narrativeTypeCode, String narrativeDescription, boolean allowMultiple) {
        NarrativeType narrativeType = new NarrativeType();
        narrativeType.setNarrativeTypeCode(narrativeTypeCode);
        narrativeType.setDescription(narrativeDescription);
        narrativeType.setAllowMultiple(allowMultiple ? YES : NO);
        this.allNarrativeTypes.add(narrativeType);
        this.allNarrativeTypesAsKeyValues.add((KeyValue)new ConcreteKeyValue(narrativeTypeCode, narrativeDescription));
        return narrativeType;
    }

    private ProposalNarrativeTypeValuesFinder getFinder() {
        MockProposalNarrativeTypeValuesFinder finder = new MockProposalNarrativeTypeValuesFinder();
        finder.setBusinessObjectClass(NarrativeType.class);
        finder.setIncludeKeyInDescription(false);
        finder.setKeyAttributeName("narrativeTypeCode");
        finder.setLabelAttributeName("description");
        return finder;
    }

    private void initDocument() {
        this.document = new ProposalDevelopmentDocument();
    }

    private void initNarrativeTypes() {
        this.allNarrativeTypes = new ArrayList<NarrativeType>();
        this.allNarrativeTypesAsKeyValues = new ArrayList<KeyValue>();
        this.proposalNarrativeType = this.createNarrativeType("1", "Proposal", false);
        this.bioNarrativeType = this.createNarrativeType("2", "Bio Sketch", false);
        this.otherNarrativeType = this.createNarrativeType("3", "Other", true);
    }

    private class MockProposalNarrativeTypeValuesFinder
    extends ProposalNarrativeTypeValuesFinder {
        private MockProposalNarrativeTypeValuesFinder() {
        }

        protected ProposalDevelopmentDocument getDocumentFromForm() {
            return ProposalNarrativeTypeValuesFinderTest.this.document;
        }

        public Collection<NarrativeType> loadAllNarrativeTypes() {
            return ProposalNarrativeTypeValuesFinderTest.this.allNarrativeTypes;
        }
    }

    private class MockNarrative
    extends Narrative {
        private MockNarrative() {
        }

        protected String findLoggedInUserPersonId() {
            return ProposalNarrativeTypeValuesFinderTest.QUICKSTART;
        }
    }
}

