/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.proposaldevelopment.budget.modular.BudgetModular;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.rules.BudgetModularTotalDirectCostRule;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.impl.ConfigurationServiceImpl;
import org.kuali.rice.krad.service.impl.DocumentServiceImpl;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class BudgetModularTotalDirectCostRuleTest
extends KcUnitTestBase {
    private static final List<BudgetDocumentVersion> ONE_COMPLETE = new ArrayList<BudgetDocumentVersion>();
    private static final List<BudgetDocumentVersion> TWO_COMPLETE = new ArrayList<BudgetDocumentVersion>();
    private static final List<BudgetDocumentVersion> ONE_INCOMPLETE = new ArrayList<BudgetDocumentVersion>();
    private static final List<BudgetDocumentVersion> TWO_INCOMPLETE = new ArrayList<BudgetDocumentVersion>();
    private ProposalDevelopmentDocument pdDocument;

    @Override
    @Before
    public void setUp() throws Exception {
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        this.pdDocument = new ProposalDevelopmentDocument();
        this.pdDocument.getDocumentHeader().setDocumentDescription(this.getClass().getName());
        this.pdDocument.getDevelopmentProposal().setSponsorCode("005889");
        this.pdDocument.getDevelopmentProposal().setTitle("Project title");
        this.pdDocument.getDevelopmentProposal().setRequestedStartDateInitial(new Date(Calendar.getInstance().getTime().getTime()));
        this.pdDocument.getDevelopmentProposal().setRequestedEndDateInitial(new Date(Calendar.getInstance().getTime().getTime()));
        this.pdDocument.getDevelopmentProposal().setActivityTypeCode("1");
        this.pdDocument.getDevelopmentProposal().setProposalTypeCode("1");
        this.pdDocument.getDevelopmentProposal().setOwnedByUnitNumber("000001");
    }

    private String getWarning(final BudgetModularTotalDirectCostRule rule) {
        try {
            final Field warning = BudgetModularTotalDirectCostRule.class.getDeclaredField("tdcWarning");
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    try {
                        warning.setAccessible(true);
                        return (String)warning.get(rule);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test(expected=NullPointerException.class)
    public void testNullConfigService() {
        new BudgetModularTotalDirectCostRule((ConfigurationService)new ConfigurationServiceImpl(), null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testNullDocu() {
        new BudgetModularTotalDirectCostRule(null, (DocumentService)new DocumentServiceImpl(), null);
    }

    @Test(expected=NullPointerException.class)
    public void testNullDocument() {
        DocumentServiceImpl service = new DocumentServiceImpl(){

            public BudgetDocument getByDocumentHeaderId(String documentHeaderId) {
                return new BudgetDocument();
            }
        };
        BudgetModularTotalDirectCostRule rule = new BudgetModularTotalDirectCostRule(KRADServiceLocator.getKualiConfigurationService(), (DocumentService)service, CoreFrameworkServiceLocator.getParameterService());
        rule.validateTotalDirectCost(null, true, new HashSet());
    }

    @Test(expected=NullPointerException.class)
    public void testNullWarnings() {
        DocumentServiceImpl service = new DocumentServiceImpl(){

            public BudgetDocument getByDocumentHeaderId(String documentHeaderId) {
                return new BudgetDocument();
            }
        };
        BudgetModularTotalDirectCostRule rule = new BudgetModularTotalDirectCostRule(KRADServiceLocator.getKualiConfigurationService(), (DocumentService)service, CoreFrameworkServiceLocator.getParameterService());
        rule.validateTotalDirectCost((BudgetParentDocument)this.pdDocument, true, null);
    }

    private void testNoErrors(DocumentService service) {
        this.pdDocument.setBudgetDocumentVersions(ONE_COMPLETE);
        BudgetModularTotalDirectCostRule rule = new BudgetModularTotalDirectCostRule(KRADServiceLocator.getKualiConfigurationService(), service, CoreFrameworkServiceLocator.getParameterService());
        HashSet warnings = new HashSet();
        rule.validateTotalDirectCost((BudgetParentDocument)this.pdDocument, true, warnings);
        Assert.assertTrue((String)("The validation should not have produced any errors " + GlobalVariables.getMessageMap()), (boolean)GlobalVariables.getMessageMap().hasNoErrors());
        Assert.assertTrue((String)("The validation should not have produced any warnings " + warnings), (boolean)warnings.isEmpty());
        warnings = new HashSet();
        this.pdDocument.setBudgetDocumentVersions(TWO_COMPLETE);
        rule.validateTotalDirectCost((BudgetParentDocument)this.pdDocument, true, warnings);
        Assert.assertTrue((String)("The validation should not have produced any errors " + GlobalVariables.getMessageMap()), (boolean)GlobalVariables.getMessageMap().hasNoErrors());
        Assert.assertTrue((String)("The validation should not have produced any warnings " + warnings), (boolean)warnings.isEmpty());
    }

    @Test
    public void testNotCompleteWithErrors() {
        DocumentServiceImpl service = new DocumentServiceImpl(){

            public BudgetDocument getByDocumentHeaderId(String documentHeaderId) {
                BudgetDocument doc = new BudgetDocument();
                doc.getBudget().setModularBudgetFlag(Boolean.TRUE);
                ArrayList<BudgetPeriod> periods = new ArrayList<BudgetPeriod>();
                BudgetPeriod period1 = new BudgetPeriod();
                BudgetModular modular1 = new BudgetModular();
                modular1.setTotalDirectCost(BudgetDecimal.ZERO);
                period1.setBudgetModular(modular1);
                periods.add(period1);
                doc.getBudget().setBudgetPeriods(periods);
                return doc;
            }
        };
        this.pdDocument.setBudgetDocumentVersions(ONE_INCOMPLETE);
        BudgetModularTotalDirectCostRule rule = new BudgetModularTotalDirectCostRule(KRADServiceLocator.getKualiConfigurationService(), (DocumentService)service, CoreFrameworkServiceLocator.getParameterService());
        HashSet warnings = new HashSet();
        rule.validateTotalDirectCost((BudgetParentDocument)this.pdDocument, true, warnings);
        Assert.assertTrue((String)("The validation should not have produced any errors " + GlobalVariables.getMessageMap()), (boolean)GlobalVariables.getMessageMap().hasNoErrors());
        Assert.assertTrue((String)("The validation should not have produced any warnings " + warnings), (boolean)warnings.isEmpty());
        warnings = new HashSet();
        this.pdDocument.setBudgetDocumentVersions(TWO_INCOMPLETE);
        rule.validateTotalDirectCost((BudgetParentDocument)this.pdDocument, true, warnings);
        Assert.assertTrue((String)("The validation should not have produced any errors " + GlobalVariables.getMessageMap()), (boolean)GlobalVariables.getMessageMap().hasNoErrors());
        Assert.assertTrue((String)("The validation should not have produced any warnings " + warnings), (boolean)warnings.isEmpty());
    }

    @Test
    public void testNotModularWithErrors() {
        DocumentServiceImpl service = new DocumentServiceImpl(){

            public BudgetDocument getByDocumentHeaderId(String documentHeaderId) {
                BudgetDocument doc = new BudgetDocument();
                doc.getBudget().setModularBudgetFlag(Boolean.FALSE);
                ArrayList<BudgetPeriod> periods = new ArrayList<BudgetPeriod>();
                BudgetPeriod period1 = new BudgetPeriod();
                BudgetModular modular1 = new BudgetModular();
                modular1.setTotalDirectCost(new BudgetDecimal(1));
                period1.setBudgetModular(modular1);
                periods.add(period1);
                doc.getBudget().setBudgetPeriods(periods);
                return doc;
            }
        };
        this.testNoErrors((DocumentService)service);
    }

    @Test
    public void testOnePeriodPositve() {
        DocumentServiceImpl service = new DocumentServiceImpl(){

            public BudgetDocument getByDocumentHeaderId(String documentHeaderId) {
                BudgetDocument doc = new BudgetDocument();
                doc.getBudget().setModularBudgetFlag(Boolean.TRUE);
                ArrayList<BudgetPeriod> periods = new ArrayList<BudgetPeriod>();
                BudgetPeriod period1 = new BudgetPeriod();
                BudgetModular modular1 = new BudgetModular();
                modular1.setTotalDirectCost(new BudgetDecimal(1));
                period1.setBudgetModular(modular1);
                periods.add(period1);
                doc.getBudget().setBudgetPeriods(periods);
                return doc;
            }
        };
        this.testNoErrors((DocumentService)service);
    }

    @Test
    public void testMultPeriodPositive() {
        DocumentServiceImpl service = new DocumentServiceImpl(){

            public BudgetDocument getByDocumentHeaderId(String documentHeaderId) {
                BudgetDocument doc = new BudgetDocument();
                doc.getBudget().setModularBudgetFlag(Boolean.TRUE);
                ArrayList<BudgetPeriod> periods = new ArrayList<BudgetPeriod>();
                BudgetPeriod period1 = new BudgetPeriod();
                BudgetModular modular1 = new BudgetModular();
                modular1.setTotalDirectCost(new BudgetDecimal(1));
                period1.setBudgetModular(modular1);
                periods.add(period1);
                BudgetPeriod period2 = new BudgetPeriod();
                BudgetModular modular2 = new BudgetModular();
                modular2.setTotalDirectCost(new BudgetDecimal(0.1));
                period2.setBudgetModular(modular2);
                periods.add(period2);
                doc.getBudget().setBudgetPeriods(periods);
                return doc;
            }
        };
        this.testNoErrors((DocumentService)service);
    }

    @Test
    public void testNullPeriods() {
        DocumentServiceImpl service = new DocumentServiceImpl(){

            public BudgetDocument getByDocumentHeaderId(String documentHeaderId) {
                BudgetDocument doc = new BudgetDocument();
                doc.getBudget().setModularBudgetFlag(Boolean.TRUE);
                ArrayList<Object> periods = new ArrayList<Object>();
                periods.add(null);
                periods.add(null);
                doc.getBudget().setBudgetPeriods(periods);
                return doc;
            }
        };
        this.testNoErrors((DocumentService)service);
    }

    @Test
    public void testNullModular() {
        DocumentServiceImpl service = new DocumentServiceImpl(){

            public BudgetDocument getByDocumentHeaderId(String documentHeaderId) {
                BudgetDocument doc = new BudgetDocument();
                doc.getBudget().setModularBudgetFlag(Boolean.TRUE);
                ArrayList<BudgetPeriod> periods = new ArrayList<BudgetPeriod>();
                BudgetPeriod period1 = new BudgetPeriod();
                period1.setBudgetModular(null);
                periods.add(period1);
                BudgetPeriod period2 = new BudgetPeriod();
                period2.setBudgetModular(null);
                periods.add(period2);
                doc.getBudget().setBudgetPeriods(periods);
                return doc;
            }
        };
        this.pdDocument.setBudgetDocumentVersions(ONE_COMPLETE);
        BudgetModularTotalDirectCostRule rule = new BudgetModularTotalDirectCostRule(KRADServiceLocator.getKualiConfigurationService(), (DocumentService)service, CoreFrameworkServiceLocator.getParameterService());
        HashSet warnings = new HashSet();
        rule.validateTotalDirectCost((BudgetParentDocument)this.pdDocument, true, warnings);
        Assert.assertEquals((String)("Only one error should have been produced, count " + GlobalVariables.getMessageMap().getErrorMessages().size()), (long)1L, (long)GlobalVariables.getMessageMap().getErrorMessages().size());
        Assert.assertEquals((String)("Only one warning should have been produced, count " + warnings.size()), (long)1L, (long)warnings.size());
        Assert.assertTrue((String)("The warning was incorrect, warning: " + warnings), (boolean)warnings.contains(this.getWarning(rule)));
        this.pdDocument.setBudgetDocumentVersions(TWO_COMPLETE);
        rule = new BudgetModularTotalDirectCostRule(KRADServiceLocator.getKualiConfigurationService(), (DocumentService)service, CoreFrameworkServiceLocator.getParameterService());
        warnings = new HashSet();
        rule.validateTotalDirectCost((BudgetParentDocument)this.pdDocument, true, warnings);
        Assert.assertEquals((String)("Only 2 error3 should have been produced, count " + GlobalVariables.getMessageMap().getErrorMessages().size()), (long)2L, (long)GlobalVariables.getMessageMap().getErrorMessages().size());
        Assert.assertEquals((String)("Only one warning should have been produced, count " + warnings.size()), (long)1L, (long)warnings.size());
        Assert.assertTrue((String)("The warning was incorrect, warning: " + warnings), (boolean)warnings.contains(this.getWarning(rule)));
    }

    @Test
    public void testTdcErrors() {
        DocumentServiceImpl service = new DocumentServiceImpl(){

            public BudgetDocument getByDocumentHeaderId(String documentHeaderId) {
                BudgetDocument doc = new BudgetDocument();
                doc.getBudget().setModularBudgetFlag(Boolean.TRUE);
                ArrayList<BudgetPeriod> periods = new ArrayList<BudgetPeriod>();
                BudgetPeriod period1 = new BudgetPeriod();
                BudgetModular modular1 = new BudgetModular();
                modular1.setTotalDirectCost(new BudgetDecimal(0));
                period1.setBudgetModular(modular1);
                periods.add(period1);
                BudgetPeriod period2 = new BudgetPeriod();
                BudgetModular modular2 = new BudgetModular();
                modular2.setTotalDirectCost(BudgetDecimal.ZERO);
                period2.setBudgetModular(modular2);
                periods.add(period2);
                doc.getBudget().setBudgetPeriods(periods);
                return doc;
            }
        };
        this.pdDocument.setBudgetDocumentVersions(ONE_COMPLETE);
        BudgetModularTotalDirectCostRule rule = new BudgetModularTotalDirectCostRule(KRADServiceLocator.getKualiConfigurationService(), (DocumentService)service, CoreFrameworkServiceLocator.getParameterService());
        HashSet warnings = new HashSet();
        rule.validateTotalDirectCost((BudgetParentDocument)this.pdDocument, true, warnings);
        Assert.assertEquals((String)("Only one warning should have been produced, count " + warnings.size()), (long)1L, (long)warnings.size());
        Assert.assertTrue((String)("The warning was incorrect, warning: " + warnings), (boolean)warnings.contains(this.getWarning(rule)));
        Assert.assertEquals((String)("Only one error should have been produced, count " + GlobalVariables.getMessageMap().getErrorMessages().size()), (long)1L, (long)GlobalVariables.getMessageMap().getErrorMessages().size());
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.pdDocument.setBudgetDocumentVersions(TWO_COMPLETE);
        rule = new BudgetModularTotalDirectCostRule(KRADServiceLocator.getKualiConfigurationService(), (DocumentService)service, CoreFrameworkServiceLocator.getParameterService());
        warnings = new HashSet();
        rule.validateTotalDirectCost((BudgetParentDocument)this.pdDocument, true, warnings);
        Assert.assertEquals((String)("Only one warning should have been produced, count " + warnings.size()), (long)1L, (long)warnings.size());
        Assert.assertTrue((String)("The warning was incorrect, warning: " + warnings), (boolean)warnings.contains(this.getWarning(rule)));
        Assert.assertEquals((String)("Only 2 error should have been produced, count " + GlobalVariables.getMessageMap().getErrorMessages().size()), (long)2L, (long)GlobalVariables.getMessageMap().getErrorMessages().size());
    }

    @Test
    public void testTdcWarning() {
        DocumentServiceImpl service = new DocumentServiceImpl(){

            public BudgetDocument getByDocumentHeaderId(String documentHeaderId) {
                BudgetDocument doc = new BudgetDocument();
                doc.getBudget().setModularBudgetFlag(Boolean.TRUE);
                ArrayList<BudgetPeriod> periods = new ArrayList<BudgetPeriod>();
                BudgetPeriod period1 = new BudgetPeriod();
                BudgetModular modular1 = new BudgetModular();
                modular1.setTotalDirectCost(new BudgetDecimal(1));
                period1.setBudgetModular(modular1);
                periods.add(period1);
                BudgetPeriod period2 = new BudgetPeriod();
                BudgetModular modular2 = new BudgetModular();
                modular2.setTotalDirectCost(BudgetDecimal.ZERO);
                period2.setBudgetModular(modular2);
                periods.add(period2);
                doc.getBudget().setBudgetPeriods(periods);
                return doc;
            }
        };
        this.pdDocument.setBudgetDocumentVersions(ONE_COMPLETE);
        BudgetModularTotalDirectCostRule rule = new BudgetModularTotalDirectCostRule(KRADServiceLocator.getKualiConfigurationService(), (DocumentService)service, CoreFrameworkServiceLocator.getParameterService());
        HashSet warnings = new HashSet();
        rule.validateTotalDirectCost((BudgetParentDocument)this.pdDocument, true, warnings);
        Assert.assertTrue((String)("The validation should not have produced any errors " + GlobalVariables.getMessageMap()), (boolean)GlobalVariables.getMessageMap().hasNoErrors());
        Assert.assertEquals((String)("Only one warning should have been produced, count " + warnings.size()), (long)1L, (long)warnings.size());
        Assert.assertTrue((String)("The warning was incorrect, warning: " + warnings), (boolean)warnings.contains(this.getWarning(rule)));
        this.pdDocument.setBudgetDocumentVersions(ONE_COMPLETE);
        rule = new BudgetModularTotalDirectCostRule(KRADServiceLocator.getKualiConfigurationService(), (DocumentService)service, CoreFrameworkServiceLocator.getParameterService());
        warnings = new HashSet();
        rule.validateTotalDirectCost((BudgetParentDocument)this.pdDocument, true, warnings);
        Assert.assertTrue((String)("The validation should not have produced any errors " + GlobalVariables.getMessageMap()), (boolean)GlobalVariables.getMessageMap().hasNoErrors());
        Assert.assertEquals((String)("Only one warning shoudld have been produced, count " + warnings.size()), (long)1L, (long)warnings.size());
        Assert.assertTrue((String)("The warning was incorrect, warning: " + warnings), (boolean)warnings.contains(this.getWarning(rule)));
    }

    static {
        BudgetDocumentVersion docver1 = new BudgetDocumentVersion();
        BudgetVersionOverview overview1 = docver1.getBudgetVersionOverview();
        overview1.setBudgetStatus("1");
        overview1.setDocumentNumber("1234");
        BudgetDocumentVersion docver2 = new BudgetDocumentVersion();
        BudgetVersionOverview overview2 = docver2.getBudgetVersionOverview();
        overview2.setBudgetStatus("1");
        overview2.setDocumentNumber("1234");
        BudgetDocumentVersion docver3 = new BudgetDocumentVersion();
        BudgetVersionOverview overview3 = docver3.getBudgetVersionOverview();
        overview3.setBudgetStatus("2");
        overview3.setDocumentNumber("1234");
        BudgetDocumentVersion docver4 = new BudgetDocumentVersion();
        BudgetVersionOverview overview4 = docver4.getBudgetVersionOverview();
        overview4.setBudgetStatus("2");
        overview4.setDocumentNumber("1234");
        ONE_COMPLETE.add(docver1);
        TWO_COMPLETE.add(docver2);
        TWO_COMPLETE.add(docver2);
        ONE_INCOMPLETE.add(docver3);
        TWO_INCOMPLETE.add(docver3);
        TWO_INCOMPLETE.add(docver4);
    }
}

