/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.budget.versions.AddBudgetVersionEvent;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.budget.versions.BudgetVersionCollection;
import org.kuali.kra.budget.versions.BudgetVersionRule;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.DocumentBase;
import org.kuali.rice.krad.rules.rule.BusinessRule;

public class BudgetVersionRuleTest {
    private static final String VERSION_NAME = "test version";
    private static final String DEFAULT_BUD_VER_NAME = "Default Budget Name";
    private BudgetVersionCollection proposal;

    @Before
    public void setUp() throws Exception {
        this.proposal = new PseudoProposalDevelopmentDocument();
    }

    @Test
    public void testExistingBudgetVersion() {
        this.addNewBudgetVersion(this.proposal, VERSION_NAME);
        boolean ruleStatus = new AddBudgetVersionEvent("", (Document)this.proposal, VERSION_NAME).invokeRuleMethod((BusinessRule)new BudgetVersionRule());
        Assert.assertFalse((boolean)ruleStatus);
    }

    @Test
    public void testNewBudgetVersion() {
        boolean ruleStatus = new AddBudgetVersionEvent("", (Document)this.proposal, VERSION_NAME).invokeRuleMethod((BusinessRule)new BudgetVersionRule());
        Assert.assertTrue((boolean)ruleStatus);
    }

    @Test
    public void testOK() throws Exception {
        Assert.assertTrue((boolean)new AddBudgetVersionEvent("", (Document)this.proposal, DEFAULT_BUD_VER_NAME).invokeRuleMethod((BusinessRule)new BudgetVersionRule()));
    }

    @Test
    public void testNegativeNullName() throws Exception {
        Assert.assertFalse((boolean)new AddBudgetVersionEvent("", (Document)this.proposal, (String)null).invokeRuleMethod((BusinessRule)new BudgetVersionRule()));
    }

    @Test
    public void testNegativeEmptyName() throws Exception {
        Assert.assertFalse((boolean)new AddBudgetVersionEvent("", (Document)this.proposal, "").invokeRuleMethod((BusinessRule)new BudgetVersionRule()));
    }

    public void addNewBudgetVersion(BudgetVersionCollection document, String name) {
        document.getBudgetDocumentVersions().add(new PseudoBudgetVersionOverview(name));
    }

    public class PseudoProposalDevelopmentDocument
    extends DocumentBase
    implements BudgetVersionCollection {
        private List<BudgetDocumentVersion> overviews;

        public PseudoProposalDevelopmentDocument() {
            this.setBudgetDocumentVersions(new ArrayList<BudgetDocumentVersion>());
        }

        public List<BudgetDocumentVersion> getBudgetDocumentVersions() {
            return this.overviews;
        }

        public void setBudgetDocumentVersions(List<BudgetDocumentVersion> budgetVersionOverviews) {
            this.overviews = budgetVersionOverviews;
        }

        public void refreshBudgetDocumentVersions() {
        }
    }

    public class PseudoBudgetVersionOverview
    extends BudgetDocumentVersion {
        public PseudoBudgetVersionOverview(String name) {
        }
    }
}

