/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.rules.CreditSplitValidator;
import org.kuali.kra.test.fixtures.ProposalDevelopmentDocumentFixture;
import org.kuali.kra.test.fixtures.ProposalPersonFixture;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;

public class CreditSplitValidatorTest
extends KcUnitTestBase {
    private static final Log LOG = LogFactory.getLog(CreditSplitValidatorTest.class);
    private CreditSplitValidator validator;
    private ProposalDevelopmentDocument document;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        KNSGlobalVariables.setAuditErrorMap(new HashMap());
        this.validator = new CreditSplitValidator();
        this.validator = this.validator.getProxy(this.validator);
        this.document = ProposalDevelopmentDocumentFixture.NORMAL_DOCUMENT.getDocument();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void validProposalInvestigatorNormal() throws Exception {
        LOG.info((Object)"Starting validProposalInvetigatorNormal");
        ProposalPerson person1 = ProposalPersonFixture.INVESTIGATOR_SPLIT_ADDS_TO_ONE_HUNDRED.getPerson();
        ProposalPersonFixture.INVESTIGATOR_SPLIT_ADDS_TO_ONE_HUNDRED.populatePerson(this.document, person1);
        this.document.getDevelopmentProposal().addProposalPerson(person1);
        CreditSplitValidatorTest.assertTrue((String)"Audit Rule shouldn't produce audit errors", (boolean)this.validator.validate(this.document));
        CreditSplitValidatorTest.assertEquals((long)0L, (long)KNSGlobalVariables.getAuditErrorMap().size());
        LOG.info((Object)"Ending validProposalInvetigatorNormal");
    }

    @Test
    public void invalidProposalInvestigatorFail() throws Exception {
        ProposalDevelopmentDocument document = ProposalDevelopmentDocumentFixture.NORMAL_DOCUMENT.getDocument();
        ProposalPerson person = ProposalPersonFixture.INVESTIGATOR_UNIT_NOT_TO_ONE_HUNDRED.getPerson();
        document.getDevelopmentProposal().addProposalPerson(person);
        ProposalPersonFixture.INVESTIGATOR_UNIT_NOT_TO_ONE_HUNDRED.populatePerson(document, person);
        CreditSplitValidatorTest.assertFalse((String)"Audit Rule should produce audit errors", (boolean)this.validator.validate(document));
        CreditSplitValidatorTest.assertFalse((KNSGlobalVariables.getAuditErrorMap().size() < 1 ? 1 : 0) != 0);
    }

    @Test
    public void invalidProposalInvestigatorOverHundred() throws Exception {
        ProposalDevelopmentDocument document = ProposalDevelopmentDocumentFixture.NORMAL_DOCUMENT.getDocument();
        ProposalPerson person = ProposalPersonFixture.INVESTIGATOR_OVER_ONE_HUNDRED.getPerson();
        document.getDevelopmentProposal().addProposalPerson(person);
        ProposalPersonFixture.INVESTIGATOR_OVER_ONE_HUNDRED.populatePerson(document, person);
        CreditSplitValidatorTest.assertFalse((String)"Audit Rule should produce audit errors", (boolean)this.validator.validate(document));
        CreditSplitValidatorTest.assertFalse((KNSGlobalVariables.getAuditErrorMap().size() < 1 ? 1 : 0) != 0);
    }

    @Test
    public void invalidProposalInvestigatorUnderZero() throws Exception {
        ProposalDevelopmentDocument document = ProposalDevelopmentDocumentFixture.NORMAL_DOCUMENT.getDocument();
        ProposalPerson person = ProposalPersonFixture.INVESTIGATOR_UNDER_ZERO.getPerson();
        document.getDevelopmentProposal().addProposalPerson(person);
        ProposalPersonFixture.INVESTIGATOR_UNDER_ZERO.populatePerson(document, person);
        CreditSplitValidatorTest.assertFalse((String)"Audit Rule should produce audit errors", (boolean)this.validator.validate(document));
        CreditSplitValidatorTest.assertFalse((KNSGlobalVariables.getAuditErrorMap().size() < 1 ? 1 : 0) != 0);
    }

    @Test
    public void invalidProposalInvestigatorUnitsUnderZero() throws Exception {
        ProposalDevelopmentDocument document = ProposalDevelopmentDocumentFixture.NORMAL_DOCUMENT.getDocument();
        ProposalPerson person = ProposalPersonFixture.INVESTIGATOR_UNIT_UNDER_ZERO.getPerson();
        document.getDevelopmentProposal().addProposalPerson(person);
        ProposalPersonFixture.INVESTIGATOR_UNIT_UNDER_ZERO.populatePerson(document, person);
        CreditSplitValidatorTest.assertFalse((String)"Audit Rule should produce audit errors", (boolean)this.validator.validate(document));
        CreditSplitValidatorTest.assertFalse((KNSGlobalVariables.getAuditErrorMap().size() < 1 ? 1 : 0) != 0);
    }

    @Test
    public void invalidProposalInvestigatorUnitsOverHundred() throws Exception {
        ProposalDevelopmentDocument document = ProposalDevelopmentDocumentFixture.NORMAL_DOCUMENT.getDocument();
        ProposalPerson person = ProposalPersonFixture.INVESTIGATOR_UNIT_OVER_ONE_HUNDRED.getPerson();
        document.getDevelopmentProposal().addProposalPerson(person);
        ProposalPersonFixture.INVESTIGATOR_UNIT_OVER_ONE_HUNDRED.populatePerson(document, person);
        CreditSplitValidatorTest.assertFalse((String)"Audit Rule should produce audit errors", (boolean)this.validator.validate(document));
        CreditSplitValidatorTest.assertFalse((KNSGlobalVariables.getAuditErrorMap().size() < 1 ? 1 : 0) != 0);
    }
}

