/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.maintenance.MaintenanceRuleTestBase;
import org.kuali.kra.proposaldevelopment.bo.InvestigatorCreditType;
import org.kuali.kra.proposaldevelopment.rules.InvestigatorCreditTypeFixture;
import org.kuali.kra.proposaldevelopment.rules.InvestigatorCreditTypeRule;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;

public class InvestigatorCreditTypeRuleTest
extends MaintenanceRuleTestBase {
    private static final InvestigatorCreditTypeFixture RECOGNITION = InvestigatorCreditTypeFixture.RECOGNITION;
    private static final InvestigatorCreditTypeFixture RESPONSIBILITY = InvestigatorCreditTypeFixture.RESPONSIBILITY;
    private static final InvestigatorCreditTypeFixture SPACE = InvestigatorCreditTypeFixture.SPACE;
    private static final InvestigatorCreditTypeFixture NEGLIGENCE = InvestigatorCreditTypeFixture.NEGLIGENCE;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void processCustomRouteDocumentBusinessRules_ExistingField() throws Exception {
        InvestigatorCreditType creditType = SPACE.getInstance();
        MaintenanceDocument creditTypeDocument = this.newMaintDoc((PersistableBusinessObject)creditType);
        InvestigatorCreditTypeRule rule = this.setupMaintDocRule(creditTypeDocument, InvestigatorCreditTypeRule.class);
        InvestigatorCreditTypeRuleTest.assertTrue((boolean)rule.processCustomRouteDocumentBusinessRules(creditTypeDocument));
    }

    @Test
    public void processCustomRouteDocumentBusinessRules_Normal() throws Exception {
        InvestigatorCreditType creditType = NEGLIGENCE.getInstance();
        MaintenanceDocument creditTypeDocument = this.newMaintDoc((PersistableBusinessObject)creditType);
        InvestigatorCreditTypeRule rule = this.setupMaintDocRule(creditTypeDocument, InvestigatorCreditTypeRule.class);
        InvestigatorCreditTypeRuleTest.assertTrue((boolean)rule.processCustomRouteDocumentBusinessRules(creditTypeDocument));
    }
}

