/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.PersonEditableField;
import org.kuali.kra.logging.FormattedLogger;
import org.kuali.kra.maintenance.MaintenanceRuleTestBase;
import org.kuali.kra.proposaldevelopment.rules.PersonEditableFieldFixture;
import org.kuali.kra.proposaldevelopment.rules.PersonEditableFieldRule;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;

public class PersonEditableFieldRuleTest
extends MaintenanceRuleTestBase {
    private static final PersonEditableFieldFixture ADDRESS_LINE1_FIELD = PersonEditableFieldFixture.ADDRESS_LINE1_FIELD;
    private static final PersonEditableFieldFixture ADDRESS_LINE2_FIELD = PersonEditableFieldFixture.ADDRESS_LINE2_FIELD;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void processCustomRouteDocumentBusinessRules_ExistingField() throws Exception {
        PersonEditableField editableField = ADDRESS_LINE1_FIELD.getInstance();
        MaintenanceDocument editableFieldDocument = this.newMaintDoc((PersistableBusinessObject)editableField);
        PersonEditableFieldRule rule = this.setupMaintDocRule(editableFieldDocument, PersonEditableFieldRule.class);
        PersonEditableFieldRuleTest.assertTrue((boolean)rule.processCustomRouteDocumentBusinessRules(editableFieldDocument));
    }

    @Test
    public void processCustomRouteDocumentBusinessRules_Normal() throws Exception {
        PersonEditableField editableField = ADDRESS_LINE2_FIELD.getInstance();
        MaintenanceDocument editableFieldDocument = this.newMaintDoc((PersistableBusinessObject)editableField);
        PersonEditableFieldRule rule = this.setupMaintDocRule(editableFieldDocument, PersonEditableFieldRule.class);
        FormattedLogger.info((String)"pass %s", (Object[])new Object[]{rule.processCustomRouteDocumentBusinessRules(editableFieldDocument)});
    }
}

