/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.proposaldevelopment.bo.ProposalAbstract;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentAbstractsRule;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentRuleTestBase;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.AutoPopulatingList;

public class ProposalDevelopmentAbstractsRuleTest
extends ProposalDevelopmentRuleTestBase {
    private ProposalDevelopmentAbstractsRule rule = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new ProposalDevelopmentAbstractsRule();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        super.tearDown();
    }

    @Test
    public void testOK() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        ProposalAbstract proposalAbstract = new ProposalAbstract();
        proposalAbstract.setAbstractTypeCode("1");
        ProposalDevelopmentAbstractsRuleTest.assertTrue((boolean)this.rule.processAddAbstractBusinessRules(document, proposalAbstract));
    }

    @Test
    public void testUnspecifiedAbstractType() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        ProposalAbstract proposalAbstract = new ProposalAbstract();
        proposalAbstract.setAbstractTypeCode("");
        ProposalDevelopmentAbstractsRuleTest.assertFalse((boolean)this.rule.processAddAbstractBusinessRules(document, proposalAbstract));
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages("newProposalAbstract.abstractTypeCode");
        ProposalDevelopmentAbstractsRuleTest.assertNotNull((Object)errors);
        ProposalDevelopmentAbstractsRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        ProposalDevelopmentAbstractsRuleTest.assertNotNull((Object)message);
        ProposalDevelopmentAbstractsRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.abstractType.notselected");
    }

    @Test
    public void testInvalidAbstractType() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        ProposalAbstract proposalAbstract = new ProposalAbstract();
        proposalAbstract.setAbstractTypeCode("20");
        ProposalDevelopmentAbstractsRuleTest.assertFalse((boolean)this.rule.processAddAbstractBusinessRules(document, proposalAbstract));
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages("newProposalAbstract");
        ProposalDevelopmentAbstractsRuleTest.assertNotNull((Object)errors);
        ProposalDevelopmentAbstractsRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        ProposalDevelopmentAbstractsRuleTest.assertNotNull((Object)message);
        ProposalDevelopmentAbstractsRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.abstractType.invalid");
    }

    @Test
    public void testDuplicateAbstractType() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        this.addAbstract(document, "1");
        ProposalAbstract proposalAbstract = new ProposalAbstract();
        proposalAbstract.setAbstractTypeCode("1");
        ProposalDevelopmentAbstractsRuleTest.assertFalse((boolean)this.rule.processAddAbstractBusinessRules(document, proposalAbstract));
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages("newProposalAbstract");
        ProposalDevelopmentAbstractsRuleTest.assertNotNull((Object)errors);
        ProposalDevelopmentAbstractsRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        ProposalDevelopmentAbstractsRuleTest.assertNotNull((Object)message);
        ProposalDevelopmentAbstractsRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.abstractType.duplicate");
    }

    private void addAbstract(ProposalDevelopmentDocument document, String abstractTypeCode) {
        List abstracts = document.getDevelopmentProposal().getProposalAbstracts();
        ProposalAbstract proposalAbstract = new ProposalAbstract();
        proposalAbstract.setAbstractTypeCode("1");
        abstracts.add(proposalAbstract);
    }
}

