/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.util.HashMap;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.NarrativeStatus;
import org.kuali.kra.proposaldevelopment.bo.NarrativeType;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.rule.event.AddInstituteAttachmentEvent;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentInstituteAttachmentRule;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentRuleTestBase;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.AutoPopulatingList;

public class ProposalDevelopmentInstituteAttachmentRuleTest
extends ProposalDevelopmentRuleTestBase {
    private static final String NEW_INSTITUTE_ATTACHMENT = "newInstituteAttachment";
    private static final String FILE_NAME = "document.instituteAttachment[0].fileName";
    private static final String EMPTY_STRING = "";
    private static final String ALLOW_MULTIPLE = "allowMultiple";
    private static final String NO = "N";
    private static final String SYSTEM_GENERATED = "systemGenerated";
    private static final String NARRATIVE_TYPE_GROUP = "narrativeTypeGroup";
    private static final String STRING_151_CHARS_LONG = "Lorem ipsum dolor sit amet consectetur adipiscing elit. Suspendisse quis tortor. Morbi sollicitudin leo a faucibus aliquet nisl velit vulputate sed awk.";
    private ProposalDevelopmentInstituteAttachmentRule rule = null;
    private List<NarrativeType> narrativeTypes;
    private List<NarrativeStatus> narrativeStatuses;
    private BusinessObjectService bos;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new ProposalDevelopmentInstituteAttachmentRule();
        this.bos = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> qMap = new HashMap<String, String>();
        qMap.put(SYSTEM_GENERATED, NO);
        qMap.put(NARRATIVE_TYPE_GROUP, "O");
        this.narrativeTypes = (List)this.bos.findMatchingOrderBy(NarrativeType.class, qMap, ALLOW_MULTIPLE, true);
        this.narrativeStatuses = (List)this.bos.findAll(NarrativeStatus.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        this.bos = null;
        this.narrativeTypes = null;
        this.narrativeStatuses = null;
        super.tearDown();
    }

    @Test
    public void testNarrativeTypesAndStatuses() throws Exception {
        ProposalDevelopmentInstituteAttachmentRuleTest.assertNotNull(this.narrativeTypes);
        ProposalDevelopmentInstituteAttachmentRuleTest.assertNotNull(this.narrativeStatuses);
        ProposalDevelopmentInstituteAttachmentRuleTest.assertTrue((this.narrativeTypes.size() > 1 ? 1 : 0) != 0);
        ProposalDevelopmentInstituteAttachmentRuleTest.assertTrue((this.narrativeStatuses.size() > 1 ? 1 : 0) != 0);
    }

    @Test
    public void testOK() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        Narrative newNarrative = new Narrative();
        newNarrative.setNarrativeTypeCode(this.narrativeTypes.get(1).getNarrativeTypeCode());
        newNarrative.setModuleStatusCode("C");
        newNarrative.setFileName("test.dat");
        AddInstituteAttachmentEvent addInstituteAttachmentEvent = new AddInstituteAttachmentEvent(EMPTY_STRING, document, newNarrative);
        ProposalDevelopmentInstituteAttachmentRuleTest.assertTrue((boolean)this.rule.processAddInstituteAttachmentBusinessRules(addInstituteAttachmentEvent));
    }

    @Test
    public void testDescriptionTooLong() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        Narrative newNarrative = new Narrative();
        newNarrative.setNarrativeTypeCode(this.narrativeTypes.get(1).getNarrativeTypeCode());
        newNarrative.setModuleStatusCode("C");
        newNarrative.setFileName("test.dat");
        newNarrative.setModuleTitle(STRING_151_CHARS_LONG);
        AddInstituteAttachmentEvent addInstituteAttachmentEvent = new AddInstituteAttachmentEvent(EMPTY_STRING, document, newNarrative);
        ProposalDevelopmentInstituteAttachmentRuleTest.assertFalse((boolean)this.rule.processAddInstituteAttachmentBusinessRules(addInstituteAttachmentEvent));
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages("newInstituteAttachment.moduleTitle");
        ProposalDevelopmentInstituteAttachmentRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        System.out.println("errors: " + errors.size());
        ErrorMessage message = (ErrorMessage)errors.get(0);
        ProposalDevelopmentInstituteAttachmentRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.maxLength");
    }

    @Test
    public void testUnspecifiedNarrativeType() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        Narrative newNarrative = new Narrative();
        newNarrative.setNarrativeTypeCode(EMPTY_STRING);
        newNarrative.setModuleStatusCode("C");
        newNarrative.setFileName("test.dat");
        AddInstituteAttachmentEvent addInstituteAttachmentEvent = new AddInstituteAttachmentEvent(EMPTY_STRING, document, newNarrative);
        ProposalDevelopmentInstituteAttachmentRuleTest.assertFalse((boolean)this.rule.processAddInstituteAttachmentBusinessRules(addInstituteAttachmentEvent));
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages("newInstituteAttachment.institutionalAttachmentTypeCode");
        ProposalDevelopmentInstituteAttachmentRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        ProposalDevelopmentInstituteAttachmentRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.proposalAttachment.narrativeType.notSelected");
    }

    @Test
    public void testUnspecifiedNarrativeStatus() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        Narrative newNarrative = new Narrative();
        newNarrative.setNarrativeTypeCode(this.narrativeTypes.get(0).getNarrativeTypeCode());
        newNarrative.setModuleStatusCode(EMPTY_STRING);
        newNarrative.setFileName("test.dat");
        AddInstituteAttachmentEvent addInstituteAttachmentEvent = new AddInstituteAttachmentEvent(EMPTY_STRING, document, newNarrative);
        ProposalDevelopmentInstituteAttachmentRuleTest.assertFalse((boolean)this.rule.processAddInstituteAttachmentBusinessRules(addInstituteAttachmentEvent));
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages("newInstituteAttachment.moduleStatusCode");
        ProposalDevelopmentInstituteAttachmentRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        ProposalDevelopmentInstituteAttachmentRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.proposalAttachment.narrativeStatus.notSelected");
    }

    @Test
    public void testDuplicateNarrativeType() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        Narrative narrative = new Narrative();
        Narrative newNarrative = new Narrative();
        narrative.setNarrativeTypeCode(this.narrativeTypes.get(0).getNarrativeTypeCode());
        newNarrative.setNarrativeTypeCode(this.narrativeTypes.get(0).getNarrativeTypeCode());
        narrative.setModuleStatusCode("C");
        newNarrative.setModuleStatusCode("C");
        document.getDevelopmentProposal().getInstituteAttachments().add(narrative);
        AddInstituteAttachmentEvent addInstituteAttachmentEvent = new AddInstituteAttachmentEvent(EMPTY_STRING, document, newNarrative);
        ProposalDevelopmentInstituteAttachmentRuleTest.assertFalse((boolean)this.rule.processAddInstituteAttachmentBusinessRules(addInstituteAttachmentEvent));
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages("newInstituteAttachment.institutionalAttachmentTypeCode");
        ProposalDevelopmentInstituteAttachmentRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        ProposalDevelopmentInstituteAttachmentRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.proposalAttachment.narrativeType.allowMulitple");
    }

    @Test
    public void testFileNameRequired() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        Narrative narrative = new Narrative();
        narrative.setNarrativeTypeCode(this.narrativeTypes.get(0).getNarrativeTypeCode());
        narrative.setModuleStatusCode("C");
        narrative.setModuleTitle("description field");
        AddInstituteAttachmentEvent addInstituteAttachmentEvent = new AddInstituteAttachmentEvent(EMPTY_STRING, document, narrative);
        ProposalDevelopmentInstituteAttachmentRuleTest.assertFalse((boolean)this.rule.processAddInstituteAttachmentBusinessRules(addInstituteAttachmentEvent));
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages("newInstituteAttachment.narrativeFile");
        ProposalDevelopmentInstituteAttachmentRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        ProposalDevelopmentInstituteAttachmentRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.required.for.fileName");
    }
}

