/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.proposaldevelopment.bo.ProposalRoleState;
import org.kuali.kra.proposaldevelopment.bo.ProposalUser;
import org.kuali.kra.proposaldevelopment.bo.ProposalUserEditRoles;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentPermissionsRule;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentRuleTestBase;
import org.kuali.kra.proposaldevelopment.web.bean.ProposalUserRoles;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.AutoPopulatingList;

public class ProposalDevelopmentPermissionsRuleTest
extends ProposalDevelopmentRuleTestBase {
    private ProposalDevelopmentPermissionsRule rule = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new ProposalDevelopmentPermissionsRule();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        super.tearDown();
    }

    @Test
    public void testAddOK() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        List<ProposalUserRoles> proposalUserRolesList = this.getProposalUserRoles();
        ProposalUser proposalUser = this.createProposalUser("majors");
        ProposalDevelopmentPermissionsRuleTest.assertTrue((boolean)this.rule.processAddProposalUserBusinessRules(document, proposalUserRolesList, proposalUser));
    }

    @Test
    public void testAddInvalidUser() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        List<ProposalUserRoles> proposalUserRolesList = this.getProposalUserRoles();
        ProposalUser proposalUser = this.createProposalUser("xxx");
        ProposalDevelopmentPermissionsRuleTest.assertFalse((boolean)this.rule.processAddProposalUserBusinessRules(document, proposalUserRolesList, proposalUser));
        this.assertError("newProposalUser.username", "error.unknown.username");
    }

    @Test
    public void testAddDuplicate() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        List<ProposalUserRoles> proposalUserRolesList = this.getProposalUserRoles();
        ProposalUser proposalUser = this.createProposalUser("quickstart");
        ProposalDevelopmentPermissionsRuleTest.assertFalse((boolean)this.rule.processAddProposalUserBusinessRules(document, proposalUserRolesList, proposalUser));
        this.assertError("newProposalUser.username", "error.duplicate.proposalUser");
    }

    @Test
    public void testDeleteOK() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        List<ProposalUserRoles> proposalUserRolesList = this.getProposalUserRoles();
        ProposalDevelopmentPermissionsRuleTest.assertTrue((boolean)this.rule.processDeleteProposalUserBusinessRules(document, proposalUserRolesList, 1));
    }

    @Test
    public void testDeleteLastAggregator() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        List<ProposalUserRoles> proposalUserRolesList = this.getProposalUserRoles();
        ProposalDevelopmentPermissionsRuleTest.assertFalse((boolean)this.rule.processDeleteProposalUserBusinessRules(document, proposalUserRolesList, 0));
        this.assertError("newProposalUser", "error.last.aggregator");
    }

    @Test
    public void testEditOK() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        List<ProposalUserRoles> proposalUserRolesList = this.getProposalUserRoles();
        ProposalUserEditRoles editRoles = this.createProposalUserEditRoles("chew");
        editRoles.setRoleState("Narrative Writer", Boolean.TRUE);
        ProposalDevelopmentPermissionsRuleTest.assertTrue((boolean)this.rule.processEditProposalUserRolesBusinessRules(document, proposalUserRolesList, editRoles));
    }

    @Test
    public void testEditAggregatorOnly() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        List<ProposalUserRoles> proposalUserRolesList = this.getProposalUserRoles();
        ProposalUserEditRoles editRoles = this.createProposalUserEditRoles("chew");
        editRoles.setRoleState("Aggregator", Boolean.TRUE);
        editRoles.setRoleState("Narrative Writer", Boolean.TRUE);
        ProposalDevelopmentPermissionsRuleTest.assertFalse((boolean)this.rule.processEditProposalUserRolesBusinessRules(document, proposalUserRolesList, editRoles));
        this.assertError("proposalUserEditRole", "error.aggregator.inclusive");
    }

    private ProposalUserEditRoles createProposalUserEditRoles(String username) {
        ProposalUserEditRoles editRoles = new ProposalUserEditRoles();
        editRoles.setUsername(username);
        ArrayList<ProposalRoleState> roleStates = new ArrayList<ProposalRoleState>();
        roleStates.add(new ProposalRoleState("Aggregator"));
        roleStates.add(new ProposalRoleState("Narrative Writer"));
        roleStates.add(new ProposalRoleState("Budget Creator"));
        roleStates.add(new ProposalRoleState("Viewer"));
        editRoles.setRoleStates(roleStates);
        return editRoles;
    }

    @Test
    public void testEditLastAggregator() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        List<ProposalUserRoles> proposalUserRolesList = this.getProposalUserRoles();
        ProposalUserEditRoles editRoles = this.createProposalUserEditRoles("quickstart");
        editRoles.setRoleState("Narrative Writer", Boolean.TRUE);
        ProposalDevelopmentPermissionsRuleTest.assertFalse((boolean)this.rule.processEditProposalUserRolesBusinessRules(document, proposalUserRolesList, editRoles));
        this.assertError("proposalUserEditRole", "error.last.aggregator");
    }

    private List<ProposalUserRoles> getProposalUserRoles() {
        ArrayList<ProposalUserRoles> proposalUserRolesList = new ArrayList<ProposalUserRoles>();
        ProposalUserRoles userRoles = new ProposalUserRoles();
        userRoles.setUsername("quickstart");
        userRoles.addRoleName("Aggregator");
        proposalUserRolesList.add(userRoles);
        userRoles = new ProposalUserRoles();
        userRoles.setUsername("chew");
        userRoles.addRoleName("Viewer");
        proposalUserRolesList.add(userRoles);
        return proposalUserRolesList;
    }

    private ProposalUser createProposalUser(String username) {
        ProposalUser proposalUser = new ProposalUser();
        proposalUser.setUsername(username);
        proposalUser.setRoleName("Aggregator");
        return proposalUser;
    }

    private void assertError(String propertyKey, String errorKey) {
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages(propertyKey);
        ProposalDevelopmentPermissionsRuleTest.assertNotNull((Object)errors);
        ProposalDevelopmentPermissionsRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        ProposalDevelopmentPermissionsRuleTest.assertNotNull((Object)message);
        ProposalDevelopmentPermissionsRuleTest.assertEquals((Object)message.getErrorKey(), (Object)errorKey);
    }
}

