/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.PropPerDocType;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonBiography;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.rule.event.AddPersonnelAttachmentEvent;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentPersonnelAttachmentRule;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentRuleTestBase;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.AutoPopulatingList;

public class ProposalDevelopmentPersonnelAttachmentRuleTest
extends ProposalDevelopmentRuleTestBase {
    private static final String EMPTY_STRING = "";
    private BusinessObjectService bos;
    private ProposalDevelopmentDocument document;
    private List<PropPerDocType> documentTypes;
    private ProposalPersonBiography newProposalPersonBiography;
    private ProposalDevelopmentPersonnelAttachmentRule rule = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new ProposalDevelopmentPersonnelAttachmentRule();
        this.bos = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        this.documentTypes = (List)this.bos.findAll(PropPerDocType.class);
        this.document = this.getNewProposalDevelopmentDocument();
        this.newProposalPersonBiography = this.createNewProposalPersonBiography();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.newProposalPersonBiography = null;
        this.document = null;
        this.rule = null;
        this.bos = null;
        this.documentTypes = null;
        super.tearDown();
    }

    @Test
    public void testDescriptionRequiredForAttachementTypeOther() throws Exception {
        this.newProposalPersonBiography.setDocumentTypeCode(this.findOtherDocumentTypeCode());
        this.newProposalPersonBiography.setDescription(null);
        ProposalDevelopmentPersonnelAttachmentRuleTest.assertFalse((boolean)this.rule.processAddPersonnelAttachmentBusinessRules(this.createAddPersonnelAttachmentEvent()));
        this.checkErrorCountAndContent("description", "error.personnelAttachment.description.required");
    }

    @Test
    public void testFileNameRequired() throws Exception {
        this.newProposalPersonBiography.setFileName(null);
        ProposalDevelopmentPersonnelAttachmentRuleTest.assertFalse((boolean)this.rule.processAddPersonnelAttachmentBusinessRules(this.createAddPersonnelAttachmentEvent()));
        this.checkErrorCountAndContent("personnelAttachmentFile", "error.required.for.fileName");
    }

    @Test
    public void testOK() throws Exception {
        ProposalDevelopmentPersonnelAttachmentRuleTest.assertNotNull(this.documentTypes);
        ProposalDevelopmentPersonnelAttachmentRuleTest.assertTrue((this.documentTypes.size() > 1 ? 1 : 0) != 0);
        ProposalDevelopmentPersonnelAttachmentRuleTest.assertTrue((boolean)this.rule.processAddPersonnelAttachmentBusinessRules(this.createAddPersonnelAttachmentEvent()));
    }

    @Test
    public void testUnspecifiedDocumentType() throws Exception {
        this.newProposalPersonBiography.setDocumentTypeCode(null);
        ProposalDevelopmentPersonnelAttachmentRuleTest.assertFalse((boolean)this.rule.processAddPersonnelAttachmentBusinessRules(this.createAddPersonnelAttachmentEvent()));
        this.checkErrorCountAndContent("documentTypeCode", "error.proposalAttachment.narrativeType.notSelected");
    }

    @Test
    public void testUnspecifiedPerson() throws Exception {
        this.newProposalPersonBiography.setProposalPersonNumber(null);
        ProposalDevelopmentPersonnelAttachmentRuleTest.assertFalse((boolean)this.rule.processAddPersonnelAttachmentBusinessRules(this.createAddPersonnelAttachmentEvent()));
        this.checkErrorCountAndContent("proposalPersonNumber", "error.personnelAttachment.person.required");
    }

    private void checkErrorCountAndContent(String errorPathContext, String errorKey) {
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages(ProposalDevelopmentPersonnelAttachmentRule.buildErrorPath((String)errorPathContext));
        ProposalDevelopmentPersonnelAttachmentRuleTest.assertNotNull((Object)errors);
        ProposalDevelopmentPersonnelAttachmentRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        ProposalDevelopmentPersonnelAttachmentRuleTest.assertEquals((Object)message.getErrorKey(), (Object)errorKey);
    }

    private AddPersonnelAttachmentEvent createAddPersonnelAttachmentEvent() {
        return new AddPersonnelAttachmentEvent(EMPTY_STRING, this.document, this.newProposalPersonBiography);
    }

    private ProposalPersonBiography createNewProposalPersonBiography() {
        ProposalPersonBiography proposalPersonBiography = new ProposalPersonBiography();
        proposalPersonBiography.setDocumentTypeCode(this.documentTypes.get(1).getDocumentTypeCode());
        proposalPersonBiography.setDescription("description");
        proposalPersonBiography.setFileName("test.dat");
        proposalPersonBiography.setProposalPersonNumber(new Integer(2));
        return proposalPersonBiography;
    }

    private PropPerDocType findDocumentTypeForDescription(String description) {
        PropPerDocType foundDocType = null;
        for (PropPerDocType docType : this.documentTypes) {
            if (!docType.getDescription().equalsIgnoreCase(description)) continue;
            foundDocType = docType;
            break;
        }
        return foundDocType;
    }

    private String findOtherDocumentTypeCode() {
        return this.findDocumentTypeForDescription("Other").getDocumentTypeCode();
    }
}

