/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentProposalAttachmentsAuditRule;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentRuleTestBase;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.KNSGlobalVariables;

public class ProposalDevelopmentProposalAttachmentsAuditRuleTest
extends ProposalDevelopmentRuleTestBase {
    ProposalDevelopmentProposalAttachmentsAuditRule rule;
    ProposalDevelopmentDocument proposalDevelopmentDocument;
    DevelopmentProposal developmentProposal;
    Narrative narrativeComplete;
    Narrative narrativeIncomplete;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new ProposalDevelopmentProposalAttachmentsAuditRule();
        this.proposalDevelopmentDocument = this.getNewProposalDevelopmentDocument();
        this.developmentProposal = this.proposalDevelopmentDocument.getDevelopmentProposal();
        this.narrativeComplete = new Narrative();
        this.narrativeComplete.setModuleStatusCode("C");
        this.narrativeIncomplete = new Narrative();
        this.narrativeIncomplete.setModuleStatusCode("I");
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testIncompleteAttachments() {
        this.developmentProposal.getNarratives().add(this.narrativeComplete);
        ProposalDevelopmentProposalAttachmentsAuditRuleTest.assertTrue((boolean)this.rule.checkForIncompleteAttachments(this.developmentProposal));
        ProposalDevelopmentProposalAttachmentsAuditRuleTest.assertTrue((KNSGlobalVariables.getAuditErrorMap().get("proposalAttachmentsAuditWarnings") == null ? 1 : 0) != 0);
        this.developmentProposal.getNarratives().add(this.narrativeIncomplete);
        ProposalDevelopmentProposalAttachmentsAuditRuleTest.assertFalse((boolean)this.rule.checkForIncompleteAttachments(this.developmentProposal));
        ProposalDevelopmentProposalAttachmentsAuditRuleTest.assertFalse((boolean)((AuditCluster)KNSGlobalVariables.getAuditErrorMap().get("proposalAttachmentsAuditWarnings")).getAuditErrorList().isEmpty());
    }
}

