/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.sql.Date;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentProposalRequiredFieldsAuditRule;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentService;
import org.kuali.kra.proposaldevelopment.service.impl.ProposalDevelopmentServiceImpl;
import org.kuali.kra.s2s.bo.S2sOpportunity;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalDevelopmentRequiredFieldsAuditRuleTest
extends KcUnitTestBase {
    private DocumentService documentService = null;
    private ParameterService parameterService = null;
    private ProposalDevelopmentProposalRequiredFieldsAuditRule auditRule = null;
    private String proposalTypeCodeRenewal;
    private String proposalTypeCodeRevision;
    private String proposalTypeCodeContinuation;
    private String proposalTypeCodeResubmission;
    private String proposalTypeCodeNew;
    private String changeCorrectedTypeCode;
    private ProposalDevelopmentDocument pdDoc = null;
    private DevelopmentProposal proposal = null;
    Date tomorrow;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        KNSGlobalVariables.setAuditErrorMap(new HashMap());
        this.documentService = KRADServiceLocatorWeb.getDocumentService();
        this.parameterService = CoreFrameworkServiceLocator.getParameterService();
        this.auditRule = new ProposalDevelopmentProposalRequiredFieldsAuditRule();
        this.proposalTypeCodeRenewal = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.renewal");
        this.proposalTypeCodeRevision = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.revision");
        this.proposalTypeCodeContinuation = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.continuation");
        this.proposalTypeCodeResubmission = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.resubmission");
        this.proposalTypeCodeNew = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.new");
        GregorianCalendar calendar = new GregorianCalendar();
        ((Calendar)calendar).add(5, 1);
        this.tomorrow = new Date(calendar.getTimeInMillis());
        this.pdDoc = (ProposalDevelopmentDocument)this.documentService.getNewDocument("ProposalDevelopmentDocument");
        this.proposal = this.pdDoc.getDevelopmentProposal();
        this.proposal.setDeadlineDate(this.tomorrow);
        this.proposal.setProposalTypeCode(this.proposalTypeCodeNew);
        this.proposal.setS2sOpportunity(new S2sOpportunity());
        this.changeCorrectedTypeCode = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "s2s.submissiontype.changedCorrected");
    }

    @Override
    @After
    public void tearDown() throws Exception {
        GlobalVariables.setUserSession(null);
        KNSGlobalVariables.setAuditErrorMap(null);
        this.documentService = null;
        this.auditRule = null;
        super.tearDown();
    }

    @Test
    public void testRequireSponsorIdWhenNew() throws Exception {
        this.auditRule.setProposalDevelopmentService((ProposalDevelopmentService)new ProposalDevelopmentServiceMock());
        this.proposal.setProposalTypeCode(this.proposalTypeCodeNew);
        this.proposal.getS2sOpportunity().setS2sSubmissionTypeCode(this.changeCorrectedTypeCode);
        this.proposal.setSponsorProposalNumber(null);
        this.validateAuditRule(this.pdDoc, "document.developmentProposalList[0].continuedFrom", "error.proposal.require.id.changeapp", "requiredFieldsAuditErrors", true);
        KNSGlobalVariables.getAuditErrorMap().clear();
        this.proposal.setSponsorProposalNumber("AA123456");
        this.validateAuditRule(this.pdDoc, "document.developmentProposalList[0].continuedFrom", "error.proposal.require.id.changeapp", "requiredFieldsAuditErrors", false);
        KNSGlobalVariables.getAuditErrorMap().clear();
        this.proposal.setSponsorProposalNumber(null);
        this.proposal.setContinuedFrom("1");
        this.validateAuditRule(this.pdDoc, "document.developmentProposalList[0].continuedFrom", "error.proposal.require.id.changeapp", "requiredFieldsAuditErrors", true);
        this.auditRule.setProposalDevelopmentService(null);
    }

    private void validateAuditRule(ProposalDevelopmentDocument document, String fieldKey, String messageKey, String auditKey, boolean expectError) {
        ProposalDevelopmentRequiredFieldsAuditRuleTest.assertTrue((String)"Audit Rule did not produce expected results", (boolean)(this.auditRule.processRunAuditBusinessRules((Document)document) ^ expectError));
        ProposalDevelopmentRequiredFieldsAuditRuleTest.assertEquals((long)(expectError ? 1L : 0L), (long)KNSGlobalVariables.getAuditErrorMap().size());
        AuditCluster auditCluster = (AuditCluster)KNSGlobalVariables.getAuditErrorMap().get(auditKey);
        if (expectError) {
            ProposalDevelopmentRequiredFieldsAuditRuleTest.assertEquals((Object)"Required Fields for Saving Document ", (Object)auditCluster.getLabel());
            List auditErrors = auditCluster.getAuditErrorList();
            ProposalDevelopmentRequiredFieldsAuditRuleTest.assertEquals((long)1L, (long)auditErrors.size());
            AuditError auditError = (AuditError)auditErrors.get(0);
            ProposalDevelopmentRequiredFieldsAuditRuleTest.assertEquals((Object)fieldKey, (Object)auditError.getErrorKey());
            ProposalDevelopmentRequiredFieldsAuditRuleTest.assertEquals((Object)messageKey, (Object)auditError.getMessageKey());
            ProposalDevelopmentRequiredFieldsAuditRuleTest.assertEquals((Object)"proposal.RequiredFieldsforSavingDocument", (Object)auditError.getLink());
            ProposalDevelopmentRequiredFieldsAuditRuleTest.assertEquals((Object)"Validation Errors", (Object)auditCluster.getCategory());
        }
    }

    class ProposalDevelopmentServiceMock
    extends ProposalDevelopmentServiceImpl {
        ProposalDevelopmentServiceMock() {
        }

        public InstitutionalProposal getProposalContinuedFromVersion(ProposalDevelopmentDocument doc) {
            if (StringUtils.isNotBlank((String)doc.getDevelopmentProposal().getContinuedFrom())) {
                InstitutionalProposal instProposal = new InstitutionalProposal();
                instProposal.setProposalNumber(doc.getDevelopmentProposal().getContinuedFrom());
                instProposal.setSponsorProposalNumber("IP123456");
                return instProposal;
            }
            return null;
        }
    }
}

