/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.sql.Date;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentSponsorProgramInformationAuditRule;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentService;
import org.kuali.kra.proposaldevelopment.service.impl.ProposalDevelopmentServiceImpl;
import org.kuali.kra.s2s.bo.S2sOpportunity;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalDevelopmentSponsorProgramInformationAuditRuleTest
extends KcUnitTestBase {
    private DocumentService documentService = null;
    private ParameterService parameterService = null;
    private ProposalDevelopmentSponsorProgramInformationAuditRule auditRule = null;
    private String proposalTypeCodeRenewal;
    private String proposalTypeCodeRevision;
    private String proposalTypeCodeContinuation;
    private String proposalTypeCodeResubmission;
    private String proposalTypeCodeNew;
    Date tomorrow;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        KNSGlobalVariables.setAuditErrorMap(new HashMap());
        this.documentService = KRADServiceLocatorWeb.getDocumentService();
        this.parameterService = CoreFrameworkServiceLocator.getParameterService();
        this.auditRule = new ProposalDevelopmentSponsorProgramInformationAuditRule();
        this.auditRule.setParameterService(this.parameterService);
        this.proposalTypeCodeRenewal = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.renewal");
        this.proposalTypeCodeRevision = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.revision");
        this.proposalTypeCodeContinuation = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.continuation");
        this.proposalTypeCodeResubmission = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.resubmission");
        this.proposalTypeCodeNew = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.new");
        GregorianCalendar calendar = new GregorianCalendar();
        ((Calendar)calendar).add(5, 1);
        this.tomorrow = new Date(calendar.getTimeInMillis());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        GlobalVariables.setUserSession(null);
        KNSGlobalVariables.setAuditErrorMap(null);
        this.documentService = null;
        this.auditRule = null;
        super.tearDown();
    }

    private ProposalDevelopmentDocument getNewProposalDevelopmentDocument() throws Exception {
        ProposalDevelopmentDocument document = (ProposalDevelopmentDocument)this.documentService.getNewDocument("ProposalDevelopmentDocument");
        document.getDevelopmentProposal().setPrimeSponsorCode("000100");
        return document;
    }

    @Test
    public void testValidDate() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        document.getDevelopmentProposal().setDeadlineDate(this.tomorrow);
        ProposalDevelopmentSponsorProgramInformationAuditRuleTest.assertTrue((String)"Audit Rule shouldn't produce any audit errors", (boolean)this.auditRule.processRunAuditBusinessRules((Document)document));
        ProposalDevelopmentSponsorProgramInformationAuditRuleTest.assertEquals((long)0L, (long)KNSGlobalVariables.getAuditErrorMap().size());
    }

    @Test
    public void testEmptyDate() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        this.validateAuditRule(document, "warning.empty.deadline.date");
    }

    @Test
    public void testPastDate() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        GregorianCalendar calendar = new GregorianCalendar();
        ((Calendar)calendar).add(5, -1);
        Date deadlineDate = new Date(calendar.getTimeInMillis());
        document.getDevelopmentProposal().setDeadlineDate(deadlineDate);
        this.validateAuditRule(document, "warning.past.deadline.date");
    }

    @Test
    public void testRequireSponsorIdWhenRenewal() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        DevelopmentProposal proposal = document.getDevelopmentProposal();
        proposal.setDeadlineDate(this.tomorrow);
        proposal.setProposalTypeCode(this.proposalTypeCodeRenewal);
        proposal.setS2sOpportunity(new S2sOpportunity());
        proposal.getS2sOpportunity().setOpportunityId("12345");
        proposal.getS2sOpportunity().setCfdaNumber("00.000");
        proposal.setCfdaNumber("00.000");
        proposal.setProgramAnnouncementTitle("Test Title");
        this.auditRule.setProposalDevelopmentService((ProposalDevelopmentService)new ProposalDevelopmentServiceMock());
        this.validateGGAuditRules(document, "document.developmentProposalList[0].sponsorProposalNumber", "error.proposal.require.priorAward", true);
        KNSGlobalVariables.getAuditErrorMap().clear();
        proposal.setSponsorProposalNumber("AA123456");
        this.validateGGAuditRules(document, "document.developmentProposalList[0].sponsorProposalNumber", "error.proposal.require.priorAward", false);
        KNSGlobalVariables.getAuditErrorMap().clear();
        this.auditRule.setProposalDevelopmentService(null);
        this.auditRule.setParameterService(null);
    }

    @Test
    public void testRequireSponsorIdWhenResubmission() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        DevelopmentProposal proposal = document.getDevelopmentProposal();
        proposal.setDeadlineDate(this.tomorrow);
        proposal.setProposalTypeCode(this.proposalTypeCodeResubmission);
        proposal.setS2sOpportunity(new S2sOpportunity());
        proposal.getS2sOpportunity().setOpportunityId("12345");
        proposal.getS2sOpportunity().setCfdaNumber("00.000");
        proposal.setCfdaNumber("00.000");
        proposal.setProgramAnnouncementTitle("Test Title");
        this.auditRule.setProposalDevelopmentService((ProposalDevelopmentService)new ProposalDevelopmentServiceMock());
        this.validateGGAuditRules(document, "document.developmentProposalList[0].sponsorProposalNumber", "error.proposal.require.priorAwardResubmit", true);
        KNSGlobalVariables.getAuditErrorMap().clear();
        proposal.setSponsorProposalNumber("AA123456");
        this.validateGGAuditRules(document, "document.developmentProposalList[0].sponsorProposalNumber", "error.proposal.require.priorAwardResubmit", false);
        KNSGlobalVariables.getAuditErrorMap().clear();
        proposal.setSponsorProposalNumber(null);
        proposal.setCurrentAwardNumber("000001-0001");
        this.validateGGAuditRules(document, "document.developmentProposalList[0].sponsorProposalNumber", "error.proposal.require.priorAwardResubmit", true);
        KNSGlobalVariables.getAuditErrorMap().clear();
        proposal.setContinuedFrom("1");
        this.validateGGAuditRules(document, "document.developmentProposalList[0].sponsorProposalNumber", "error.proposal.require.priorAwardResubmit", false);
        KNSGlobalVariables.getAuditErrorMap().clear();
        this.auditRule.setProposalDevelopmentService(null);
        this.auditRule.setParameterService(null);
    }

    private void validateAuditRule(ProposalDevelopmentDocument document, String messageKey) {
        ProposalDevelopmentSponsorProgramInformationAuditRuleTest.assertFalse((String)"Audit Rule should produce a Warning audit error", (boolean)this.auditRule.processRunAuditBusinessRules((Document)document));
        ProposalDevelopmentSponsorProgramInformationAuditRuleTest.assertEquals((long)1L, (long)KNSGlobalVariables.getAuditErrorMap().size());
        AuditCluster auditCluster = (AuditCluster)KNSGlobalVariables.getAuditErrorMap().get("sponsorProgramInformationAuditWarnings");
        ProposalDevelopmentSponsorProgramInformationAuditRuleTest.assertEquals((Object)"Sponsor & Program Information", (Object)auditCluster.getLabel());
        List auditErrors = auditCluster.getAuditErrorList();
        ProposalDevelopmentSponsorProgramInformationAuditRuleTest.assertEquals((long)1L, (long)auditErrors.size());
        AuditError auditError = (AuditError)auditErrors.get(0);
        ProposalDevelopmentSponsorProgramInformationAuditRuleTest.assertEquals((Object)"document.developmentProposalList[0].deadlineDate", (Object)auditError.getErrorKey());
        ProposalDevelopmentSponsorProgramInformationAuditRuleTest.assertEquals((Object)messageKey, (Object)auditError.getMessageKey());
        ProposalDevelopmentSponsorProgramInformationAuditRuleTest.assertEquals((Object)"proposal.SponsorProgramInformation", (Object)auditError.getLink());
        ProposalDevelopmentSponsorProgramInformationAuditRuleTest.assertEquals((Object)"Warnings", (Object)auditCluster.getCategory());
    }

    private void validateGGAuditRules(ProposalDevelopmentDocument document, String fieldKey, String messageKey, boolean expectError) {
        ProposalDevelopmentSponsorProgramInformationAuditRuleTest.assertTrue((String)"Audit Rule did not produce expected results", (boolean)(this.auditRule.processRunAuditBusinessRules((Document)document) ^ expectError));
        ProposalDevelopmentSponsorProgramInformationAuditRuleTest.assertEquals((long)(expectError ? 1L : 0L), (long)KNSGlobalVariables.getAuditErrorMap().size());
        AuditCluster auditCluster = (AuditCluster)KNSGlobalVariables.getAuditErrorMap().get("sponsorProgramInformationAuditErrors");
        if (expectError) {
            ProposalDevelopmentSponsorProgramInformationAuditRuleTest.assertEquals((Object)"Sponsor & Program Information", (Object)auditCluster.getLabel());
            List auditErrors = auditCluster.getAuditErrorList();
            ProposalDevelopmentSponsorProgramInformationAuditRuleTest.assertEquals((long)1L, (long)auditErrors.size());
            AuditError auditError = (AuditError)auditErrors.get(0);
            ProposalDevelopmentSponsorProgramInformationAuditRuleTest.assertEquals((Object)fieldKey, (Object)auditError.getErrorKey());
            ProposalDevelopmentSponsorProgramInformationAuditRuleTest.assertEquals((Object)messageKey, (Object)auditError.getMessageKey());
            ProposalDevelopmentSponsorProgramInformationAuditRuleTest.assertEquals((Object)"proposal.SponsorProgramInformation", (Object)auditError.getLink());
            ProposalDevelopmentSponsorProgramInformationAuditRuleTest.assertEquals((Object)"Grants.Gov Errors", (Object)auditCluster.getCategory());
        }
    }

    private class ProposalDevelopmentServiceMock
    extends ProposalDevelopmentServiceImpl {
        public Award getProposalCurrentAwardVersion(ProposalDevelopmentDocument proposal) {
            if (StringUtils.isNotBlank((String)proposal.getDevelopmentProposal().getCurrentAwardNumber())) {
                Award award = new Award();
                award.setAwardNumber(proposal.getDevelopmentProposal().getCurrentAwardNumber());
                award.setSponsorAwardNumber("AW123456");
                return award;
            }
            return null;
        }

        public InstitutionalProposal getProposalContinuedFromVersion(ProposalDevelopmentDocument doc) {
            if (StringUtils.isNotBlank((String)doc.getDevelopmentProposal().getContinuedFrom())) {
                InstitutionalProposal instProposal = new InstitutionalProposal();
                instProposal.setProposalNumber(doc.getDevelopmentProposal().getContinuedFrom());
                instProposal.setSponsorProposalNumber("IP123456");
                return instProposal;
            }
            return null;
        }
    }
}

