/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.sql.Date;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.Ynq;
import org.kuali.kra.common.specialreview.bo.SpecialReview;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.ProposalYnq;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentDocumentRule;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentRuleTestBase;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ProposalDevelopmentYNQRuleTest
extends ProposalDevelopmentRuleTestBase {
    private static final String NEW_PROPOSAL_SPECIAL_REVIEW = "newPropSpecialReview";
    private ProposalDevelopmentDocumentRule rule = null;
    private List<ProposalYnq> proposalYnqs;
    private List<SpecialReview> specialReviewCodes;
    private BusinessObjectService bos;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new ProposalDevelopmentDocumentRule();
        this.bos = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        this.proposalYnqs = (List)this.bos.findAll(Ynq.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        this.bos = null;
        this.proposalYnqs = null;
        super.tearDown();
    }

    @Test
    public void checkCodes() {
        ProposalDevelopmentYNQRuleTest.assertNotNull(this.proposalYnqs);
        ProposalDevelopmentYNQRuleTest.assertTrue((this.proposalYnqs.size() > 1 ? 1 : 0) != 0);
    }

    @Test
    public void testInitialProposalYnq() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        ProposalDevelopmentYNQRuleTest.assertTrue((boolean)this.rule.processProposalYNQBusinessRule(document, false));
    }

    @Test
    public void testRoutingProposalYnq() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        document.getDevelopmentProposal().getYnqGroupNames();
        for (ProposalYnq ynq : document.getDevelopmentProposal().getProposalYnqs()) {
            ynq.setAnswer("Y");
            ynq.setExplanation("Because I said so");
            ynq.setReviewDate(new Date(System.currentTimeMillis()));
        }
        ProposalDevelopmentYNQRuleTest.assertTrue((boolean)this.rule.processProposalYNQBusinessRule(document, true));
    }
}

