/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.service;

import java.util.Map;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.budget.personnel.PersonRolodex;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.logging.FormattedLogger;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonRole;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonUnit;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.service.KeyPersonnelService;
import org.kuali.kra.proposaldevelopment.service.impl.KeyPersonnelServiceImpl;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;

public class KeyPersonnelServiceTest
extends KcUnitTestBase {
    private ProposalDevelopmentDocument document;
    private ProposalDevelopmentDocument blankDocument;
    private DocumentService documentService = null;
    private ParameterService parameterService;
    protected static final String NIH_SPONSOR_CODE = "000340";
    protected static final String NON_NIH_SPONSOR_CODE = "000500";
    protected static final String COI_ROLE_ID = "COI";
    protected static final String NIH_COI_PARAM = "personrole.nih.coi";
    protected static final String NIH_MPI_PARAM = "personrole.nih.coi.mpi";

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        this.documentService = KRADServiceLocatorWeb.getDocumentService();
        this.parameterService = (ParameterService)KraServiceLocator.getService(ParameterService.class);
        this.document = (ProposalDevelopmentDocument)this.documentService.getNewDocument("ProposalDevelopmentDocument");
        this.blankDocument = (ProposalDevelopmentDocument)this.documentService.getNewDocument("ProposalDevelopmentDocument");
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void populateDocument() {
        this.getKeyPersonnelService().populateDocument(this.blankDocument);
        KeyPersonnelServiceTest.assertTrue((this.blankDocument.getDevelopmentProposal().getInvestigatorCreditTypes().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void populateProposalPerson_Investigator() {
        ProposalPerson person = new ProposalPerson();
        this.document.getDevelopmentProposal().setOwnedByUnitNumber("000001");
        person.setProposalPersonRoleId("PI");
        this.getKeyPersonnelService().populateProposalPerson(person, this.document);
        this.getKeyPersonnelService().assignLeadUnit(person, this.document.getDevelopmentProposal().getOwnedByUnitNumber());
        boolean personHasLeadUnit = false;
        for (ProposalPersonUnit unit : person.getUnits()) {
            personHasLeadUnit |= unit.isLeadUnit() && unit.getUnitNumber().equals("000001");
        }
        KeyPersonnelServiceTest.assertTrue((boolean)personHasLeadUnit);
        KeyPersonnelServiceTest.assertTrue((boolean)person.isInvestigator());
    }

    @Test
    public void populateProposalPerson_KeyPerson() {
        ProposalPerson person = new ProposalPerson();
        this.document.getDevelopmentProposal().setOwnedByUnitNumber("000001");
        person.setProposalPersonRoleId("KP");
        KeyPersonnelServiceTest.assertNull((Object)person.getHomeUnit());
        KeyPersonnelServiceTest.assertFalse((boolean)person.isInvestigator());
    }

    @Test
    public void calculateCreditSplitTotals_Default() {
        ProposalPerson person = new ProposalPerson();
        this.document.getDevelopmentProposal().setOwnedByUnitNumber("000001");
        person.setProposalPersonRoleId("PI");
        this.getKeyPersonnelService().populateProposalPerson(person, this.document);
        this.document.getDevelopmentProposal().addProposalPerson(person);
        Map totals = this.getKeyPersonnelService().calculateCreditSplitTotals(this.document);
        for (String key : totals.keySet()) {
            FormattedLogger.info((String)"Key = %s", (Object[])new Object[]{key});
        }
    }

    @Test
    public void testPersonnelRoleDescCoi() {
        this.document.getDevelopmentProposal().setSponsorCode(NON_NIH_SPONSOR_CODE);
        ProposalPerson person = new ProposalPerson();
        person.setProposalPersonRoleId(COI_ROLE_ID);
        person.setMultiplePi(true);
        person.setDevelopmentProposal(this.document.getDevelopmentProposal());
        KeyPersonnelServiceTest.assertEquals((Object)((ProposalPersonRole)this.getBusinessObjectService().findBySinglePrimaryKey(ProposalPersonRole.class, (Object)COI_ROLE_ID)).getRoleDescription(), (Object)this.getKeyPersonnelService().getPersonnelRoleDesc((PersonRolodex)person));
    }

    @Test
    public void testPersonnelRoleDescCoiNih() {
        this.document.getDevelopmentProposal().setSponsorCode(NIH_SPONSOR_CODE);
        ProposalPerson person = new ProposalPerson();
        person.setProposalPersonRoleId(COI_ROLE_ID);
        person.setDevelopmentProposal(this.document.getDevelopmentProposal());
        KeyPersonnelServiceTest.assertEquals((Object)this.parameterService.getParameterValueAsString("KC-GEN", "All", NIH_COI_PARAM), (Object)this.getKeyPersonnelService().getPersonnelRoleDesc((PersonRolodex)person));
    }

    @Test
    public void testPersonnelRoleDescMpi() {
        this.document.getDevelopmentProposal().setSponsorCode(NIH_SPONSOR_CODE);
        ProposalPerson person = new ProposalPerson();
        person.setProposalPersonRoleId(COI_ROLE_ID);
        person.setMultiplePi(true);
        person.setDevelopmentProposal(this.document.getDevelopmentProposal());
        KeyPersonnelServiceTest.assertEquals((Object)this.parameterService.getParameterValueAsString("KC-GEN", "All", NIH_MPI_PARAM), (Object)this.getKeyPersonnelService().getPersonnelRoleDesc((PersonRolodex)person));
    }

    private KeyPersonnelServiceImpl getKeyPersonnelService() {
        return (KeyPersonnelServiceImpl)KraServiceLocator.getService(KeyPersonnelService.class);
    }
}

