/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.service;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentService;
import org.kuali.kra.test.fixtures.ProposalDevelopmentDocumentFixture;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.document.Document;

public class ProposalDevelopmentServiceTest
extends KcUnitTestBase {
    private ProposalDevelopmentService proposalDevelopmentService;
    private BudgetService budgetService;
    private ProposalDevelopmentDocument document;
    private DevelopmentProposal proposal;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.proposalDevelopmentService = (ProposalDevelopmentService)KraServiceLocator.getService(ProposalDevelopmentService.class);
        this.budgetService = (BudgetService)KraServiceLocator.getService(BudgetService.class);
        this.document = ProposalDevelopmentDocumentFixture.NORMAL_DOCUMENT.getDocument();
        this.document.getDevelopmentProposal().setPrimeSponsorCode("000120");
        this.proposal = this.document.getDevelopmentProposal();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testDeleteProposal() throws WorkflowException {
        this.getDocumentService().saveDocument((Document)this.document);
        this.proposalDevelopmentService.deleteProposal(this.document);
        this.document = (ProposalDevelopmentDocument)this.getDocumentService().getByDocumentHeaderId(this.document.getDocumentNumber());
        ProposalDevelopmentServiceTest.assertTrue((boolean)this.document.isProposalDeleted());
        ProposalDevelopmentServiceTest.assertTrue((this.document.getDevelopmentProposal().getTitle() == null ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteProposalWithBudget() throws WorkflowException {
        BudgetDocument budget1 = this.budgetService.addBudgetVersion((BudgetParentDocument)this.document, "Ver1");
        BudgetDocument budget2 = this.budgetService.addBudgetVersion((BudgetParentDocument)this.document, "Ver2 With Long Name");
        this.getDocumentService().saveDocument((Document)this.document);
        this.proposalDevelopmentService.deleteProposal(this.document);
        this.document = (ProposalDevelopmentDocument)this.getDocumentService().getByDocumentHeaderId(this.document.getDocumentNumber());
        ProposalDevelopmentServiceTest.assertTrue((boolean)this.document.isProposalDeleted());
        ProposalDevelopmentServiceTest.assertTrue((this.document.getDevelopmentProposal().getTitle() == null ? 1 : 0) != 0);
        budget1 = (BudgetDocument)this.getDocumentService().getByDocumentHeaderId(budget1.getDocumentNumber());
        budget2 = (BudgetDocument)this.getDocumentService().getByDocumentHeaderId(budget2.getDocumentNumber());
        ProposalDevelopmentServiceTest.assertTrue((boolean)budget1.isBudgetDeleted());
        ProposalDevelopmentServiceTest.assertTrue((boolean)budget2.isBudgetDeleted());
        ProposalDevelopmentServiceTest.assertTrue((budget1.getBudget().getName() == null ? 1 : 0) != 0);
        ProposalDevelopmentServiceTest.assertTrue((budget2.getBudget().getName() == null ? 1 : 0) != 0);
    }
}

