/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.service;

import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.service.ProposalStateService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.krad.bo.DocumentHeader;

public class ProposalStateServiceTest
extends KcUnitTestBase {
    private static final int INITIATED = 1;
    private static final int SAVED = 2;
    private static final int ENROUTE = 3;
    private static final int APPROVED = 4;
    private static final int DISAPPROVED = 5;
    private static final int CANCELED = 6;
    private static final int EXCEPTION = 7;
    private ProposalStateService service;
    private Mockery mockery;
    private WorkflowDocument mock;

    @Before
    public void initTest() {
        this.mockery = new JUnit4Mockery();
        this.service = (ProposalStateService)KraServiceLocator.getService(ProposalStateService.class);
        this.mock = (WorkflowDocument)this.mockery.mock(WorkflowDocument.class);
    }

    @Test
    public void testInitiated() {
        this.runTest(1, false, false, "1", "1");
    }

    @Test
    public void testSaved() {
        this.runTest(2, false, false, "1", "1");
        this.runTest(2, true, false, "4", "4");
    }

    @Test
    public void testEnroute() {
        this.runTest(3, false, false, "2", "2");
        this.runTest(3, true, false, "5", "5");
        this.runTest(3, true, true, "12", "12");
    }

    @Test
    public void testApproved() {
        this.runTest(4, false, false, "3", "3");
        this.runTest(4, true, false, "6", "8");
    }

    @Test
    public void testDisapproved() {
        this.runTest(5, false, false, "7", "7");
        this.runTest(5, true, false, "7", "9");
    }

    @Test
    public void testCanceled() {
        this.runTest(6, false, false, "10", "10");
        this.runTest(6, true, false, "10", "10");
    }

    @Test
    public void testException() {
        this.runTest(7, false, false, "11", "11");
        this.runTest(7, true, false, "11", "11");
    }

    private void runTest(int workflowState, boolean isSubmitted, boolean isRejected, String expectedState1, String expectedState2) {
        ProposalDevelopmentDocument doc = this.createProposalDevelopmentDocument(workflowState, isSubmitted);
        String state = this.service.getProposalStateTypeCode(doc, false, isRejected);
        ProposalStateServiceTest.assertEquals((String)"Proposal State", (Object)expectedState1, (Object)state);
        state = this.service.getProposalStateTypeCode(doc, true, isRejected);
        ProposalStateServiceTest.assertEquals((String)"Proposal State", (Object)expectedState2, (Object)state);
    }

    private ProposalDevelopmentDocument createProposalDevelopmentDocument(int workflowState, boolean submitted) {
        ProposalDevelopmentDocument doc = new ProposalDevelopmentDocument();
        doc.getDevelopmentProposal().setSubmitFlag(Boolean.valueOf(submitted));
        DocumentHeader docHdr = new DocumentHeader();
        this.setMockExpectations(this.mock, workflowState);
        docHdr.setWorkflowDocument(this.mock);
        doc.setDocumentHeader(docHdr);
        return doc;
    }

    private void setMockExpectations(final WorkflowDocument mock, final int workflowState) {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                switch (workflowState) {
                    case 1: {
                        ((WorkflowDocument)this.atLeast(1).of((Object)mock)).isInitiated();
                        this.will(1.returnValue((Object)true));
                        break;
                    }
                    case 2: {
                        ((WorkflowDocument)this.atLeast(1).of((Object)mock)).isInitiated();
                        this.will(1.returnValue((Object)false));
                        ((WorkflowDocument)this.atLeast(1).of((Object)mock)).isSaved();
                        this.will(1.returnValue((Object)true));
                        break;
                    }
                    case 3: {
                        ((WorkflowDocument)this.atLeast(1).of((Object)mock)).isInitiated();
                        this.will(1.returnValue((Object)false));
                        ((WorkflowDocument)this.atLeast(1).of((Object)mock)).isSaved();
                        this.will(1.returnValue((Object)false));
                        ((WorkflowDocument)this.atLeast(2).of((Object)mock)).isEnroute();
                        this.will(1.returnValue((Object)true));
                        break;
                    }
                    case 4: {
                        ((WorkflowDocument)this.atLeast(1).of((Object)mock)).isInitiated();
                        this.will(1.returnValue((Object)false));
                        ((WorkflowDocument)this.atLeast(1).of((Object)mock)).isSaved();
                        this.will(1.returnValue((Object)false));
                        ((WorkflowDocument)this.atLeast(1).of((Object)mock)).isEnroute();
                        this.will(1.returnValue((Object)false));
                        ((WorkflowDocument)this.atLeast(1).of((Object)mock)).isApproved();
                        this.will(1.returnValue((Object)true));
                        break;
                    }
                    case 5: {
                        ((WorkflowDocument)this.atLeast(1).of((Object)mock)).isInitiated();
                        this.will(1.returnValue((Object)false));
                        ((WorkflowDocument)this.atLeast(1).of((Object)mock)).isSaved();
                        this.will(1.returnValue((Object)false));
                        ((WorkflowDocument)this.atLeast(1).of((Object)mock)).isEnroute();
                        this.will(1.returnValue((Object)false));
                        ((WorkflowDocument)this.atLeast(1).of((Object)mock)).isApproved();
                        this.will(1.returnValue((Object)false));
                        ((WorkflowDocument)this.atLeast(1).of((Object)mock)).isDisapproved();
                        this.will(1.returnValue((Object)true));
                        break;
                    }
                    case 6: {
                        ((WorkflowDocument)this.atLeast(1).of((Object)mock)).isInitiated();
                        this.will(1.returnValue((Object)false));
                        ((WorkflowDocument)this.atLeast(1).of((Object)mock)).isSaved();
                        this.will(1.returnValue((Object)false));
                        ((WorkflowDocument)this.atLeast(1).of((Object)mock)).isEnroute();
                        this.will(1.returnValue((Object)false));
                        ((WorkflowDocument)this.atLeast(1).of((Object)mock)).isApproved();
                        this.will(1.returnValue((Object)false));
                        ((WorkflowDocument)this.atLeast(1).of((Object)mock)).isDisapproved();
                        this.will(1.returnValue((Object)false));
                        ((WorkflowDocument)this.atLeast(1).of((Object)mock)).isCanceled();
                        this.will(1.returnValue((Object)true));
                        break;
                    }
                    case 7: {
                        ((WorkflowDocument)this.atLeast(1).of((Object)mock)).isInitiated();
                        this.will(1.returnValue((Object)false));
                        ((WorkflowDocument)this.atLeast(1).of((Object)mock)).isSaved();
                        this.will(1.returnValue((Object)false));
                        ((WorkflowDocument)this.atLeast(1).of((Object)mock)).isEnroute();
                        this.will(1.returnValue((Object)false));
                        ((WorkflowDocument)this.atLeast(1).of((Object)mock)).isApproved();
                        this.will(1.returnValue((Object)false));
                        ((WorkflowDocument)this.atLeast(1).of((Object)mock)).isDisapproved();
                        this.will(1.returnValue((Object)false));
                        ((WorkflowDocument)this.atLeast(1).of((Object)mock)).isCanceled();
                        this.will(1.returnValue((Object)false));
                    }
                }
            }
        });
    }
}

