/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.web;

import java.util.Collection;
import java.util.LinkedHashMap;
import org.apache.commons.lang.math.NumberUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.web.MaintenanceDocumentSeleniumHelper;
import org.kuali.kra.proposaldevelopment.bo.ActivityType;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;
import org.kuali.rice.kns.document.MaintenanceDocumentBase;

public class ActivityTypeMaintenanceDocumentSeleniumTest
extends KcSeleniumTestBase {
    private static final String DOCUMENT_TITLE = "Activity Type";
    private static final String MAINTENANCE_DOCUMENT_TITLE = "Kuali :: Activity Type Maintenance Document";
    private static final String ACTIVITY_TYPE_CODE_ID = "activityTypeCode";
    private static final String DESCRIPTION_ID = "description";
    private static final String HIGHER_EDUCATION_FUNCTION_CODE_ID = "higherEducationFunctionCode";
    private static final String CREATE_DOCUMENT_DESCRIPTION = "Activity Type - Test Create";
    private static final String CREATE_DESCRIPTION = "Test Create Activity Type";
    private static final String EDIT_DOCUMENT_DESCRIPTION = "Activity Type - Test Edit";
    private static final String EDIT_DESCRIPTION_1 = "Test Edit Activity Type (Before)";
    private static final String EDIT_DESCRIPTION_2 = "Test Edit Activity Type (After)";
    private static final String COPY_DOCUMENT_DESCRIPTION = "Activity Type - Test Copy";
    private static final String COPY_DESCRIPTION_1 = "Test Copy Activity Type (Before)";
    private static final String COPY_DESCRIPTION_2 = "Test Copy Activity Type (After)";
    private static final String DEFAULT_HIGHER_EDUCATION_FUNCTION_CODE = "IPR";
    private MaintenanceDocumentSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = MaintenanceDocumentSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testCreateActivityType() throws Exception {
        String activityTypeCode = this.getNewActivityTypeCode();
        String documentNumber = this.createNewMaintenanceDocument(CREATE_DOCUMENT_DESCRIPTION, activityTypeCode, CREATE_DESCRIPTION);
        this.verifyExistingMaintenanceDocument(documentNumber, activityTypeCode, CREATE_DESCRIPTION);
    }

    @Test
    public void testEditActivityType() throws Exception {
        String activityTypeCode = this.getNewActivityTypeCode();
        this.createNewMaintenanceDocument(EDIT_DOCUMENT_DESCRIPTION, activityTypeCode, EDIT_DESCRIPTION_1);
        LinkedHashMap<String, String> searchValues = new LinkedHashMap<String, String>();
        searchValues.put(ACTIVITY_TYPE_CODE_ID, activityTypeCode);
        String documentNumber = this.helper.editMaintenanceDocument(DOCUMENT_TITLE, ActivityType.class.getName(), searchValues, MAINTENANCE_DOCUMENT_TITLE);
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(DESCRIPTION_ID, EDIT_DESCRIPTION_2);
        this.helper.populateMaintenanceDocument(EDIT_DOCUMENT_DESCRIPTION, fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        this.verifyExistingMaintenanceDocument(documentNumber, activityTypeCode, EDIT_DESCRIPTION_2);
    }

    @Test
    public void testCopyActivityType() throws Exception {
        String activityTypeCode1 = this.getNewActivityTypeCode();
        this.createNewMaintenanceDocument(COPY_DOCUMENT_DESCRIPTION, activityTypeCode1, COPY_DESCRIPTION_1);
        LinkedHashMap<String, String> searchValues = new LinkedHashMap<String, String>();
        searchValues.put(ACTIVITY_TYPE_CODE_ID, activityTypeCode1);
        String documentNumber = this.helper.copyMaintenanceDocument(DOCUMENT_TITLE, ActivityType.class.getName(), searchValues, MAINTENANCE_DOCUMENT_TITLE);
        String activityTypeCode2 = this.getNewActivityTypeCode();
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(ACTIVITY_TYPE_CODE_ID, activityTypeCode2);
        fieldValues.put(DESCRIPTION_ID, COPY_DESCRIPTION_2);
        this.helper.populateMaintenanceDocument(COPY_DOCUMENT_DESCRIPTION, fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        this.verifyExistingMaintenanceDocument(documentNumber, activityTypeCode2, COPY_DESCRIPTION_2);
    }

    private String createNewMaintenanceDocument(String documentDescription, String activityTypeCode, String description) {
        String documentNumber = this.helper.createMaintenanceDocument(DOCUMENT_TITLE, ActivityType.class.getName(), MAINTENANCE_DOCUMENT_TITLE);
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(ACTIVITY_TYPE_CODE_ID, activityTypeCode);
        fieldValues.put(DESCRIPTION_ID, description);
        fieldValues.put(HIGHER_EDUCATION_FUNCTION_CODE_ID, DEFAULT_HIGHER_EDUCATION_FUNCTION_CODE);
        this.helper.populateMaintenanceDocument(documentDescription, fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        return documentNumber;
    }

    private void verifyExistingMaintenanceDocument(String documentNumber, String activityTypeCode, String description) throws Exception {
        MaintenanceDocumentBase document = (MaintenanceDocumentBase)this.getDocumentService().getByDocumentHeaderId(documentNumber);
        ActivityTypeMaintenanceDocumentSeleniumTest.assertNotNull((Object)document.getDocumentNumber());
        ActivityTypeMaintenanceDocumentSeleniumTest.assertNotNull((Object)document.getDocumentHeader());
        ActivityTypeMaintenanceDocumentSeleniumTest.assertEquals((Object)documentNumber, (Object)document.getDocumentHeader().getDocumentNumber());
        ActivityType activityType = (ActivityType)document.getNewMaintainableObject().getDataObject();
        ActivityTypeMaintenanceDocumentSeleniumTest.assertEquals((Object)activityTypeCode, (Object)activityType.getActivityTypeCode());
        ActivityTypeMaintenanceDocumentSeleniumTest.assertEquals((Object)description, (Object)activityType.getDescription());
    }

    private String getNewActivityTypeCode() {
        int maxActivityTypeCode = 1;
        Collection activityTypes = this.getBusinessObjectService().findAll(ActivityType.class);
        for (ActivityType activityType : activityTypes) {
            int activityTypeCode = NumberUtils.toInt((String)activityType.getActivityTypeCode(), (int)1);
            if (activityTypeCode <= maxActivityTypeCode) continue;
            maxActivityTypeCode = activityTypeCode;
        }
        return String.valueOf(maxActivityTypeCode + 1);
    }
}

