/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.web;

import org.apache.commons.lang.StringUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.proposaldevelopment.bo.ProposalAbstract;
import org.kuali.kra.proposaldevelopment.web.ProposalDevelopmentSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class ProposalDevelopmentAbstractsPanelSeleniumTest
extends KcSeleniumTestBase {
    private static final String TAB_ID = "Abstracts";
    private static final String TABLE_ID = "abstracts-table";
    private static final String ERROR_PANEL_ID = "tab-Abstracts-div";
    private static final String NEW_PREFIX = "newProposalAbstract.";
    private static final String LIST_PREFIX = "document.developmentProposalList[0].proposalAbstract[%d].";
    private static final String ABSTRACT_TYPE_CODE_ID = "abstractTypeCode";
    private static final String ABSTRACT_DETAILS_ID = "abstractDetails";
    private static final String NEW_ABSTRACT_TYPE_CODE_ID = "newProposalAbstract.abstractTypeCode";
    private static final String NEW_ABSTRACT_DETAILS_ID = "newProposalAbstract.abstractDetails";
    private static final String LIST_ABSTRACT_DETAILS_ID = "document.developmentProposalList[0].proposalAbstract[%d].abstractDetails";
    private static final String ABSTRACT_TYPE_COMPUTER_NAME = "Computer";
    private static final String ABSTRACT_DETAILS_COMPUTER_1 = "May the force be with you.";
    private static final String ABSTRACT_DETAILS_COMPUTER_2 = "Death Star.";
    private static final String ABSTRACT_TYPE_LABS_NAME = "Labs";
    private static final String ABSTRACT_DETAILS_LABS = "Star Wars.";
    private static final String ADD_ABSTRACT_BUTTON = "methodToCall.addAbstract";
    private static final String DELETE_ABSTRACT_BUTTON = "methodToCall.deleteAbstract.line%d";
    private ProposalDevelopmentSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = ProposalDevelopmentSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testAddAbstract() throws Exception {
        this.helper.createProposalDevelopment();
        this.helper.clickProposalDevelopmentAbstractsAndAttachmentsPage();
        this.helper.openTab(TAB_ID);
        this.addAbstract(ABSTRACT_TYPE_COMPUTER_NAME, ABSTRACT_DETAILS_COMPUTER_1);
        String timestampDisplayComputer = this.helper.getTableCellValue(TABLE_ID, 2, 0);
        this.addAbstract(ABSTRACT_TYPE_LABS_NAME, ABSTRACT_DETAILS_LABS);
        String timestampDisplayLabs = this.helper.getTableCellValue(TABLE_ID, 3, 0);
        this.helper.closeAndSearchDocument();
        this.helper.clickProposalDevelopmentAbstractsAndAttachmentsPage();
        this.helper.openTab(TAB_ID);
        this.helper.assertTableRowCount(TABLE_ID, 4);
        this.checkRow(timestampDisplayComputer, ABSTRACT_TYPE_COMPUTER_NAME, ABSTRACT_DETAILS_COMPUTER_1);
        this.checkRow(timestampDisplayLabs, ABSTRACT_TYPE_LABS_NAME, ABSTRACT_DETAILS_LABS);
    }

    @Test
    public void testAddAbstractNoAbstractType() throws Exception {
        this.helper.createProposalDevelopment();
        this.helper.clickProposalDevelopmentAbstractsAndAttachmentsPage();
        this.helper.openTab(TAB_ID);
        this.helper.click(ADD_ABSTRACT_BUTTON);
        this.helper.assertErrorCount(ERROR_PANEL_ID, 1);
    }

    @Test
    public void testAddAbstractNoAbstractDetails() throws Exception {
        this.helper.createProposalDevelopment();
        this.helper.clickProposalDevelopmentAbstractsAndAttachmentsPage();
        this.helper.openTab(TAB_ID);
        this.addAbstract(ABSTRACT_TYPE_COMPUTER_NAME, "");
        String timestampDisplayComputer = this.helper.getTableCellValue(TABLE_ID, 2, 0);
        this.helper.closeAndSearchDocument();
        this.helper.clickProposalDevelopmentAbstractsAndAttachmentsPage();
        this.helper.openTab(TAB_ID);
        this.helper.assertTableRowCount(TABLE_ID, 3);
        this.checkRow(timestampDisplayComputer, ABSTRACT_TYPE_COMPUTER_NAME, "");
    }

    @Test
    public void testModifyAbstract() throws Exception {
        this.helper.createProposalDevelopment();
        this.helper.clickProposalDevelopmentAbstractsAndAttachmentsPage();
        this.helper.openTab(TAB_ID);
        this.addAbstract(ABSTRACT_TYPE_COMPUTER_NAME, ABSTRACT_DETAILS_COMPUTER_1);
        this.helper.saveDocument();
        this.helper.set(String.format(LIST_ABSTRACT_DETAILS_ID, 0), ABSTRACT_DETAILS_COMPUTER_2);
        this.helper.closeAndSearchDocument();
        this.helper.clickProposalDevelopmentAbstractsAndAttachmentsPage();
        this.helper.openTab(TAB_ID);
        this.helper.assertTableRowCount(TABLE_ID, 3);
        this.checkRow("", ABSTRACT_TYPE_COMPUTER_NAME, ABSTRACT_DETAILS_COMPUTER_2);
    }

    @Test
    public void testDeleteAbstractYes() throws Exception {
        this.helper.createProposalDevelopment();
        this.helper.clickProposalDevelopmentAbstractsAndAttachmentsPage();
        this.helper.openTab(TAB_ID);
        this.addAbstract(ABSTRACT_TYPE_COMPUTER_NAME, ABSTRACT_DETAILS_COMPUTER_1);
        this.helper.saveDocument();
        this.helper.click(String.format(DELETE_ABSTRACT_BUTTON, 0));
        this.helper.clickYesAnswer();
        this.helper.closeAndSearchDocument();
        this.helper.clickProposalDevelopmentAbstractsAndAttachmentsPage();
        this.helper.openTab(TAB_ID);
        this.helper.assertTableRowCount(TABLE_ID, 2);
    }

    @Test
    public void testDeleteAbstractNo() throws Exception {
        this.helper.createProposalDevelopment();
        this.helper.clickProposalDevelopmentAbstractsAndAttachmentsPage();
        this.helper.openTab(TAB_ID);
        this.addAbstract(ABSTRACT_TYPE_COMPUTER_NAME, ABSTRACT_DETAILS_COMPUTER_1);
        String timestampDisplayComputer = this.helper.getTableCellValue(TABLE_ID, 2, 0);
        this.helper.saveDocument();
        this.helper.click(String.format(DELETE_ABSTRACT_BUTTON, 0));
        this.helper.clickNoAnswer();
        this.helper.closeAndSearchDocument();
        this.helper.clickProposalDevelopmentAbstractsAndAttachmentsPage();
        this.helper.openTab(TAB_ID);
        this.helper.assertOptionsDoNotContain(NEW_ABSTRACT_TYPE_CODE_ID, ABSTRACT_TYPE_COMPUTER_NAME);
        this.helper.assertTableRowCount(TABLE_ID, 3);
        this.checkRow(timestampDisplayComputer, ABSTRACT_TYPE_COMPUTER_NAME, ABSTRACT_DETAILS_COMPUTER_1);
    }

    @Test
    public void testAbstractExpandedTextArea() throws Exception {
        this.helper.createProposalDevelopment();
        this.helper.clickProposalDevelopmentAbstractsAndAttachmentsPage();
        this.helper.openTab(TAB_ID);
        this.helper.assertExpandedTextArea(NEW_ABSTRACT_DETAILS_ID, ABSTRACT_DETAILS_COMPUTER_1, ABSTRACT_DETAILS_COMPUTER_2);
        this.addAbstract(ABSTRACT_TYPE_COMPUTER_NAME, "");
        this.helper.assertExpandedTextArea(String.format(LIST_ABSTRACT_DETAILS_ID, 0), ABSTRACT_DETAILS_COMPUTER_1, ABSTRACT_DETAILS_COMPUTER_2);
    }

    @Test
    public void testAbstractHelpLink() throws Exception {
        this.helper.createProposalDevelopment();
        this.helper.clickProposalDevelopmentAbstractsAndAttachmentsPage();
        this.helper.openTab(TAB_ID);
        this.helper.assertHelpLink(ProposalAbstract.class);
    }

    private void addAbstract(String abstractTypeName, String abstractDetails) throws Exception {
        this.helper.set(NEW_ABSTRACT_TYPE_CODE_ID, abstractTypeName);
        this.helper.set(NEW_ABSTRACT_DETAILS_ID, abstractDetails);
        this.helper.click(ADD_ABSTRACT_BUTTON);
    }

    private void checkRow(String timestampDisplay, String abstractTypeName, String abstractDetails) {
        if (StringUtils.isNotBlank((String)timestampDisplay)) {
            this.helper.assertTableCellValueContains(TABLE_ID, timestampDisplay);
        }
        this.helper.assertTableCellValueContains(TABLE_ID, abstractTypeName);
        this.helper.assertTableCellValueContains(TABLE_ID, abstractDetails);
    }
}

