/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.web;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.budget.web.BudgetSeleniumHelper;
import org.kuali.kra.proposaldevelopment.web.ProposalDevelopmentSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class ProposalDevelopmentDeleteProposalSeleniumTest
extends KcSeleniumTestBase {
    private ProposalDevelopmentSeleniumHelper proposalDevelopmentHelper;
    private BudgetSeleniumHelper budgetHelper;
    private String proposalDocumentNumber;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.proposalDevelopmentHelper = ProposalDevelopmentSeleniumHelper.instance(driver);
        this.budgetHelper = BudgetSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.proposalDevelopmentHelper = null;
        this.budgetHelper = null;
        super.tearDown();
    }

    @Test
    public void testDeleteProposal() {
        this.proposalDocumentNumber = this.createProposal();
        this.proposalDevelopmentHelper.clickProposalDevelopmentActionsPage();
        this.proposalDevelopmentHelper.click("deleteProposal");
        this.proposalDevelopmentHelper.clickYesAnswer();
        this.proposalDevelopmentHelper.docSearch(this.proposalDocumentNumber);
        this.proposalDevelopmentHelper.assertSelectorContains("div.topblurb table td", "The Development Proposal has been deleted.");
    }

    @Test
    public void testDeleteHierarchy() {
        this.proposalDocumentNumber = this.createProposal();
        this.proposalDevelopmentHelper.clickProposalDevelopmentActionsPage();
        this.proposalDevelopmentHelper.clickExpandAll();
        this.proposalDevelopmentHelper.click("createHierarchy");
        this.proposalDevelopmentHelper.click("deleteProposal");
        this.proposalDevelopmentHelper.assertSelectorContains("div.left-errmsg", "A Proposal is in Hierarchy so it can not be deleted.");
    }

    private String createProposal() {
        this.proposalDevelopmentHelper.createProposalDevelopment();
        this.proposalDevelopmentHelper.addKeyPersonnel();
        this.proposalDevelopmentHelper.addCustomData();
        this.proposalDevelopmentHelper.addQuestions();
        this.proposalDevelopmentHelper.addPermissions();
        this.proposalDevelopmentHelper.addBudget();
        this.proposalDevelopmentHelper.openBudget(0);
        this.budgetHelper.addPersonnel();
        this.budgetHelper.addNonPersonnel();
        this.budgetHelper.returnToProposal();
        this.proposalDevelopmentHelper.finalizeBudget(0);
        return this.proposalDevelopmentHelper.getDocumentNumber();
    }
}

