/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.web;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.proposaldevelopment.web.ProposalDevelopmentSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class ProposalDevelopmentKeyPersonnelSeleniumTest
extends KcSeleniumTestBase {
    private static final String NEW_PERSON_PREFIX = "newProposalPerson.";
    private static final String NEW_PERSON_DEGREE_PREFIX = "newProposalPersonDegree[0].";
    private static final String NEW_PERSON_UNIT_PREFIX = "newProposalPersonUnit[0].";
    private static final String NEW_USER_PREFIX = "newProposalUser.";
    private static final String LIST_PERSON_PREFIX = "document.developmentProposalList[0].proposalPersons[%d].";
    private static final String PERSON_ID_TAG = "newPersonId";
    private static final String ROLODEX_ID_TAG = "newRolodexId";
    private static final String PERSON_ID_ID = "personId";
    private static final String ROLODEX_ID_ID = "rolodexId";
    private static final String PERSON_ROLE_ID_ID = "proposalPersonRoleId";
    private static final String PROJECT_ROLE_ID = "projectRole";
    private static final String DEGREE_CODE_ID = "degreeCode";
    private static final String DEGREE_ID = "degree";
    private static final String GRADUATION_YEAR_ID = "graduationYear";
    private static final String SCHOOL_ID = "school";
    private static final String UNIT_NUMBER_ID = "unitNumber";
    private static final String USERNAME_ID = "username";
    private static final String ROLE_NAME_ID = "roleName";
    private static final String NEW_PERSON_ROLE_ID_ID = "newProposalPerson.proposalPersonRoleId";
    private static final String NEW_PROJECT_ROLE_ID = "newProposalPerson.projectRole";
    private static final String NEW_DEGREE_CODE_ID = "newProposalPersonDegree[0].degreeCode";
    private static final String NEW_DEGREE_ID = "newProposalPersonDegree[0].degree";
    private static final String NEW_GRADUATION_YEAR_ID = "newProposalPersonDegree[0].graduationYear";
    private static final String NEW_SCHOOL_ID = "newProposalPersonDegree[0].school";
    private static final String NEW_UNIT_NUMBER_ID = "newProposalPersonUnit[0].unitNumber";
    private static final String NEW_USERNAME_ID = "newProposalUser.username";
    private static final String NEW_ROLE_NAME_ID = "newProposalUser.roleName";
    private static final String LIST_PERSON_ROLE_ID_ID = "document.developmentProposalList[0].proposalPersons[%d].proposalPersonRoleId";
    private static final String SPONSOR_CODE_ID = "document.developmentProposalList[0].sponsorCode";
    private static final String DEGREE_ROW_TAG = "tbody[id='G4'] tr:nth-child(3) td";
    private static final String UNIT_ROW_TAG = "tbody[id='G3'] tr td";
    private static final String PERSON_ID = "10000000004";
    private static final String ROLODEX_ID = "1727";
    private static final String EMPLOYEE_FULL_NAME = "Nicholas Majors";
    private static final String ROLODEX_FULL_NAME = "Pauline Ho";
    private static final String PRIMARY_INVESTIGATOR_CONTACT_ROLE = "Principal Investigator";
    private static final String CO_INVESTIGATOR_CONTACT_ROLE = "Co-Investigator";
    private static final String KEY_PERSON_CONTACT_ROLE = "Key Person";
    private static final String KEY_PERSON_PROJECT_ROLE = "Tester";
    private static final String DEGREE_CODE_NAME = "Associate in Science";
    private static final String DEGREE = "Sega";
    private static final String GRADUATION_YEAR = "2000";
    private static final String SCHOOL = "Monroe";
    private static final String OPTION_UNIT_DETAILS = "You have the option to add unit details for a key person";
    private static final String UNIT_NAME_IU_UNIV = "IU-UNIV";
    private static final String UNIT_NAME_000001 = "000001";
    private static final String OPTION_CERTIFICATION_QUESTIONS = "You have the option to add Certification Questions for a key person";
    private static final String PROPOSAL_PERSON_CERTIFICATION_QUESTION = "Have lobbying activities been conducted on behalf of this proposal?";
    private static final String COMBINED_CREDIT_SPLIT = "Combined Credit Split";
    private static final String NIH_HIERARCHY_SPONSOR_CODE = "000340";
    private static final String NON_NIH_HIERARCHY_SPONSOR_CODE = "000500";
    private static final String USERNAME = "tdurkin";
    private static final String ROLE_NAME = "Viewer";
    private static final String PRINCIPAL_INVESTIGATOR_CONTACT_ROLE_NIH = "PI/Contact";
    private static final String PRINCIPAL_INVESTIGATOR_CONTACT_ROLE_NON_NIH = "Principal Investigator";
    private static final String INFO_PI_CONTACT_ROLE = "PI/Contact is a required Proposal Role";
    private static final String INSERT_PROPOSAL_PERSON_BUTTON = "methodToCall.insertProposalPerson";
    private static final String CLEAR_PROPOSAL_PERSON_BUTTON = "methodToCall.clearProposalPerson";
    private static final String INSERT_DEGREE_BUTTON = "methodToCall.insertDegree";
    private static final String DELETE_DEGREE_BUTTON = "methodToCall.deleteDegree.document.developmentProposalList[0].proposalPersons[%d].line%d";
    private static final String INSERT_UNIT_BUTTON = "methodToCall.insertUnit";
    private static final String DELETE_UNIT_BUTTON = "methodToCall.deleteUnit.document.developmentProposalList[0].proposalPersons[%d].line%d";
    private static final String INSERT_UNIT_DETAILS_BUTTON = "methodToCall.addUnitDetails";
    private static final String DELETE_UNIT_DETAILS_BUTTON = "methodToCall.removeUnitDetails.document.developmentProposalList[0].proposalPersons[%d].line%d";
    private static final String INSERT_CERTIFICATION_QUESTION_BUTTON = "methodToCall.addCertificationQuestion";
    private static final String DELETE_CERTIFICATION_QUESTION_BUTTON = "methodToCall.removeCertificationQuestion";
    private static final String INSERT_USER_BUTTON = "methodToCall.addProposalUser";
    private ProposalDevelopmentSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = ProposalDevelopmentSeleniumHelper.instance(driver);
        this.helper.loginBackdoor();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper.loginBackdoor();
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testAddEmployeePrincipalInvestigator() throws Exception {
        this.helper.createProposalDevelopment();
        this.helper.clickProposalDevelopmentKeyPersonnelPage();
        this.helper.lookup(PERSON_ID_TAG, PERSON_ID_ID, PERSON_ID);
        this.helper.assertPageContains(EMPLOYEE_FULL_NAME);
        this.helper.set(NEW_PERSON_ROLE_ID_ID, "Principal Investigator");
        this.helper.click(INSERT_PROPOSAL_PERSON_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertPageContains(EMPLOYEE_FULL_NAME);
    }

    @Test
    public void testAddRolodexPrincipalInvestigator() throws Exception {
        this.helper.createProposalDevelopment();
        this.helper.clickProposalDevelopmentKeyPersonnelPage();
        this.helper.lookup(ROLODEX_ID_TAG, ROLODEX_ID_ID, ROLODEX_ID);
        this.helper.assertPageContains(ROLODEX_FULL_NAME);
        this.helper.set(NEW_PERSON_ROLE_ID_ID, "Principal Investigator");
        this.helper.click(INSERT_PROPOSAL_PERSON_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertPageContains(ROLODEX_FULL_NAME);
    }

    @Test
    public void testClearPrincipalInvestigator() throws Exception {
        this.helper.createProposalDevelopment();
        this.helper.clickProposalDevelopmentKeyPersonnelPage();
        this.helper.lookup(PERSON_ID_TAG, PERSON_ID_ID, PERSON_ID);
        this.helper.assertPageContains(EMPLOYEE_FULL_NAME);
        this.helper.set(NEW_PERSON_ROLE_ID_ID, "Principal Investigator");
        this.helper.click(CLEAR_PROPOSAL_PERSON_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertPageDoesNotContain(EMPLOYEE_FULL_NAME);
    }

    @Test
    public void testChangeRole() throws Exception {
        this.helper.createProposalDevelopment();
        this.helper.clickProposalDevelopmentKeyPersonnelPage();
        this.helper.lookup(PERSON_ID_TAG, PERSON_ID_ID, PERSON_ID);
        this.helper.set(NEW_PERSON_ROLE_ID_ID, "Principal Investigator");
        this.helper.assertPageContains("Principal Investigator");
        this.helper.click(INSERT_PROPOSAL_PERSON_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.set(String.format(LIST_PERSON_ROLE_ID_ID, 0), CO_INVESTIGATOR_CONTACT_ROLE);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertPageContains(CO_INVESTIGATOR_CONTACT_ROLE);
    }

    @Test
    public void testAddKeyPerson() throws Exception {
        this.helper.createProposalDevelopment();
        this.helper.clickProposalDevelopmentKeyPersonnelPage();
        this.helper.lookup(PERSON_ID_TAG, PERSON_ID_ID, PERSON_ID);
        this.helper.set(NEW_PERSON_ROLE_ID_ID, KEY_PERSON_CONTACT_ROLE);
        this.helper.set(NEW_PROJECT_ROLE_ID, KEY_PERSON_PROJECT_ROLE);
        this.helper.assertPageContains(KEY_PERSON_CONTACT_ROLE);
        this.helper.click(INSERT_PROPOSAL_PERSON_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertPageContains(OPTION_UNIT_DETAILS);
        this.helper.assertPageContains(OPTION_CERTIFICATION_QUESTIONS);
    }

    @Test
    public void testAddRemoveDegree() throws Exception {
        this.helper.createProposalDevelopment();
        this.helper.clickProposalDevelopmentKeyPersonnelPage();
        this.helper.lookup(PERSON_ID_TAG, PERSON_ID_ID, PERSON_ID);
        this.helper.set(NEW_PERSON_ROLE_ID_ID, "Principal Investigator");
        this.helper.click(INSERT_PROPOSAL_PERSON_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.openTab(0);
        this.helper.openTab(3);
        this.helper.set(NEW_DEGREE_CODE_ID, DEGREE_CODE_NAME);
        this.helper.set(NEW_DEGREE_ID, DEGREE);
        this.helper.set(NEW_GRADUATION_YEAR_ID, GRADUATION_YEAR);
        this.helper.set(NEW_SCHOOL_ID, SCHOOL);
        this.helper.assertElementContains(NEW_DEGREE_CODE_ID, DEGREE_CODE_NAME);
        this.helper.assertElementContains(NEW_DEGREE_ID, DEGREE);
        this.helper.assertElementContains(NEW_GRADUATION_YEAR_ID, GRADUATION_YEAR);
        this.helper.assertElementContains(NEW_SCHOOL_ID, SCHOOL);
        this.helper.click(INSERT_DEGREE_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertSelectorContains(DEGREE_ROW_TAG, DEGREE_CODE_NAME);
        this.helper.assertSelectorContains(DEGREE_ROW_TAG, DEGREE);
        this.helper.assertSelectorContains(DEGREE_ROW_TAG, GRADUATION_YEAR);
        this.helper.assertSelectorContains(DEGREE_ROW_TAG, SCHOOL);
        this.helper.click(String.format(DELETE_DEGREE_BUTTON, 0, 0));
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertSelectorDoesNotContain(DEGREE_ROW_TAG, DEGREE_CODE_NAME);
        this.helper.assertSelectorDoesNotContain(DEGREE_ROW_TAG, DEGREE);
        this.helper.assertSelectorDoesNotContain(DEGREE_ROW_TAG, GRADUATION_YEAR);
        this.helper.assertSelectorDoesNotContain(DEGREE_ROW_TAG, SCHOOL);
    }

    @Test
    public void testAddRemoveUnit() throws Exception {
        this.helper.createProposalDevelopment();
        this.helper.clickProposalDevelopmentKeyPersonnelPage();
        this.helper.lookup(PERSON_ID_TAG, PERSON_ID_ID, PERSON_ID);
        this.helper.set(NEW_PERSON_ROLE_ID_ID, "Principal Investigator");
        this.helper.click(INSERT_PROPOSAL_PERSON_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.openTab(0);
        this.helper.openTab(4);
        this.helper.set(NEW_UNIT_NUMBER_ID, UNIT_NAME_IU_UNIV);
        this.helper.assertElementContains(NEW_UNIT_NUMBER_ID, UNIT_NAME_IU_UNIV);
        this.helper.click(INSERT_UNIT_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertPageContains(UNIT_NAME_IU_UNIV);
        this.helper.click(String.format(DELETE_UNIT_BUTTON, 0, 1));
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertPageDoesNotContain(UNIT_NAME_IU_UNIV);
    }

    @Test
    public void testAddRemoveUnitDetailsKeyPerson() throws Exception {
        this.helper.createProposalDevelopment();
        this.helper.clickProposalDevelopmentKeyPersonnelPage();
        this.helper.lookup(PERSON_ID_TAG, PERSON_ID_ID, PERSON_ID);
        this.helper.set(NEW_PERSON_ROLE_ID_ID, KEY_PERSON_CONTACT_ROLE);
        this.helper.set(NEW_PROJECT_ROLE_ID, KEY_PERSON_PROJECT_ROLE);
        this.helper.click(INSERT_PROPOSAL_PERSON_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.openTab(0);
        this.helper.openTab(4);
        this.helper.click(INSERT_UNIT_DETAILS_BUTTON);
        this.helper.assertSelectorContains(UNIT_ROW_TAG, UNIT_NAME_000001);
        this.helper.assertPageContains(COMBINED_CREDIT_SPLIT);
        this.helper.click(String.format(DELETE_UNIT_DETAILS_BUTTON, 0, 0));
        this.helper.assertSelectorDoesNotContain(UNIT_ROW_TAG, UNIT_NAME_000001);
        this.helper.assertPageDoesNotContain(COMBINED_CREDIT_SPLIT);
    }

    @Test
    public void testAddRemoveCertificationQuestionKeyPerson() throws Exception {
        this.helper.createProposalDevelopment();
        this.helper.clickProposalDevelopmentKeyPersonnelPage();
        this.helper.lookup(PERSON_ID_TAG, PERSON_ID_ID, PERSON_ID);
        this.helper.set(NEW_PERSON_ROLE_ID_ID, KEY_PERSON_CONTACT_ROLE);
        this.helper.set(NEW_PROJECT_ROLE_ID, KEY_PERSON_PROJECT_ROLE);
        this.helper.assertPageContains(KEY_PERSON_CONTACT_ROLE);
        this.helper.click(INSERT_PROPOSAL_PERSON_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.openTab(0);
        this.helper.openTab(5);
        this.helper.click(INSERT_CERTIFICATION_QUESTION_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertPageContains(PROPOSAL_PERSON_CERTIFICATION_QUESTION);
        this.helper.click(DELETE_CERTIFICATION_QUESTION_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertPageDoesNotContain(PROPOSAL_PERSON_CERTIFICATION_QUESTION);
    }

    @Test
    public void testNoAddCertificationQuestionKeyPersonForViewer() throws Exception {
        this.helper.createProposalDevelopment();
        this.helper.clickProposalDevelopmentKeyPersonnelPage();
        this.helper.lookup(PERSON_ID_TAG, PERSON_ID_ID, PERSON_ID);
        this.helper.set(NEW_PERSON_ROLE_ID_ID, KEY_PERSON_CONTACT_ROLE);
        this.helper.set(NEW_PROJECT_ROLE_ID, KEY_PERSON_PROJECT_ROLE);
        this.helper.assertPageContains(KEY_PERSON_CONTACT_ROLE);
        this.helper.click(INSERT_PROPOSAL_PERSON_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.clickProposalDevelopmentPermissionsPage();
        this.helper.set(NEW_USERNAME_ID, USERNAME);
        this.helper.set(NEW_ROLE_NAME_ID, ROLE_NAME);
        this.helper.click(INSERT_USER_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        String documentNumber = this.helper.getDocumentNumber();
        this.helper.closeDocument();
        this.helper.loginBackdoor(USERNAME);
        this.helper.docSearch(documentNumber);
        this.helper.clickProposalDevelopmentKeyPersonnelPage();
        this.helper.assertPageDoesNotContain(OPTION_UNIT_DETAILS);
        this.helper.assertPageDoesNotContain(OPTION_CERTIFICATION_QUESTIONS);
        this.helper.closeDocument();
        this.helper.loginBackdoor();
        this.helper.docSearch(documentNumber);
        this.helper.clickProposalDevelopmentKeyPersonnelPage();
        this.helper.assertPageContains(OPTION_UNIT_DETAILS);
        this.helper.assertPageContains(OPTION_CERTIFICATION_QUESTIONS);
    }

    @Test
    public void testNonNihSponsorPersonnelLabels() throws Exception {
        this.helper.createProposalDevelopment();
        this.helper.set(SPONSOR_CODE_ID, NON_NIH_HIERARCHY_SPONSOR_CODE);
        this.helper.clickProposalDevelopmentKeyPersonnelPage();
        this.helper.assertOptionsContain(NEW_PERSON_ROLE_ID_ID, "Principal Investigator");
        this.helper.assertOptionsDoNotContain(NEW_PERSON_ROLE_ID_ID, PRINCIPAL_INVESTIGATOR_CONTACT_ROLE_NIH);
    }

    @Test
    public void testNihSponsorPersonnelLabels() throws Exception {
        this.helper.createProposalDevelopment();
        this.helper.set(SPONSOR_CODE_ID, NIH_HIERARCHY_SPONSOR_CODE);
        this.helper.clickProposalDevelopmentKeyPersonnelPage();
        this.helper.assertOptionsContain(NEW_PERSON_ROLE_ID_ID, PRINCIPAL_INVESTIGATOR_CONTACT_ROLE_NIH);
        this.helper.assertOptionsDoNotContain(NEW_PERSON_ROLE_ID_ID, "Principal Investigator");
        this.helper.assertPageContains(INFO_PI_CONTACT_ROLE);
    }

    @Test
    public void testKeyPersonnelHelpLink() throws Exception {
        this.helper.createProposalDevelopment();
        this.helper.clickProposalDevelopmentKeyPersonnelPage();
        this.helper.lookup(PERSON_ID_TAG, PERSON_ID_ID, PERSON_ID);
        this.helper.set(NEW_PERSON_ROLE_ID_ID, "Principal Investigator");
        this.helper.click(INSERT_PROPOSAL_PERSON_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.openTab(0);
        this.helper.assertHelpLink(KcPerson.class);
    }
}

