/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.web;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.proposaldevelopment.web.ProposalDevelopmentSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class ProposalDevelopmentKeywordPanelSeleniumTest
extends KcSeleniumTestBase {
    private static final String TAB_ID = "Keywords";
    private static final String TABLE_ID = "keywords-table";
    private static final String KEYWORDS_TAG = "propScienceKeywords";
    private static final String LIST_PREFIX = "document.developmentProposalList[0].propScienceKeyword[%d].";
    private static final String DESCRIPTION_ID = "description";
    private static final String SELECT_KEYWORD_ID = "selectKeyword";
    private static final String LIST_SELECT_KEYWORD_ID = "document.developmentProposalList[0].propScienceKeyword[%d].selectKeyword";
    private static final String KEYWORDS_DESCRIPTION_WILDCARD = "T*";
    private static final String KEYWORDS_DESCRIPTION_TRANSMITTANCE = "Transmittance";
    private static final String KEYWORDS_DESCRIPTION_TEMPERATURE = "Temperature";
    private static final String SELECT_KEYWORD_CHECKED = "on";
    private static final String SELECT_KEYWORD_UNCHECKED = "off";
    private static final String SELECT_ALL_BUTTON = "methodToCall.selectAllScienceKeyword";
    private static final String DELETE_SELECTED_BUTTON = "methodToCall.deleteSelectedScienceKeyword";
    private ProposalDevelopmentSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = ProposalDevelopmentSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testAddKeyword() throws Exception {
        this.helper.createProposalDevelopment();
        this.helper.openTab(TAB_ID);
        this.helper.multiLookup(KEYWORDS_TAG, DESCRIPTION_ID, KEYWORDS_DESCRIPTION_WILDCARD);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertTableRowCount(TABLE_ID, 5);
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 1, KEYWORDS_DESCRIPTION_TRANSMITTANCE);
        this.helper.assertElementContains(String.format(LIST_SELECT_KEYWORD_ID, 0), SELECT_KEYWORD_UNCHECKED);
        this.helper.assertTableCellValueContains(TABLE_ID, 3, 1, KEYWORDS_DESCRIPTION_TEMPERATURE);
        this.helper.assertElementContains(String.format(LIST_SELECT_KEYWORD_ID, 1), SELECT_KEYWORD_UNCHECKED);
    }

    @Test
    public void testSelectAllKeyword() throws Exception {
        this.helper.createProposalDevelopment();
        this.helper.openTab(TAB_ID);
        this.helper.multiLookup(KEYWORDS_TAG, DESCRIPTION_ID, KEYWORDS_DESCRIPTION_WILDCARD);
        this.helper.click(SELECT_ALL_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertElementContains(String.format(LIST_SELECT_KEYWORD_ID, 0), SELECT_KEYWORD_CHECKED);
        this.helper.assertElementContains(String.format(LIST_SELECT_KEYWORD_ID, 1), SELECT_KEYWORD_CHECKED);
    }

    @Test
    public void testDeleteSelectedKeyword() throws Exception {
        this.helper.createProposalDevelopment();
        this.helper.openTab(TAB_ID);
        this.helper.multiLookup(KEYWORDS_TAG, DESCRIPTION_ID, KEYWORDS_DESCRIPTION_WILDCARD);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.set(String.format(LIST_SELECT_KEYWORD_ID, 1), SELECT_KEYWORD_CHECKED);
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 1, KEYWORDS_DESCRIPTION_TRANSMITTANCE);
        this.helper.assertElementContains(String.format(LIST_SELECT_KEYWORD_ID, 0), SELECT_KEYWORD_UNCHECKED);
        this.helper.assertTableCellValueContains(TABLE_ID, 3, 1, KEYWORDS_DESCRIPTION_TEMPERATURE);
        this.helper.assertElementContains(String.format(LIST_SELECT_KEYWORD_ID, 1), SELECT_KEYWORD_CHECKED);
        this.helper.click(DELETE_SELECTED_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertTableRowCount(TABLE_ID, 4);
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 1, KEYWORDS_DESCRIPTION_TRANSMITTANCE);
        this.helper.assertElementContains(String.format(LIST_SELECT_KEYWORD_ID, 0), SELECT_KEYWORD_UNCHECKED);
    }
}

