/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.web;

import org.kuali.kra.test.infrastructure.KcSeleniumHelper;
import org.openqa.selenium.WebDriver;

public class ProposalDevelopmentSeleniumHelper
extends KcSeleniumHelper {
    private static final String PAGE_TITLE = "Kuali :: Proposal Development Document";
    private static final String CREATE_PROPOSAL_DEVELOPMENT_LINK_NAME = "Create Proposal";
    private static final String PROPOSAL_LINK_NAME = "proposal";
    private static final String GRANTS_GOV_LINK_NAME = "grantsGov";
    private static final String KEY_PERSONNEL_LINK_NAME = "keyPersonnel";
    private static final String SPECIAL_REVIEW_LINK_NAME = "specialReview";
    private static final String CUSTOM_DATA_LINK_NAME = "customData";
    private static final String ABSTRACTS_AND_ATTACHMENTS_LINK_NAME = "abstractsAttachments";
    private static final String QUESTIONS_LINK_NAME = "questions";
    private static final String BUDGET_VERSIONS_LINK_NAME = "budgetVersions";
    private static final String PERMISSIONS_LINK_NAME = "permissions";
    private static final String ACTIONS_LINK_NAME = "actions";
    private static final String PERSONNEL_ITEMS_FOR_REVIEW_TAB_ID = "Personnel Items for Review";
    private static final String ASDF_TAB_ID = "asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf";
    private static final String DOCUMENT_DESCRIPTION_ID = "document.documentHeader.documentDescription";
    private static final String LIST_PREFIX = "document.developmentProposalList[0].";
    private static final String SPONSOR_CODE_ID = "document.developmentProposalList[0].sponsorCode";
    private static final String TYPE_CODE_ID = "document.developmentProposalList[0].proposalTypeCode";
    private static final String REQUESTED_START_DATE_ID = "document.developmentProposalList[0].requestedStartDateInitial";
    private static final String OWNED_BY_UNIT_ID = "document.developmentProposalList[0].ownedByUnitNumber";
    private static final String REQUESTED_END_DATE_ID = "document.developmentProposalList[0].requestedEndDateInitial";
    private static final String ACTIVITY_TYPE_CODE_ID = "document.developmentProposalList[0].activityTypeCode";
    private static final String TITLE_ID = "document.developmentProposalList[0].title";
    private static final String PERSON_ID_TAG = "newPersonId";
    private static final String PERSON_ID_ID = "personId";
    private static final String PERSON_ROLE_ID_ID = "newProposalPerson.proposalPersonRoleId";
    private static final String PERSON_YNQS_ID = "proposalPersonQuestionnaireHelpers[0].answerHeaders[0].answers[%d].answer";
    private static final String CREDIT_SPLITS_ID = "document.developmentProposalList[0].investigator[0].creditSplits[%d].credit";
    private static final String UNIT_CREDIT_SPLITS_ID = "document.developmentProposalList[0].investigator[0].units[0].creditSplits[%d].credit";
    private static final String GRADUATE_STUDENT_COUNT_ID = "customAttributeValues(id4)";
    private static final String BILLING_ELEMENT_ID = "customAttributeValues(id1)";
    private static final String QUESTIONNAIRE_ID = "questionnaireHelper.answerHeaders[0].answers[%d].answer";
    private static final String NEW_BUDGET_VERSION_NAME_ID = "newBudgetVersionName";
    private static final String FINAL_VERSION_FLAG_ID = "document.budgetDocumentVersion[%d].budgetVersionOverview.finalVersionFlag";
    private static final String BUDGET_VERSION_ID = "document.budgetDocumentVersion[%d].budgetVersionOverview.budgetStatus";
    private static final String USERNAME_FIELD_ID = "newProposalUser.username";
    private static final String ROLENAME_FIELD_ID = "newProposalUser.roleName";
    private static final String DEFAULT_DOCUMENT_DESCRIPTION = "Proposal Development Web Test";
    private static final String DEFAULT_SPONSOR_CODE = "005770";
    private static final String DEFAULT_TYPE_CODE = "New";
    private static final String DEFAULT_REQUESTED_START_DATE = "08/14/2007";
    private static final String DEFAULT_OWNED_BY_UNIT = "000001 - University";
    private static final String DEFAULT_REQUESTED_END_DATE = "08/21/2007";
    private static final String DEFAULT_ACTIVITY_TYPE = "Instruction";
    private static final String DEFAULT_TITLE = "Project title";
    private static final String DEFAULT_PI_PERSON_ID = "10000000004";
    private static final String DEFAULT_PI_CONTACT_ROLE = "Principal Investigator";
    private static final String DEFAULT_TOTAL_CREDIT_SPLIT = "100.00";
    private static final String DEFAULT_GRADUATE_STUDENT_COUNT = "5";
    private static final String DEFAULT_BILLING_ELEMENT = "College";
    private static final String DEFAULT_BUDGET_VERSION_NAME = "Ver1";
    private static final String DEFAULT_BUDGET_STATUS = "Complete";
    private static final String DEFAULT_APPROVER = "jtester";
    private static final String DEFAULT_VIEWER_ROLENAME = "Viewer";
    private static final String YES_RADIO_FIELD_VALUE = "Y";
    private static final String NO_RADIO_FIELD_VALUE = "N";
    private static final String NA_RADIO_FIELD_VALUE = "X";
    private static final String PROJECT_NOT_COVERED_BY_EO_12372_FIELD_VALUE = "Program not covered by EO 12372";
    private static final String INSERT_PROPOSAL_PERSON_BUTTON = "methodToCall.insertProposalPerson";
    private static final String ADD_PROPOSAL_USER_BUTTON = "methodToCall.addProposalUser";
    private static final String ADD_NEW_BUDGET_BUTTON = "methodToCall.addBudgetVersion";
    private static final String OPEN_BUDGET_BUTTON = "methodToCall.openBudgetVersion.line";
    private static final String SUBMIT_TO_SPONSOR_BUTTON = "methodToCall.submitToSponsor";
    private static ProposalDevelopmentSeleniumHelper helper;

    public static ProposalDevelopmentSeleniumHelper instance(WebDriver driver) {
        if (helper == null) {
            helper = new ProposalDevelopmentSeleniumHelper(driver);
        }
        return helper;
    }

    private ProposalDevelopmentSeleniumHelper(WebDriver driver) {
        super(driver);
    }

    public void clickProposalDevelopmentProposalPage() {
        this.click(PROPOSAL_LINK_NAME);
    }

    public void clickProposalDevelopmentGrantsGovPage() {
        this.click(GRANTS_GOV_LINK_NAME);
    }

    public void clickProposalDevelopmentKeyPersonnelPage() {
        this.click(KEY_PERSONNEL_LINK_NAME);
    }

    public void clickProposalDevelopmentSpecialReviewPage() {
        this.click(SPECIAL_REVIEW_LINK_NAME);
    }

    public void clickProposalDevelopmentCustomDataPage() {
        this.click(CUSTOM_DATA_LINK_NAME);
    }

    public void clickProposalDevelopmentAbstractsAndAttachmentsPage() {
        this.click(ABSTRACTS_AND_ATTACHMENTS_LINK_NAME);
    }

    public void clickProposalDevelopmentQuestionsPage() {
        this.click(QUESTIONS_LINK_NAME);
    }

    public void clickProposalDevelopmentBudgetVersionsPage() {
        this.click(BUDGET_VERSIONS_LINK_NAME);
    }

    public void clickProposalDevelopmentPermissionsPage() {
        this.click(PERMISSIONS_LINK_NAME);
    }

    public void clickProposalDevelopmentActionsPage() {
        this.click(ACTIONS_LINK_NAME);
    }

    public void submitToSponsor() {
        this.click(SUBMIT_TO_SPONSOR_BUTTON);
    }

    public void createProposalDevelopment() {
        this.clickResearcherTab();
        this.click(CREATE_PROPOSAL_DEVELOPMENT_LINK_NAME);
        this.assertTitleContains(PAGE_TITLE);
        this.setDefaultRequiredFields();
        this.saveDocument();
        this.assertSave();
    }

    private void setDefaultRequiredFields() {
        this.set(DOCUMENT_DESCRIPTION_ID, DEFAULT_DOCUMENT_DESCRIPTION);
        this.set(SPONSOR_CODE_ID, DEFAULT_SPONSOR_CODE);
        this.set(TYPE_CODE_ID, DEFAULT_TYPE_CODE);
        this.set(REQUESTED_START_DATE_ID, DEFAULT_REQUESTED_START_DATE);
        this.set(OWNED_BY_UNIT_ID, DEFAULT_OWNED_BY_UNIT);
        this.set(REQUESTED_END_DATE_ID, DEFAULT_REQUESTED_END_DATE);
        this.set(ACTIVITY_TYPE_CODE_ID, DEFAULT_ACTIVITY_TYPE);
        this.set(TITLE_ID, DEFAULT_TITLE);
    }

    public void addKeyPersonnel() {
        this.clickProposalDevelopmentKeyPersonnelPage();
        this.lookup(PERSON_ID_TAG, PERSON_ID_ID, DEFAULT_PI_PERSON_ID);
        this.set(PERSON_ROLE_ID_ID, DEFAULT_PI_CONTACT_ROLE);
        this.click(INSERT_PROPOSAL_PERSON_BUTTON);
        this.openTab(0);
        this.openTab(5);
        this.set(String.format(PERSON_YNQS_ID, 0), YES_RADIO_FIELD_VALUE);
        this.set(String.format(PERSON_YNQS_ID, 1), NO_RADIO_FIELD_VALUE);
        this.set(String.format(PERSON_YNQS_ID, 2), YES_RADIO_FIELD_VALUE);
        this.set(String.format(PERSON_YNQS_ID, 3), NO_RADIO_FIELD_VALUE);
        this.set(String.format(PERSON_YNQS_ID, 4), NO_RADIO_FIELD_VALUE);
        this.set(String.format(PERSON_YNQS_ID, 5), YES_RADIO_FIELD_VALUE);
        for (int i = 0; i < 4; ++i) {
            this.set(String.format(CREDIT_SPLITS_ID, i), DEFAULT_TOTAL_CREDIT_SPLIT);
            this.set(String.format(UNIT_CREDIT_SPLITS_ID, i), DEFAULT_TOTAL_CREDIT_SPLIT);
        }
    }

    public void addCustomData() {
        this.clickProposalDevelopmentCustomDataPage();
        this.openTab(PERSONNEL_ITEMS_FOR_REVIEW_TAB_ID);
        this.set(GRADUATE_STUDENT_COUNT_ID, DEFAULT_GRADUATE_STUDENT_COUNT);
        this.openTab(ASDF_TAB_ID);
        this.set(BILLING_ELEMENT_ID, DEFAULT_BILLING_ELEMENT);
    }

    public void addQuestions() {
        this.clickProposalDevelopmentQuestionsPage();
        this.openTab(0);
        this.set(String.format(QUESTIONNAIRE_ID, 0), NO_RADIO_FIELD_VALUE);
        this.set(String.format(QUESTIONNAIRE_ID, 19), NO_RADIO_FIELD_VALUE);
        this.set(String.format(QUESTIONNAIRE_ID, 21), NO_RADIO_FIELD_VALUE);
        this.set(String.format(QUESTIONNAIRE_ID, 28), NO_RADIO_FIELD_VALUE);
        this.set(String.format(QUESTIONNAIRE_ID, 31), NO_RADIO_FIELD_VALUE);
        this.set(String.format(QUESTIONNAIRE_ID, 32), NO_RADIO_FIELD_VALUE);
        this.set(String.format(QUESTIONNAIRE_ID, 34), NO_RADIO_FIELD_VALUE);
        this.set(String.format(QUESTIONNAIRE_ID, 36), NO_RADIO_FIELD_VALUE);
        this.set(String.format(QUESTIONNAIRE_ID, 39), NO_RADIO_FIELD_VALUE);
        this.set(String.format(QUESTIONNAIRE_ID, 40), NO_RADIO_FIELD_VALUE);
        this.set(String.format(QUESTIONNAIRE_ID, 42), NO_RADIO_FIELD_VALUE);
        this.set(String.format(QUESTIONNAIRE_ID, 64), NO_RADIO_FIELD_VALUE);
        this.set(String.format(QUESTIONNAIRE_ID, 65), NO_RADIO_FIELD_VALUE);
        this.set(String.format(QUESTIONNAIRE_ID, 66), NO_RADIO_FIELD_VALUE);
        this.set(String.format(QUESTIONNAIRE_ID, 70), NO_RADIO_FIELD_VALUE);
        this.set(String.format(QUESTIONNAIRE_ID, 72), NO_RADIO_FIELD_VALUE);
        this.set(String.format(QUESTIONNAIRE_ID, 75), NO_RADIO_FIELD_VALUE);
        this.set(String.format(QUESTIONNAIRE_ID, 77), NO_RADIO_FIELD_VALUE);
        this.set(String.format(QUESTIONNAIRE_ID, 79), PROJECT_NOT_COVERED_BY_EO_12372_FIELD_VALUE);
        this.set(String.format(QUESTIONNAIRE_ID, 80), NO_RADIO_FIELD_VALUE);
        this.set(String.format(QUESTIONNAIRE_ID, 81), NA_RADIO_FIELD_VALUE);
    }

    public void addBudget() {
        this.clickProposalDevelopmentBudgetVersionsPage();
        this.set(NEW_BUDGET_VERSION_NAME_ID, DEFAULT_BUDGET_VERSION_NAME);
        this.click(ADD_NEW_BUDGET_BUTTON);
        this.assertSelectorContains(".budgetline td", DEFAULT_BUDGET_VERSION_NAME);
    }

    public void openBudget(int budgetNumber) {
        this.clickProposalDevelopmentBudgetVersionsPage();
        this.click(OPEN_BUDGET_BUTTON + String.valueOf(budgetNumber));
    }

    public void finalizeBudget(int budgetNumber) {
        this.clickProposalDevelopmentBudgetVersionsPage();
        this.click(String.format(FINAL_VERSION_FLAG_ID, budgetNumber));
        this.set(String.format(BUDGET_VERSION_ID, budgetNumber), DEFAULT_BUDGET_STATUS);
    }

    public void addPermissions() {
        this.clickProposalDevelopmentPermissionsPage();
        this.set(USERNAME_FIELD_ID, DEFAULT_APPROVER);
        this.set(ROLENAME_FIELD_ID, DEFAULT_VIEWER_ROLENAME);
        this.click(ADD_PROPOSAL_USER_BUTTON);
    }

    public void submit() {
        this.clickProposalDevelopmentActionsPage();
        this.routeDocument();
        this.clickYesAnswer();
        this.assertRoute();
        this.blanketApproveDocument();
        this.assertApprove();
        this.submitToSponsor();
        this.clickYesAnswer();
    }
}

