/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.questionnaire;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.lang.StringUtils;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.questionnaire.Questionnaire;
import org.kuali.kra.questionnaire.QuestionnaireAuthorizationService;
import org.kuali.kra.questionnaire.QuestionnaireLookupableHelperServiceImpl;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kns.document.MaintenanceDocumentBase;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;

public class QuestionnaireLookupableHelperServiceTest
extends KcUnitTestBase {
    private QuestionnaireLookupableHelperServiceImpl questionnaireLookupableHelperServiceImpl;
    private DocumentService documentService;
    private Mockery context = new JUnit4Mockery();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.questionnaireLookupableHelperServiceImpl = new QuestionnaireLookupableHelperServiceImpl();
        this.questionnaireLookupableHelperServiceImpl.setBusinessObjectClass(Questionnaire.class);
        this.documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.questionnaireLookupableHelperServiceImpl = null;
        this.documentService = null;
        GlobalVariables.setUserSession(null);
    }

    @Test
    public void testGetSearchResults() throws Exception {
        MaintenanceDocumentBase maintDocument = (MaintenanceDocumentBase)this.documentService.getNewDocument(((MaintenanceDocumentDictionaryService)KraServiceLocator.getService(MaintenanceDocumentDictionaryService.class)).getDocumentTypeName(Questionnaire.class));
        maintDocument.getDocumentHeader().setDocumentDescription("test 1");
        maintDocument.getNewMaintainableObject().setBusinessObject((PersistableBusinessObject)this.createQuestionnaire("test1", "desc 1"));
        this.documentService.routeDocument((Document)maintDocument, null, null);
        maintDocument = (MaintenanceDocumentBase)this.documentService.getNewDocument(((MaintenanceDocumentDictionaryService)KraServiceLocator.getService(MaintenanceDocumentDictionaryService.class)).getDocumentTypeName(Questionnaire.class));
        maintDocument.getDocumentHeader().setDocumentDescription("test 2");
        maintDocument.getNewMaintainableObject().setBusinessObject((PersistableBusinessObject)this.createQuestionnaire("test2", "desc 2"));
        this.documentService.routeDocument((Document)maintDocument, null, null);
        List searchResults = this.questionnaireLookupableHelperServiceImpl.getSearchResults(new HashMap());
        QuestionnaireLookupableHelperServiceTest.assertEquals((long)17L, (long)searchResults.size());
        Questionnaire test1 = null;
        Questionnaire test2 = null;
        for (Questionnaire questionnaire : searchResults) {
            if (StringUtils.equals((String)questionnaire.getName(), (String)"test1")) {
                test1 = questionnaire;
                continue;
            }
            if (!StringUtils.equals((String)questionnaire.getName(), (String)"test2")) continue;
            test2 = questionnaire;
        }
        QuestionnaireLookupableHelperServiceTest.assertNotNull(test1);
        QuestionnaireLookupableHelperServiceTest.assertEquals((Object)test1.getName(), (Object)"test1");
        QuestionnaireLookupableHelperServiceTest.assertEquals((Object)test1.getDescription(), (Object)"desc 1");
        QuestionnaireLookupableHelperServiceTest.assertEquals((long)0L, (long)test1.getQuestionnaireQuestions().size());
        QuestionnaireLookupableHelperServiceTest.assertNotNull((Object)test2);
        QuestionnaireLookupableHelperServiceTest.assertEquals((Object)test2.getName(), (Object)"test2");
        QuestionnaireLookupableHelperServiceTest.assertEquals((Object)test2.getDescription(), (Object)"desc 2");
        QuestionnaireLookupableHelperServiceTest.assertEquals((long)0L, (long)test2.getQuestionnaireQuestions().size());
    }

    @Test
    public void testCustomActionUrlWithVIEW_QUESTIONNAIRE() throws Exception {
        final QuestionnaireAuthorizationService questionnaireAuthorizationService = (QuestionnaireAuthorizationService)this.context.mock(QuestionnaireAuthorizationService.class);
        this.questionnaireLookupableHelperServiceImpl.setQuestionnaireAuthorizationService(questionnaireAuthorizationService);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((QuestionnaireAuthorizationService)this.one(questionnaireAuthorizationService)).hasPermission("Modify Questionnaire");
                this.will(1.returnValue((Object)false));
                ((QuestionnaireAuthorizationService)this.one(questionnaireAuthorizationService)).hasPermission("View Questionnaire");
                this.will(1.returnValue((Object)true));
            }
        });
        MaintenanceDocumentBase maintDocument = (MaintenanceDocumentBase)this.documentService.getNewDocument(((MaintenanceDocumentDictionaryService)KraServiceLocator.getService(MaintenanceDocumentDictionaryService.class)).getDocumentTypeName(Questionnaire.class));
        maintDocument.getDocumentHeader().setDocumentDescription("test 1");
        maintDocument.getNewMaintainableObject().setBusinessObject((PersistableBusinessObject)this.createQuestionnaire("test1", "desc 1"));
        this.documentService.routeDocument((Document)maintDocument, null, null);
        Questionnaire questionnaire = (Questionnaire)maintDocument.getNewMaintainableObject().getDataObject();
        questionnaire.setDocumentNumber(maintDocument.getDocumentNumber());
        this.getBusinessObjectService().save((PersistableBusinessObject)((Questionnaire)maintDocument.getNewMaintainableObject().getDataObject()));
        ArrayList<String> pkNames = new ArrayList<String>();
        pkNames.add("questionnaireRefId");
        List htmldata = this.questionnaireLookupableHelperServiceImpl.getCustomActionUrls((BusinessObject)maintDocument.getNewMaintainableObject().getBusinessObject(), pkNames);
        Assert.assertEquals((int)htmldata.size(), (int)1);
        Assert.assertTrue((boolean)((HtmlData.AnchorHtmlData)htmldata.get(0)).getHref().contains("/kew/DocHandler.do?command=displayDocSearchView&readOnly=true&docId=" + questionnaire.getDocumentNumber()));
    }

    @Test
    public void testCustomActionUrlWithMODIFY_QUESTIONNAIRE() throws Exception {
        final QuestionnaireAuthorizationService questionnaireAuthorizationService = (QuestionnaireAuthorizationService)this.context.mock(QuestionnaireAuthorizationService.class);
        this.questionnaireLookupableHelperServiceImpl.setQuestionnaireAuthorizationService(questionnaireAuthorizationService);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((QuestionnaireAuthorizationService)this.one(questionnaireAuthorizationService)).hasPermission("Modify Questionnaire");
                this.will(2.returnValue((Object)true));
                ((QuestionnaireAuthorizationService)this.one(questionnaireAuthorizationService)).hasPermission("View Questionnaire");
                this.will(2.returnValue((Object)true));
            }
        });
        MaintenanceDocumentBase maintDocument = (MaintenanceDocumentBase)this.documentService.getNewDocument(((MaintenanceDocumentDictionaryService)KraServiceLocator.getService(MaintenanceDocumentDictionaryService.class)).getDocumentTypeName(Questionnaire.class));
        maintDocument.getDocumentHeader().setDocumentDescription("test 1");
        maintDocument.getNewMaintainableObject().setBusinessObject((PersistableBusinessObject)this.createQuestionnaire("test1", "desc 1"));
        this.documentService.routeDocument((Document)maintDocument, null, null);
        Questionnaire questionnaire = (Questionnaire)maintDocument.getNewMaintainableObject().getDataObject();
        questionnaire.setDocumentNumber(maintDocument.getDocumentNumber());
        this.getBusinessObjectService().save((PersistableBusinessObject)((Questionnaire)maintDocument.getNewMaintainableObject().getDataObject()));
        ArrayList<String> pkNames = new ArrayList<String>();
        pkNames.add("questionnaireRefId");
        List htmldata = this.questionnaireLookupableHelperServiceImpl.getCustomActionUrls((BusinessObject)maintDocument.getNewMaintainableObject().getBusinessObject(), pkNames);
        Assert.assertEquals((int)4, (int)htmldata.size());
        Assert.assertEquals((String)((HtmlData.AnchorHtmlData)htmldata.get(0)).getHref(), (String)("../maintenanceQn.do?businessObjectClassName=org.kuali.kra.questionnaire.Questionnaire&questionnaireRefId=" + questionnaire.getQuestionnaireRefId() + "&methodToCall=edit"));
        Assert.assertTrue((boolean)((HtmlData.AnchorHtmlData)htmldata.get(1)).getHref().contains("/kew/DocHandler.do?command=displayDocSearchView&readOnly=true&docId=" + questionnaire.getDocumentNumber()));
        Assert.assertEquals((String)((HtmlData.AnchorHtmlData)htmldata.get(2)).getHref(), (String)("../maintenanceQn.do?businessObjectClassName=org.kuali.kra.questionnaire.Questionnaire&questionnaireRefId=" + questionnaire.getQuestionnaireRefId() + "&methodToCall=copy"));
    }

    @Test
    public void testCustomActionUrlWithNoPermission() throws Exception {
        final QuestionnaireAuthorizationService questionnaireAuthorizationService = (QuestionnaireAuthorizationService)this.context.mock(QuestionnaireAuthorizationService.class);
        this.questionnaireLookupableHelperServiceImpl.setQuestionnaireAuthorizationService(questionnaireAuthorizationService);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((QuestionnaireAuthorizationService)this.one(questionnaireAuthorizationService)).hasPermission("Modify Questionnaire");
                this.will(3.returnValue((Object)false));
                ((QuestionnaireAuthorizationService)this.one(questionnaireAuthorizationService)).hasPermission("View Questionnaire");
                this.will(3.returnValue((Object)false));
            }
        });
        MaintenanceDocumentBase maintDocument = (MaintenanceDocumentBase)this.documentService.getNewDocument(((MaintenanceDocumentDictionaryService)KraServiceLocator.getService(MaintenanceDocumentDictionaryService.class)).getDocumentTypeName(Questionnaire.class));
        maintDocument.getDocumentHeader().setDocumentDescription("test 1");
        maintDocument.getNewMaintainableObject().setBusinessObject((PersistableBusinessObject)this.createQuestionnaire("test1", "desc 1"));
        this.documentService.routeDocument((Document)maintDocument, null, null);
        Questionnaire questionnaire = (Questionnaire)maintDocument.getNewMaintainableObject().getDataObject();
        questionnaire.setDocumentNumber(maintDocument.getDocumentNumber());
        this.getBusinessObjectService().save((PersistableBusinessObject)((Questionnaire)maintDocument.getNewMaintainableObject().getDataObject()));
        ArrayList<String> pkNames = new ArrayList<String>();
        pkNames.add("questionnaireRefId");
        List htmldata = this.questionnaireLookupableHelperServiceImpl.getCustomActionUrls((BusinessObject)maintDocument.getNewMaintainableObject().getBusinessObject(), pkNames);
        Assert.assertEquals((int)htmldata.size(), (int)0);
    }

    private Questionnaire createQuestionnaire(String name, String desc) {
        Questionnaire questionnaire = new Questionnaire();
        questionnaire.setName(name);
        questionnaire.setDescription(desc);
        questionnaire.setSequenceNumber(Integer.valueOf(1));
        return questionnaire;
    }
}

