/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.questionnaire;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.questionnaire.Questionnaire;
import org.kuali.kra.questionnaire.QuestionnaireQuestion;
import org.kuali.kra.questionnaire.QuestionnaireService;
import org.kuali.kra.questionnaire.QuestionnaireServiceImpl;
import org.kuali.kra.questionnaire.QuestionnaireUsage;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class QuestionnaireServiceTest
extends KcUnitTestBase {
    private Mockery context = new JUnit4Mockery();
    private Set<String> expectedModules;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.expectedModules = new HashSet<String>();
        this.expectedModules.add("3");
        this.expectedModules.add("7");
        this.expectedModules.add("2");
        this.expectedModules.add("8");
        this.expectedModules.add("9");
    }

    @Test
    public void testCopyQuestionnaire() {
        QuestionnaireServiceImpl questionnaireService = new QuestionnaireServiceImpl();
        Questionnaire srcQuestionnaire = this.setupSourceQuestionnaire();
        Questionnaire destQuestionnaire = new Questionnaire();
        questionnaireService.copyQuestionnaire(srcQuestionnaire, destQuestionnaire);
        List questionnaireQuestions = destQuestionnaire.getQuestionnaireQuestions();
        List questionnaireUsages = destQuestionnaire.getQuestionnaireUsages();
        QuestionnaireServiceTest.assertTrue((questionnaireQuestions.size() == 2 ? 1 : 0) != 0);
        Assert.assertNull((Object)((QuestionnaireQuestion)questionnaireQuestions.get(0)).getQuestionnaireRefIdFk());
        Assert.assertNull((Object)((QuestionnaireQuestion)questionnaireQuestions.get(1)).getQuestionnaireRefIdFk());
        Assert.assertNull((Object)((QuestionnaireQuestion)questionnaireQuestions.get(0)).getQuestionnaireQuestionsId());
        Assert.assertNull((Object)((QuestionnaireQuestion)questionnaireQuestions.get(1)).getQuestionnaireQuestionsId());
        QuestionnaireServiceTest.assertEquals((Object)((QuestionnaireQuestion)questionnaireQuestions.get(0)).getQuestionRefIdFk(), (Object)1000L);
        QuestionnaireServiceTest.assertTrue((questionnaireUsages.size() == 2 ? 1 : 0) != 0);
        QuestionnaireServiceTest.assertEquals((Object)((QuestionnaireUsage)questionnaireUsages.get(0)).getQuestionnaireLabel(), (Object)"test 1");
        QuestionnaireServiceTest.assertEquals((Object)((QuestionnaireUsage)questionnaireUsages.get(1)).getQuestionnaireLabel(), (Object)"test 2");
        Assert.assertNull((Object)((QuestionnaireUsage)questionnaireUsages.get(0)).getQuestionnaireRefIdFk());
        Assert.assertNull((Object)((QuestionnaireUsage)questionnaireUsages.get(1)).getQuestionnaireRefIdFk());
        Assert.assertNull((Object)((QuestionnaireUsage)questionnaireUsages.get(0)).getQuestionnaireUsageId());
        Assert.assertNull((Object)((QuestionnaireUsage)questionnaireUsages.get(1)).getQuestionnaireUsageId());
    }

    private Questionnaire setupSourceQuestionnaire() {
        Questionnaire questionnaire = new Questionnaire();
        questionnaire.setQuestionnaireRefIdFromLong(Long.valueOf(1L));
        QuestionnaireQuestion questionnaireQuestion = new QuestionnaireQuestion();
        questionnaireQuestion.setQuestionnaireRefIdFk("1");
        questionnaireQuestion.setQuestionRefIdFk(Long.valueOf(1L));
        questionnaireQuestion.setQuestionnaireQuestionsId(Long.valueOf(1L));
        questionnaireQuestion.setQuestionRefIdFk(Long.valueOf(1000L));
        questionnaire.getQuestionnaireQuestions().add(questionnaireQuestion);
        questionnaireQuestion = new QuestionnaireQuestion();
        questionnaireQuestion.setQuestionnaireRefIdFk("1");
        questionnaireQuestion.setQuestionRefIdFk(Long.valueOf(2L));
        questionnaireQuestion.setQuestionnaireQuestionsId(Long.valueOf(2L));
        questionnaireQuestion.setQuestionRefIdFk(Long.valueOf(1001L));
        questionnaire.getQuestionnaireQuestions().add(questionnaireQuestion);
        QuestionnaireUsage questionnaireUsage = new QuestionnaireUsage();
        questionnaireUsage.setQuestionnaireRefIdFk("1");
        questionnaireUsage.setQuestionnaireLabel("test 1");
        questionnaireUsage.setQuestionnaireUsageId(Long.valueOf(1L));
        questionnaire.getQuestionnaireUsages().add(questionnaireUsage);
        questionnaireUsage = new QuestionnaireUsage();
        questionnaireUsage.setQuestionnaireRefIdFk("1");
        questionnaireUsage.setQuestionnaireLabel("test 2");
        questionnaireUsage.setQuestionnaireUsageId(Long.valueOf(2L));
        questionnaire.getQuestionnaireUsages().add(questionnaireUsage);
        return questionnaire;
    }

    @Test
    public void testValidCodes() {
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        List modules = ((QuestionnaireService)KraServiceLocator.getService(QuestionnaireService.class)).getAssociateModules();
        QuestionnaireServiceTest.assertEquals((long)modules.size(), (long)this.expectedModules.size());
        for (String module : modules) {
            QuestionnaireServiceTest.assertTrue((boolean)this.expectedModules.contains(module));
        }
        this.context.assertIsSatisfied();
    }

    @Test
    public void testIsQuestionnaireNameExistTrue() {
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        QuestionnaireServiceImpl questionnaireService = new QuestionnaireServiceImpl();
        questionnaireService.setBusinessObjectService(businessObjectService);
        Questionnaire questionnaire = new Questionnaire();
        questionnaire.setQuestionnaireId("1");
        questionnaire.setName("exist name");
        final ArrayList<Questionnaire> questionnaires = new ArrayList<Questionnaire>();
        questionnaires.add(questionnaire);
        final HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("name", "exist name");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(Questionnaire.class, fieldValues);
                this.will(1.returnValue((Object)questionnaires));
            }
        });
        QuestionnaireServiceTest.assertTrue((boolean)questionnaireService.isQuestionnaireNameExist(null, "exist name"));
        this.context.assertIsSatisfied();
    }

    @Test
    public void testIsQuestionnaireNameExistFalse() {
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        QuestionnaireServiceImpl questionnaireService = new QuestionnaireServiceImpl();
        questionnaireService.setBusinessObjectService(businessObjectService);
        Questionnaire questionnaire = new Questionnaire();
        questionnaire.setQuestionnaireId("1");
        questionnaire.setName("exist name");
        final ArrayList<Questionnaire> questionnaires = new ArrayList<Questionnaire>();
        questionnaires.add(questionnaire);
        final HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("name", "exist name");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(Questionnaire.class, fieldValues);
                this.will(2.returnValue((Object)questionnaires));
            }
        });
        QuestionnaireServiceTest.assertTrue((!questionnaireService.isQuestionnaireNameExist("1", "exist name") ? 1 : 0) != 0);
        this.context.assertIsSatisfied();
    }

    @Test
    public void testIsQuestionnaireNameExistFalseNoMatch() {
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        QuestionnaireServiceImpl questionnaireService = new QuestionnaireServiceImpl();
        questionnaireService.setBusinessObjectService(businessObjectService);
        final HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("name", "not exist name");
        final ArrayList questionnaires = new ArrayList();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(Questionnaire.class, fieldValues);
                this.will(3.returnValue((Object)questionnaires));
            }
        });
        QuestionnaireServiceTest.assertTrue((!questionnaireService.isQuestionnaireNameExist("1", "not exist name") ? 1 : 0) != 0);
        this.context.assertIsSatisfied();
    }
}

