/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.questionnaire.answer;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.kra.questionnaire.QuestionnaireQuestion;
import org.kuali.kra.questionnaire.answer.Answer;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.SaveQuestionnaireAnswerEvent;
import org.kuali.kra.questionnaire.answer.SaveQuestionnaireAnswerRule;
import org.kuali.kra.questionnaire.question.Question;
import org.kuali.kra.rules.TemplateRuleTest;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.springframework.util.AutoPopulatingList;

public class QuestionnaireAnswerRuleTest
extends KcUnitTestBase {
    @Test
    public void testRuleIsOK() {
        new TemplateRuleTest<SaveQuestionnaireAnswerEvent, SaveQuestionnaireAnswerRule>(){

            @Override
            protected void prerequisite() {
                ArrayList<AnswerHeader> answerHeaders = new ArrayList<AnswerHeader>();
                answerHeaders.add(QuestionnaireAnswerRuleTest.this.createAnswerHeaderForVersioning(1L, "0912000001", "0"));
                this.event = new SaveQuestionnaireAnswerEvent(null, answerHeaders);
                this.rule = new SaveQuestionnaireAnswerRule();
                this.expectedReturnValue = true;
            }

            @Override
            public void checkRuleAssertions() {
                MessageMap messages = GlobalVariables.getMessageMap();
                Assert.assertEquals((long)0L, (long)messages.getErrorMessages().size());
            }
        };
    }

    @Test
    public void testRuleIsNotOK() {
        new TemplateRuleTest<SaveQuestionnaireAnswerEvent, SaveQuestionnaireAnswerRule>(){

            @Override
            protected void prerequisite() {
                ArrayList<AnswerHeader> answerHeaders = new ArrayList<AnswerHeader>();
                answerHeaders.add(QuestionnaireAnswerRuleTest.this.createAnswerHeaderForVersioning(1L, "0912000001", "0"));
                ((Answer)((AnswerHeader)answerHeaders.get(0)).getAnswers().get(1)).setAnswer("1x");
                ((Answer)((AnswerHeader)answerHeaders.get(0)).getAnswers().get(2)).setAnswer("01012009");
                this.event = new SaveQuestionnaireAnswerEvent(null, answerHeaders);
                this.rule = new SaveQuestionnaireAnswerRule();
                this.expectedReturnValue = false;
            }

            @Override
            public void checkRuleAssertions() {
                MessageMap messages = GlobalVariables.getMessageMap();
                Assert.assertEquals((long)2L, (long)messages.getErrorMessages().size());
                Assert.assertTrue((boolean)messages.getErrorMessages().containsKey("questionnaireHelper.answerHeaders[0].answers[1].answer"));
                Assert.assertTrue((boolean)messages.getErrorMessages().containsKey("questionnaireHelper.answerHeaders[0].answers[2].answer"));
                Assert.assertEquals((Object)"error.invalidFormat.withFormat(Answer 2, 1x, Number - [0-9])", (Object)((ErrorMessage)((AutoPopulatingList)messages.getErrorMessages().get("questionnaireHelper.answerHeaders[0].answers[1].answer")).get(0)).toString());
                Assert.assertEquals((Object)"error.invalidFormat(Answer 3, 01012009, Date - [xx/xx/xxxx])", (Object)((ErrorMessage)((AutoPopulatingList)messages.getErrorMessages().get("questionnaireHelper.answerHeaders[0].answers[2].answer")).get(0)).toString());
            }
        };
    }

    private AnswerHeader createAnswerHeaderForVersioning(Long questionnaireRefId, String moduleItemKey, String moduleSubItemKey) {
        AnswerHeader answerHeader = new AnswerHeader();
        answerHeader.setModuleItemCode("7");
        answerHeader.setModuleItemKey(moduleItemKey);
        answerHeader.setModuleSubItemKey(moduleSubItemKey);
        answerHeader.setQuestionnaireRefIdFk(questionnaireRefId.toString());
        answerHeader.setAnswers(new ArrayList());
        Answer answer = this.createAnswer(1, "Y");
        answer.setQuestionNumber(Integer.valueOf(1));
        answer.setQuestionnaireQuestion(this.createQuestionnaireQuestion(1, 5));
        answer.setQuestion(answer.getQuestionnaireQuestion().getQuestion());
        answer.setQuestionRefIdFk(answer.getQuestionnaireQuestion().getQuestion().getQuestionRefId());
        answerHeader.getAnswers().add(answer);
        answer = this.createAnswer(1, "10");
        answer.setQuestionNumber(Integer.valueOf(3));
        answer.setQuestionnaireQuestion(this.createChildQuestionnaireQuestion(3, 1, "1", "Y", 3));
        answer.setQuestion(answer.getQuestionnaireQuestion().getQuestion());
        answer.setQuestionRefIdFk(answer.getQuestionnaireQuestion().getQuestion().getQuestionRefId());
        answerHeader.getAnswers().add(answer);
        answer = this.createAnswer(1, "01/01/2009");
        answer.setQuestionNumber(Integer.valueOf(2));
        answer.setQuestionnaireQuestion(this.createQuestionnaireQuestion(2, 4));
        answer.setQuestion(answer.getQuestionnaireQuestion().getQuestion());
        answer.setQuestionRefIdFk(answer.getQuestionnaireQuestion().getQuestion().getQuestionRefId());
        answerHeader.getAnswers().add(answer);
        return answerHeader;
    }

    private Answer createAnswer(Integer answerNumber, String ans) {
        Answer answer = new Answer();
        answer.setAnswer(ans);
        answer.setAnswerNumber(answerNumber);
        return answer;
    }

    private QuestionnaireQuestion createQuestionnaireQuestion(Integer questionNumber, Integer questionTypeId) {
        QuestionnaireQuestion questionnaireQuestion = new QuestionnaireQuestion();
        questionnaireQuestion.setQuestionNumber(questionNumber);
        questionnaireQuestion.setParentQuestionNumber(Integer.valueOf(0));
        questionnaireQuestion.setQuestion(this.createQuestion(Long.parseLong(questionNumber.toString()), questionNumber, questionTypeId));
        return questionnaireQuestion;
    }

    private QuestionnaireQuestion createChildQuestionnaireQuestion(Integer questionNumber, Integer parentQuestionNumber, String condition, String conditionValue, Integer questionTypeId) {
        QuestionnaireQuestion questionnaireQuestion = this.createQuestionnaireQuestion(questionNumber, questionTypeId);
        questionnaireQuestion.setParentQuestionNumber(parentQuestionNumber);
        questionnaireQuestion.setCondition(condition);
        questionnaireQuestion.setConditionFlag(true);
        questionnaireQuestion.setConditionValue(conditionValue);
        return questionnaireQuestion;
    }

    private Question createQuestion(Long questionRefId, Integer questionId, Integer questionTypeId) {
        Question question = new Question();
        question.setQuestionRefId(questionRefId);
        question.setQuestionIdFromInteger(questionId);
        question.setQuestionTypeId(questionTypeId);
        question.setMaxAnswers(Integer.valueOf(1));
        return question;
    }
}

