/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.questionnaire.answer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.lang.StringUtils;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolFinderDao;
import org.kuali.kra.irb.questionnaire.ProtocolModuleQuestionnaireBean;
import org.kuali.kra.questionnaire.Questionnaire;
import org.kuali.kra.questionnaire.QuestionnaireQuestion;
import org.kuali.kra.questionnaire.QuestionnaireService;
import org.kuali.kra.questionnaire.QuestionnaireServiceImpl;
import org.kuali.kra.questionnaire.QuestionnaireUsage;
import org.kuali.kra.questionnaire.answer.Answer;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.ModuleQuestionnaireBean;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerServiceImpl;
import org.kuali.kra.questionnaire.question.Question;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

@RunWith(value=JMock.class)
public class QuestionnaireAnswerServiceTest {
    private Mockery context = new JUnit4Mockery();

    @Test
    public void testGetNewVersionAnswerHeader() {
        QuestionnaireAnswerServiceImpl questionnaireAnswerServiceImpl = new QuestionnaireAnswerServiceImpl();
        QuestionnaireServiceImpl questionnaireServiceImpl = new QuestionnaireServiceImpl();
        final HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("moduleItemCode", "7");
        fieldValues.put("moduleSubItemCode", "0");
        final HashMap<String, String> fieldValues1 = new HashMap<String, String>();
        fieldValues1.put("questionnaireId", "1");
        Questionnaire questionnairenew = this.getQuestionnaire(1, 1, 2L);
        questionnairenew.getQuestionnaireQuestions().add(this.createChildQuestionnaireQuestion(4, 1, "1", "N"));
        final ArrayList<QuestionnaireUsage> usages = new ArrayList<QuestionnaireUsage>();
        final ArrayList<Questionnaire> questionnaires = new ArrayList<Questionnaire>();
        questionnaires.add(questionnairenew);
        QuestionnaireUsage questionnaireUsage = this.createQuestionnaireUsage(1L, "Test Questionnaire New");
        questionnaireUsage.setQuestionnaire(questionnairenew);
        usages.add(questionnaireUsage);
        Questionnaire questionnaire = this.getQuestionnaire(1, 0, 1L);
        Protocol protocol = new Protocol(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        protocol.setProtocolNumber("0912000001");
        protocol.setSequenceNumber(Integer.valueOf(1));
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(QuestionnaireUsage.class, fieldValues);
                this.will(2.returnValue((Object)usages));
                ((BusinessObjectService)this.one(businessObjectService)).findMatchingOrderBy(Questionnaire.class, fieldValues1, "sequenceNumber", false);
                this.will(2.returnValue((Object)questionnaires));
            }
        });
        questionnaireAnswerServiceImpl.setBusinessObjectService(businessObjectService);
        questionnaireAnswerServiceImpl.setQuestionnaireService((QuestionnaireService)questionnaireServiceImpl);
        questionnaireServiceImpl.setBusinessObjectService(businessObjectService);
        AnswerHeader answerHeader = questionnaireAnswerServiceImpl.getNewVersionAnswerHeader((ModuleQuestionnaireBean)new ProtocolModuleQuestionnaireBean("7", protocol.getProtocolNumber(), "0", protocol.getSequenceNumber().toString(), false), questionnaire);
        Assert.assertEquals((int)4, (int)answerHeader.getAnswers().size());
        Assert.assertEquals((int)1, (int)((Answer)answerHeader.getAnswers().get(0)).getQuestionNumber());
        Assert.assertEquals((int)3, (int)((Answer)answerHeader.getAnswers().get(1)).getQuestionNumber());
        Assert.assertEquals((int)4, (int)((Answer)answerHeader.getAnswers().get(2)).getQuestionNumber());
        Assert.assertEquals((int)2, (int)((Answer)answerHeader.getAnswers().get(3)).getQuestionNumber());
        Assert.assertTrue((boolean)StringUtils.isBlank((String)((Answer)answerHeader.getAnswers().get(0)).getAnswer()));
        Assert.assertTrue((boolean)StringUtils.isBlank((String)((Answer)answerHeader.getAnswers().get(1)).getAnswer()));
        Assert.assertTrue((boolean)StringUtils.isBlank((String)((Answer)answerHeader.getAnswers().get(2)).getAnswer()));
        Assert.assertTrue((boolean)StringUtils.isBlank((String)((Answer)answerHeader.getAnswers().get(3)).getAnswer()));
    }

    private Questionnaire getQuestionnaire(Integer questionnaireId, Integer sequenceNumber, Long id) {
        Questionnaire questionnaire = new Questionnaire();
        questionnaire.setQuestionnaireIdFromInteger(questionnaireId);
        questionnaire.setQuestionnaireRefIdFromLong(id);
        questionnaire.setActive(true);
        questionnaire.setSequenceNumber(sequenceNumber);
        ArrayList<QuestionnaireQuestion> questionnaireQuestions = new ArrayList<QuestionnaireQuestion>();
        questionnaireQuestions.add(this.createQuestionnaireQuestion(1));
        questionnaireQuestions.add(this.createQuestionnaireQuestion(2));
        questionnaireQuestions.add(this.createChildQuestionnaireQuestion(3, 1, "1", "Y"));
        questionnaire.setQuestionnaireQuestions(questionnaireQuestions);
        ArrayList<QuestionnaireUsage> questionnaireUsages = new ArrayList<QuestionnaireUsage>();
        questionnaireUsages.add(this.createQuestionnaireUsage(1L, "Test Questionnaire"));
        questionnaire.setQuestionnaireUsages(questionnaireUsages);
        return questionnaire;
    }

    private QuestionnaireQuestion createQuestionnaireQuestion(Integer questionNumber) {
        QuestionnaireQuestion questionnaireQuestion = new QuestionnaireQuestion();
        questionnaireQuestion.setQuestionNumber(questionNumber);
        questionnaireQuestion.setQuestionSeqNumber(questionNumber);
        questionnaireQuestion.setParentQuestionNumber(Integer.valueOf(0));
        questionnaireQuestion.setQuestion(this.createQuestion(Long.parseLong(questionNumber.toString()), questionNumber));
        return questionnaireQuestion;
    }

    private QuestionnaireQuestion createChildQuestionnaireQuestion(Integer questionNumber, Integer parentQuestionNumber, String condition, String conditionValue) {
        QuestionnaireQuestion questionnaireQuestion = this.createQuestionnaireQuestion(questionNumber);
        questionnaireQuestion.setParentQuestionNumber(parentQuestionNumber);
        questionnaireQuestion.setCondition(condition);
        questionnaireQuestion.setConditionFlag(true);
        questionnaireQuestion.setConditionValue(conditionValue);
        return questionnaireQuestion;
    }

    private Question createQuestion(Long questionRefId, Integer questionId) {
        Question question = new Question();
        question.setQuestionRefId(questionRefId);
        question.setQuestionIdFromInteger(questionId);
        question.setMaxAnswers(Integer.valueOf(1));
        return question;
    }

    private QuestionnaireUsage createQuestionnaireUsage(Long questionnaireRefId, String label) {
        QuestionnaireUsage questionnaireUsage = new QuestionnaireUsage();
        questionnaireUsage.setModuleItemCode("7");
        questionnaireUsage.setModuleSubItemCode("0");
        questionnaireUsage.setQuestionnaireRefIdFk(questionnaireRefId.toString());
        questionnaireUsage.setQuestionnaireLabel(label);
        return questionnaireUsage;
    }

    @Test
    public void testVersioningQuestionnaireAnswer() {
        QuestionnaireAnswerServiceImpl questionnaireAnswerServiceImpl = new QuestionnaireAnswerServiceImpl();
        QuestionnaireServiceImpl questionnaireServiceImpl = new QuestionnaireServiceImpl();
        ProtocolModuleQuestionnaireBean moduleQuestionnaireBean = new ProtocolModuleQuestionnaireBean("7", "0912000001", "0", "0", false);
        final HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("moduleItemCode", "7");
        fieldValues.put("moduleItemKey", "0912000001");
        fieldValues.put("moduleSubItemKey", "0");
        fieldValues.put("moduleSubItemCode", "0");
        final HashMap<String, String> fieldValues1 = new HashMap<String, String>();
        fieldValues1.put("questionnaireId", "1");
        final HashMap<String, String> fieldValues2 = new HashMap<String, String>();
        fieldValues2.put("moduleItemCode", "7");
        fieldValues2.put("moduleSubItemCode", "0");
        Questionnaire questionnaire = this.getQuestionnaire(1, 0, 1L);
        final ArrayList<AnswerHeader> headers = new ArrayList<AnswerHeader>();
        AnswerHeader answerHeaderOld = this.createAnswerHeaderForVersioning(1L, "0912000001", "0");
        answerHeaderOld.setQuestionnaire(questionnaire);
        headers.add(answerHeaderOld);
        final ArrayList<Questionnaire> questionnaires = new ArrayList<Questionnaire>();
        questionnaires.add(questionnaire);
        final ArrayList<QuestionnaireUsage> usages = new ArrayList<QuestionnaireUsage>();
        QuestionnaireUsage questionnaireUsage = this.createQuestionnaireUsage(1L, "Test Questionnaire New");
        questionnaireUsage.setQuestionnaire(questionnaire);
        usages.add(questionnaireUsage);
        Protocol protocol = new Protocol(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        protocol.setProtocolNumber("0912000001");
        protocol.setSequenceNumber(Integer.valueOf(0));
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(AnswerHeader.class, fieldValues);
                this.will(4.returnValue((Object)headers));
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(QuestionnaireUsage.class, fieldValues2);
                this.will(4.returnValue((Object)usages));
                ((BusinessObjectService)this.one(businessObjectService)).findMatchingOrderBy(Questionnaire.class, fieldValues1, "sequenceNumber", false);
                this.will(4.returnValue((Object)questionnaires));
            }
        });
        questionnaireAnswerServiceImpl.setBusinessObjectService(businessObjectService);
        questionnaireAnswerServiceImpl.setQuestionnaireService((QuestionnaireService)questionnaireServiceImpl);
        questionnaireServiceImpl.setBusinessObjectService(businessObjectService);
        AnswerHeader answerHeader = (AnswerHeader)questionnaireAnswerServiceImpl.versioningQuestionnaireAnswer((ModuleQuestionnaireBean)new ProtocolModuleQuestionnaireBean("7", protocol.getProtocolNumber(), "0", protocol.getSequenceNumber().toString(), false), Integer.valueOf(1)).get(0);
        Assert.assertEquals((int)3, (int)answerHeader.getAnswers().size());
        Assert.assertEquals((String)"1", (String)answerHeader.getModuleSubItemKey());
        Assert.assertEquals((String)"0912000001", (String)answerHeader.getModuleItemKey());
        Assert.assertEquals((int)1, (int)((Answer)answerHeader.getAnswers().get(0)).getQuestionNumber());
        Assert.assertEquals((String)((Answer)answerHeaderOld.getAnswers().get(0)).getAnswer(), (String)((Answer)answerHeader.getAnswers().get(0)).getAnswer());
        Assert.assertEquals((int)3, (int)((Answer)answerHeader.getAnswers().get(1)).getQuestionNumber());
        Assert.assertEquals((String)((Answer)answerHeaderOld.getAnswers().get(1)).getAnswer(), (String)((Answer)answerHeader.getAnswers().get(1)).getAnswer());
        Assert.assertEquals((int)2, (int)((Answer)answerHeader.getAnswers().get(2)).getQuestionNumber());
        Assert.assertEquals((String)((Answer)answerHeaderOld.getAnswers().get(2)).getAnswer(), (String)((Answer)answerHeader.getAnswers().get(2)).getAnswer());
    }

    private AnswerHeader createAnswerHeaderForVersioning(Long questionnaireRefId, String moduleItemKey, String moduleSubItemKey) {
        AnswerHeader answerHeader = new AnswerHeader();
        answerHeader.setModuleItemCode("7");
        answerHeader.setModuleItemKey(moduleItemKey);
        answerHeader.setModuleSubItemKey(moduleSubItemKey);
        answerHeader.setQuestionnaireRefIdFk(questionnaireRefId.toString());
        answerHeader.setAnswers(new ArrayList());
        Answer answer = this.createAnswer(1, "Y");
        answer.setQuestionNumber(Integer.valueOf(1));
        answer.setQuestionnaireQuestion(this.createQuestionnaireQuestion(1));
        answer.setQuestion(answer.getQuestionnaireQuestion().getQuestion());
        answer.setQuestionRefIdFk(answer.getQuestionnaireQuestion().getQuestion().getQuestionRefId());
        answerHeader.getAnswers().add(answer);
        answer = this.createAnswer(1, "10");
        answer.setQuestionNumber(Integer.valueOf(3));
        answer.setQuestionnaireQuestion(this.createChildQuestionnaireQuestion(3, 1, "1", "Y"));
        answer.setQuestion(answer.getQuestionnaireQuestion().getQuestion());
        answer.setQuestionRefIdFk(answer.getQuestionnaireQuestion().getQuestion().getQuestionRefId());
        answerHeader.getAnswers().add(answer);
        answer = this.createAnswer(1, "Test");
        answer.setQuestionNumber(Integer.valueOf(2));
        answer.setQuestionnaireQuestion(this.createQuestionnaireQuestion(2));
        answer.setQuestion(answer.getQuestionnaireQuestion().getQuestion());
        answer.setQuestionRefIdFk(answer.getQuestionnaireQuestion().getQuestion().getQuestionRefId());
        answerHeader.getAnswers().add(answer);
        return answerHeader;
    }

    private Answer createAnswer(Integer answerNumber, String ans) {
        Answer answer = new Answer();
        answer.setAnswer(ans);
        answer.setAnswerNumber(answerNumber);
        answer.setMatchedChild("Y");
        return answer;
    }

    @Test
    public void testCopyAnswerToNewVersion() {
        QuestionnaireAnswerServiceImpl questionnaireAnswerServiceImpl = new QuestionnaireAnswerServiceImpl();
        AnswerHeader oldAnswerHeader = this.createAnswerHeaderForVersioning(1L, "0912000001", "0");
        AnswerHeader newAnswerHeader = this.createAnswerHeaderForVersioning(2L, "0912000001", "0");
        for (Answer answer : newAnswerHeader.getAnswers()) {
            answer.setAnswer("");
        }
        oldAnswerHeader.setCompleted(true);
        Answer answer = this.createAnswer(1, "");
        answer.setQuestionNumber(Integer.valueOf(4));
        answer.setQuestionnaireQuestion(this.createQuestionnaireQuestion(4));
        answer.setQuestion(answer.getQuestionnaireQuestion().getQuestion());
        answer.setQuestionRefIdFk(answer.getQuestionnaireQuestion().getQuestion().getQuestionRefId());
        newAnswerHeader.getAnswers().add(answer);
        answer = (Answer)newAnswerHeader.getAnswers().get(2);
        answer.setQuestionRefIdFk(Long.valueOf(5L));
        answer.getQuestion().setQuestionRefId(Long.valueOf(5L));
        questionnaireAnswerServiceImpl.copyAnswerToNewVersion(oldAnswerHeader, newAnswerHeader);
        Assert.assertEquals((int)4, (int)newAnswerHeader.getAnswers().size());
        Assert.assertEquals((String)"0", (String)newAnswerHeader.getModuleSubItemKey());
        Assert.assertEquals((String)"0912000001", (String)newAnswerHeader.getModuleItemKey());
        Assert.assertEquals((int)1, (int)((Answer)newAnswerHeader.getAnswers().get(0)).getQuestionNumber());
        Assert.assertEquals((String)((Answer)oldAnswerHeader.getAnswers().get(0)).getAnswer(), (String)((Answer)newAnswerHeader.getAnswers().get(0)).getAnswer());
        Assert.assertEquals((int)3, (int)((Answer)newAnswerHeader.getAnswers().get(1)).getQuestionNumber());
        Assert.assertEquals((String)((Answer)oldAnswerHeader.getAnswers().get(1)).getAnswer(), (String)((Answer)newAnswerHeader.getAnswers().get(1)).getAnswer());
        Assert.assertEquals((int)2, (int)((Answer)newAnswerHeader.getAnswers().get(2)).getQuestionNumber());
        Assert.assertEquals((String)"", (String)((Answer)newAnswerHeader.getAnswers().get(2)).getAnswer());
        Assert.assertEquals((int)4, (int)((Answer)newAnswerHeader.getAnswers().get(3)).getQuestionNumber());
        Assert.assertEquals((String)"", (String)((Answer)newAnswerHeader.getAnswers().get(3)).getAnswer());
        Assert.assertFalse((boolean)newAnswerHeader.getCompleted());
    }

    @Test
    public void testGetQuestionnaireAnswer() {
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        QuestionnaireAnswerServiceImpl questionnaireAnswerServiceImpl = new QuestionnaireAnswerServiceImpl();
        QuestionnaireServiceImpl questionnaireServiceImpl = new QuestionnaireServiceImpl();
        ProtocolModuleQuestionnaireBean moduleQuestionnaireBean = new ProtocolModuleQuestionnaireBean("7", "0912000001", "0", "0", false);
        final HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("moduleItemCode", "7");
        fieldValues.put("moduleItemKey", "0912000001");
        fieldValues.put("moduleSubItemCode", "0");
        fieldValues.put("moduleSubItemKey", "0");
        final HashMap<String, String> fieldValues2 = new HashMap<String, String>();
        fieldValues2.put("questionnaireId", "1");
        final HashMap<String, String> fieldValues3 = new HashMap<String, String>();
        fieldValues3.put("questionnaireId", "2");
        final ArrayList<AnswerHeader> headers = new ArrayList<AnswerHeader>();
        AnswerHeader answerHeader = this.createAnswerHeaderForVersioning(1L, "0912000001", "0");
        headers.add(answerHeader);
        Questionnaire questionnaire = this.getQuestionnaire(1, 0, 1L);
        answerHeader.setQuestionnaire(questionnaire);
        final ArrayList<Questionnaire> questionnaires = new ArrayList<Questionnaire>();
        questionnaires.add(questionnaire);
        Protocol protocol = new Protocol(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        protocol.setProtocolNumber("0912000001");
        protocol.setSequenceNumber(Integer.valueOf(0));
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(AnswerHeader.class, fieldValues);
                this.will(6.returnValue((Object)headers));
            }
        });
        final HashMap<String, String> fieldValues1 = new HashMap<String, String>();
        fieldValues1.put("moduleItemCode", "7");
        Questionnaire questionnairenew = this.getQuestionnaire(2, 0, 2L);
        fieldValues1.put("moduleSubItemCode", "0");
        questionnairenew.getQuestionnaireQuestions().add(this.createChildQuestionnaireQuestion(4, 1, "1", "N"));
        final ArrayList<QuestionnaireUsage> usages = new ArrayList<QuestionnaireUsage>();
        QuestionnaireUsage questionnaireUsage = this.createQuestionnaireUsage(1L, "Test Questionnaire 1");
        questionnaireUsage.setQuestionnaire(questionnairenew);
        final ArrayList<Questionnaire> questionnaires1 = new ArrayList<Questionnaire>();
        questionnaires1.add(questionnairenew);
        ArrayList<QuestionnaireUsage> workUsages = new ArrayList<QuestionnaireUsage>();
        workUsages.add(questionnaireUsage);
        questionnairenew.setQuestionnaireUsages(workUsages);
        usages.add(questionnaireUsage);
        questionnaireUsage = this.createQuestionnaireUsage(2L, "Test Questionnaire 2");
        questionnaireUsage.setQuestionnaire(questionnaire);
        usages.add(questionnaireUsage);
        workUsages.clear();
        workUsages.add(questionnaireUsage);
        questionnaire.setQuestionnaireUsages(workUsages);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(QuestionnaireUsage.class, fieldValues1);
                this.will(7.returnValue((Object)usages));
                ((BusinessObjectService)this.one(businessObjectService)).findMatchingOrderBy(Questionnaire.class, fieldValues2, "sequenceNumber", false);
                this.will(7.returnValue((Object)questionnaires));
                ((BusinessObjectService)this.exactly(2).of((Object)businessObjectService)).findMatchingOrderBy(Questionnaire.class, fieldValues3, "sequenceNumber", false);
                this.will(7.returnValue((Object)questionnaires1));
            }
        });
        questionnaireAnswerServiceImpl.setBusinessObjectService(businessObjectService);
        questionnaireAnswerServiceImpl.setQuestionnaireService((QuestionnaireService)questionnaireServiceImpl);
        questionnaireServiceImpl.setBusinessObjectService(businessObjectService);
        List answerHeaders = questionnaireAnswerServiceImpl.getQuestionnaireAnswer((ModuleQuestionnaireBean)new ProtocolModuleQuestionnaireBean("7", protocol.getProtocolNumber(), "0", protocol.getSequenceNumber().toString(), false));
        Assert.assertEquals((int)2, (int)answerHeaders.size());
        Assert.assertEquals((int)3, (int)((AnswerHeader)answerHeaders.get(0)).getAnswers().size());
        Assert.assertEquals((int)4, (int)((AnswerHeader)answerHeaders.get(1)).getAnswers().size());
        Assert.assertFalse((boolean)((AnswerHeader)answerHeaders.get(1)).getCompleted());
        Assert.assertTrue((boolean)((AnswerHeader)answerHeaders.get(0)).getCompleted());
        Assert.assertEquals((String)"Y", (String)((Answer)((AnswerHeader)answerHeaders.get(0)).getAnswers().get(0)).getAnswer());
        Assert.assertEquals((String)"10", (String)((Answer)((AnswerHeader)answerHeaders.get(0)).getAnswers().get(1)).getAnswer());
        Assert.assertEquals((String)"Test", (String)((Answer)((AnswerHeader)answerHeaders.get(0)).getAnswers().get(2)).getAnswer());
        Assert.assertTrue((boolean)StringUtils.isBlank((String)((Answer)((AnswerHeader)answerHeaders.get(1)).getAnswers().get(0)).getAnswer()));
        Assert.assertTrue((boolean)StringUtils.isBlank((String)((Answer)((AnswerHeader)answerHeaders.get(1)).getAnswers().get(1)).getAnswer()));
        Assert.assertTrue((boolean)StringUtils.isBlank((String)((Answer)((AnswerHeader)answerHeaders.get(1)).getAnswers().get(2)).getAnswer()));
        Assert.assertTrue((boolean)StringUtils.isBlank((String)((Answer)((AnswerHeader)answerHeaders.get(1)).getAnswers().get(3)).getAnswer()));
    }

    @Test
    public void testcheckIfQuestionnaireIsActiveForModule() {
        Integer questionnaireId = new Integer(4);
        String CORRECT_MODULE_CODE = "correct_module_code";
        String CORRECT_SUB_MODULE_CODE = "correct_sub_module_code";
        String INCORRECT_MODULE_CODE = "incorrect_module_code";
        String INCORRECT_SUB_MODULE_CODE = "inccorrect_sub_module_code";
        String NON_EXISTENT_MODULE_CODE = "nonexistent_module_code";
        String NON_EXISTENT_SUB_MODULE_CODE = "nonexistent_sub_module_code";
        Questionnaire questionnaire = new Questionnaire();
        QuestionnaireUsage usage1 = new QuestionnaireUsage();
        QuestionnaireUsage usage2 = new QuestionnaireUsage();
        QuestionnaireUsage usage3 = new QuestionnaireUsage();
        QuestionnaireUsage usage4 = new QuestionnaireUsage();
        ArrayList<QuestionnaireUsage> usages = new ArrayList<QuestionnaireUsage>();
        usages.add(usage1);
        usages.add(usage2);
        usages.add(usage3);
        usages.add(usage4);
        questionnaire.setQuestionnaireUsages(usages);
        final HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("questionnaireId", questionnaireId.toString());
        final ArrayList<Questionnaire> questionnaires = new ArrayList<Questionnaire>();
        questionnaires.add(questionnaire);
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.atLeast(1).of((Object)businessObjectService)).findMatchingOrderBy(Questionnaire.class, fieldValues, "sequenceNumber", false);
                this.will(8.returnValue((Object)questionnaires));
            }
        });
        QuestionnaireAnswerServiceImpl questionnaireAnswerServiceImpl = new QuestionnaireAnswerServiceImpl();
        questionnaireAnswerServiceImpl.setBusinessObjectService(businessObjectService);
        questionnaire.setActive(true);
        usage1.setModuleItemCode(INCORRECT_MODULE_CODE);
        usage1.setModuleSubItemCode(INCORRECT_SUB_MODULE_CODE);
        usage2.setModuleItemCode(INCORRECT_MODULE_CODE);
        usage2.setModuleSubItemCode(CORRECT_SUB_MODULE_CODE);
        usage3.setModuleItemCode(CORRECT_MODULE_CODE);
        usage3.setModuleSubItemCode(CORRECT_SUB_MODULE_CODE);
        usage4.setModuleItemCode(INCORRECT_MODULE_CODE);
        usage4.setModuleSubItemCode(INCORRECT_SUB_MODULE_CODE);
        Assert.assertTrue((boolean)questionnaireAnswerServiceImpl.checkIfQuestionnaireIsActiveForModule(questionnaireId, CORRECT_MODULE_CODE, CORRECT_SUB_MODULE_CODE));
        questionnaire.setActive(false);
        Assert.assertFalse((boolean)questionnaireAnswerServiceImpl.checkIfQuestionnaireIsActiveForModule(questionnaireId, CORRECT_MODULE_CODE, CORRECT_SUB_MODULE_CODE));
        questionnaire.setActive(true);
        usage3.setModuleItemCode(INCORRECT_MODULE_CODE);
        Assert.assertFalse((boolean)questionnaireAnswerServiceImpl.checkIfQuestionnaireIsActiveForModule(questionnaireId, CORRECT_MODULE_CODE, CORRECT_SUB_MODULE_CODE));
        questionnaire.setActive(true);
        usage3.setModuleItemCode(CORRECT_MODULE_CODE);
        usage3.setModuleSubItemCode(INCORRECT_SUB_MODULE_CODE);
        questionnaires.clear();
        Assert.assertFalse((boolean)questionnaireAnswerServiceImpl.checkIfQuestionnaireIsActiveForModule(questionnaireId, NON_EXISTENT_MODULE_CODE, NON_EXISTENT_SUB_MODULE_CODE));
    }

    @Test
    public void testPreSave() {
        QuestionnaireAnswerServiceImpl questionnaireAnswerServiceImpl = new QuestionnaireAnswerServiceImpl();
        AnswerHeader oldAnswerHeader = this.createAnswerHeaderForVersioning(1L, "0912000001", "0");
        AnswerHeader newAnswerHeader = this.createAnswerHeaderForVersioning(2L, "0912000001", "0");
        for (Answer answer : oldAnswerHeader.getAnswers()) {
            answer.setMatchedChild("Y");
        }
        for (Answer answer : newAnswerHeader.getAnswers()) {
            answer.setMatchedChild("Y");
        }
        ((Answer)newAnswerHeader.getAnswers().get(2)).setAnswer("");
        ((Answer)oldAnswerHeader.getAnswers().get(2)).getQuestion().setMaxAnswers(Integer.valueOf(4));
        Answer answer = (Answer)ObjectUtils.deepCopy((Serializable)((Serializable)oldAnswerHeader.getAnswers().get(2)));
        answer.setAnswerNumber(Integer.valueOf(2));
        answer.setAnswer("");
        oldAnswerHeader.getAnswers().add(answer);
        answer = (Answer)ObjectUtils.deepCopy((Serializable)((Serializable)oldAnswerHeader.getAnswers().get(2)));
        answer.setAnswerNumber(Integer.valueOf(3));
        answer.setAnswer("");
        oldAnswerHeader.getAnswers().add(answer);
        answer = (Answer)ObjectUtils.deepCopy((Serializable)((Serializable)oldAnswerHeader.getAnswers().get(2)));
        answer.setAnswerNumber(Integer.valueOf(4));
        answer.setAnswer("Test1");
        oldAnswerHeader.getAnswers().add(answer);
        ArrayList<AnswerHeader> answerHeaders = new ArrayList<AnswerHeader>();
        answerHeaders.add(oldAnswerHeader);
        answerHeaders.add(newAnswerHeader);
        questionnaireAnswerServiceImpl.preSave(answerHeaders);
        Assert.assertEquals((int)2, (int)answerHeaders.size());
        Assert.assertFalse((boolean)((AnswerHeader)answerHeaders.get(1)).getCompleted());
        Assert.assertTrue((boolean)((AnswerHeader)answerHeaders.get(0)).getCompleted());
        Assert.assertEquals((String)"Test", (String)((Answer)((AnswerHeader)answerHeaders.get(0)).getAnswers().get(2)).getAnswer());
        Assert.assertEquals((String)"Test1", (String)((Answer)((AnswerHeader)answerHeaders.get(0)).getAnswers().get(3)).getAnswer());
        Assert.assertEquals((String)"", (String)((Answer)((AnswerHeader)answerHeaders.get(0)).getAnswers().get(4)).getAnswer());
        Assert.assertEquals((String)"", (String)((Answer)((AnswerHeader)answerHeaders.get(0)).getAnswers().get(5)).getAnswer());
    }

    @Test
    public void testSetupChildAnswerIndicator() {
        QuestionnaireAnswerServiceImpl questionnaireAnswerServiceImpl = new QuestionnaireAnswerServiceImpl();
        AnswerHeader newAnswerHeader = this.createAnswerHeaderForVersioning(2L, "0912000001", "0");
        Answer answer = this.createAnswer(1, "");
        answer.setQuestionNumber(Integer.valueOf(4));
        answer.setQuestionnaireQuestion(this.createChildQuestionnaireQuestion(4, 1, "1", "N"));
        answer.setQuestion(answer.getQuestionnaireQuestion().getQuestion());
        answer.setQuestionRefIdFk(answer.getQuestionnaireQuestion().getQuestion().getQuestionRefId());
        newAnswerHeader.getAnswers().add(answer);
        questionnaireAnswerServiceImpl.setupChildAnswerIndicator(newAnswerHeader);
        Assert.assertEquals((int)4, (int)newAnswerHeader.getAnswers().size());
        Assert.assertEquals((String)"0", (String)newAnswerHeader.getModuleSubItemKey());
        Assert.assertEquals((String)"0912000001", (String)newAnswerHeader.getModuleItemKey());
        Assert.assertEquals((int)1, (int)((Answer)newAnswerHeader.getAnswers().get(0)).getQuestionNumber());
        Assert.assertEquals((int)3, (int)((Answer)newAnswerHeader.getAnswers().get(1)).getQuestionNumber());
        Assert.assertEquals((int)4, (int)((Answer)newAnswerHeader.getAnswers().get(2)).getQuestionNumber());
        Assert.assertEquals((int)2, (int)((Answer)newAnswerHeader.getAnswers().get(3)).getQuestionNumber());
        Assert.assertEquals((String)"Y", (String)((Answer)newAnswerHeader.getAnswers().get(0)).getAnswer());
        Assert.assertEquals((String)"10", (String)((Answer)newAnswerHeader.getAnswers().get(1)).getAnswer());
        Assert.assertEquals((String)"", (String)((Answer)newAnswerHeader.getAnswers().get(2)).getAnswer());
        Assert.assertEquals((String)"Test", (String)((Answer)newAnswerHeader.getAnswers().get(3)).getAnswer());
        Assert.assertEquals((String)"Y", (String)((Answer)newAnswerHeader.getAnswers().get(0)).getMatchedChild());
        Assert.assertEquals((String)"Y", (String)((Answer)newAnswerHeader.getAnswers().get(1)).getMatchedChild());
        Assert.assertEquals((String)"N", (String)((Answer)newAnswerHeader.getAnswers().get(2)).getMatchedChild());
        Assert.assertEquals((String)"Y", (String)((Answer)newAnswerHeader.getAnswers().get(3)).getMatchedChild());
    }

    @Test
    public void testGetAnswerHeadersForProtocol() {
        QuestionnaireAnswerServiceImpl questionnaireAnswerServiceImpl = new QuestionnaireAnswerServiceImpl();
        ArrayList<String> protocolNumbers = new ArrayList<String>();
        protocolNumbers.add("0912000001");
        protocolNumbers.add("0912000001A001");
        final HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("moduleItemCode", "7");
        fieldValues.put("moduleItemKey", protocolNumbers);
        final ArrayList<AnswerHeader> headers = new ArrayList<AnswerHeader>();
        AnswerHeader answerHeader1 = this.createAnswerHeaderForVersioning(1L, "0912000001", "0");
        headers.add(answerHeader1);
        AnswerHeader answerHeader2 = this.createAnswerHeaderForVersioning(1L, "0912000001A001", "0");
        answerHeader2.setModuleSubItemCode("1");
        headers.add(answerHeader2);
        AnswerHeader answerHeader3 = this.createAnswerHeaderForVersioning(1L, "0912000001", "1");
        answerHeader3.setModuleSubItemCode("2");
        headers.add(answerHeader3);
        Protocol protocol = new Protocol(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        protocol.setProtocolNumber("0912000001");
        protocol.setSequenceNumber(Integer.valueOf(0));
        final ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        Protocol protocol1 = new Protocol(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        protocol1.setProtocolNumber("0912000001");
        protocols.add(protocol1);
        Protocol protocol2 = new Protocol(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        protocol2.setProtocolNumber("0912000001A001");
        protocols.add(protocol2);
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        final ProtocolFinderDao protocolFinderDao = (ProtocolFinderDao)this.context.mock(ProtocolFinderDao.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(AnswerHeader.class, fieldValues);
                this.will(12.returnValue((Object)headers));
                ((ProtocolFinderDao)this.one(protocolFinderDao)).findProtocols("0912000001");
                this.will(12.returnValue((Object)protocols));
            }
        });
        questionnaireAnswerServiceImpl.setBusinessObjectService(businessObjectService);
        questionnaireAnswerServiceImpl.setProtocolFinderDao(protocolFinderDao);
        List answerHeaders = questionnaireAnswerServiceImpl.getAnswerHeadersForProtocol("0912000001");
        Assert.assertEquals((int)3, (int)answerHeaders.size());
        Assert.assertEquals((String)"0", (String)((AnswerHeader)answerHeaders.get(0)).getModuleSubItemKey());
        Assert.assertEquals((String)"0912000001", (String)((AnswerHeader)answerHeaders.get(0)).getModuleItemKey());
    }
}

