/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.questionnaire.print;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.printing.print.AbstractPrint;
import org.kuali.kra.printing.util.PrintingServiceTestBase;
import org.kuali.kra.printing.util.PrintingTestUtils;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.protocol.actions.print.QuestionnairePrintOption;
import org.kuali.kra.questionnaire.Questionnaire;
import org.kuali.kra.questionnaire.print.QuestionnairePrint;
import org.kuali.kra.questionnaire.print.QuestionnairePrintingService;
import org.kuali.kra.questionnaire.print.QuestionnairePrintingServiceImpl;
import org.kuali.kra.questionnaire.question.Question;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.document.MaintenanceDocumentBase;
import org.kuali.rice.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;

public class QuestionnairePrintingServiceTest
extends PrintingServiceTestBase {
    private QuestionnairePrintingService questionnairePrintingService;
    private Mockery context = new JUnit4Mockery();

    @Test
    public void testQuestionnairePrinting() {
        try {
            String docNumber = this.createQuestionnaireMaintDocument();
            HashMap<String, String> reportParameters = new HashMap<String, String>();
            reportParameters.put("documentNumber", docNumber);
            AttachmentDataSource pdfBytes = this.getPrintingService().printQuestionnaire(null, reportParameters);
            PrintingTestUtils.writePdftoDisk(pdfBytes, "Questionnaire");
            QuestionnairePrintingServiceTest.assertNotNull((Object)pdfBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private String createQuestionnaireMaintDocument() throws WorkflowException {
        MaintenanceDocumentBase maintDocument = (MaintenanceDocumentBase)this.documentService.getNewDocument(((MaintenanceDocumentDictionaryService)KraServiceLocator.getService(MaintenanceDocumentDictionaryService.class)).getDocumentTypeName(Questionnaire.class));
        maintDocument.getDocumentHeader().setDocumentDescription("test 1");
        maintDocument.getNewMaintainableObject().setBusinessObject((PersistableBusinessObject)this.createQuestionnaire("test1", "desc 1"));
        this.documentService.routeDocument((Document)maintDocument, null, null);
        Questionnaire questionnaire = (Questionnaire)maintDocument.getNewMaintainableObject().getDataObject();
        questionnaire.setDocumentNumber(maintDocument.getDocumentNumber());
        this.getBusinessObjectService().save((PersistableBusinessObject)((Questionnaire)maintDocument.getNewMaintainableObject().getDataObject()));
        String docNumber = maintDocument.getDocumentNumber();
        return docNumber;
    }

    private Questionnaire createQuestionnaire(String name, String desc) {
        Questionnaire questionnaire = new Questionnaire();
        questionnaire.setName(name);
        questionnaire.setDescription(desc);
        questionnaire.setSequenceNumber(Integer.valueOf(1));
        return questionnaire;
    }

    private Question createQuestion(Integer questionId, String questionText) {
        Question question = new Question();
        question.setQuestionIdFromInteger(questionId);
        question.setQuestion(questionText);
        return question;
    }

    @Test
    public void testQuestionnaireAnswerPrinting() {
        try {
            HashMap<String, String> reportParameters = new HashMap<String, String>();
            reportParameters.put("documentNumber", this.createQuestionnaireMaintDocument());
            ProtocolDocument document = new ProtocolDocument();
            document.getProtocol().setProtocolNumber("1234");
            AttachmentDataSource pdfBytes = this.getPrintingService().printQuestionnaireAnswer((KraPersistableBusinessObjectBase)document.getProtocol(), reportParameters);
            PrintingTestUtils.writePdftoDisk(pdfBytes, "QuestionnaireAnswer");
            QuestionnairePrintingServiceTest.assertNotNull((Object)pdfBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testGetQuestionnairePrintable() {
        ArrayList<QuestionnairePrintOption> questionnairesToPrints = new ArrayList<QuestionnairePrintOption>();
        QuestionnairePrintOption printOption1 = new QuestionnairePrintOption();
        printOption1.setLabel("Test1");
        printOption1.setItemKey("1234");
        printOption1.setSubItemKey("0");
        printOption1.setQuestionnaireRefId(Long.valueOf(1L));
        printOption1.setQuestionnaireId(Integer.valueOf(1));
        printOption1.setSelected(true);
        questionnairesToPrints.add(printOption1);
        QuestionnairePrintOption printOption2 = new QuestionnairePrintOption();
        printOption2.setLabel("Test2");
        printOption2.setQuestionnaireRefId(Long.valueOf(2L));
        printOption2.setQuestionnaireId(Integer.valueOf(1));
        printOption2.setSelected(false);
        questionnairesToPrints.add(printOption2);
        final HashMap<String, Long> pkMap = new HashMap<String, Long>();
        pkMap.put("questionnaireRefId", 1L);
        try {
            final Questionnaire questionnaire = new Questionnaire();
            questionnaire.setQuestionnaireId("1");
            questionnaire.setQuestionnaireRefIdFromLong(Long.valueOf(1L));
            ProtocolDocument document = new ProtocolDocument();
            final ArrayList<Protocol> protocols = new ArrayList<Protocol>();
            protocols.add(document.getProtocol());
            document.getProtocol().setProtocolNumber("1234");
            final HashMap<String, String> keyValues = new HashMap<String, String>();
            keyValues.put("protocolNumber", "1234");
            keyValues.put("sequenceNumber", "0");
            final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
            QuestionnairePrint questionnairePrint = new QuestionnairePrint();
            QuestionnairePrintingServiceImpl qnPrintingServiceImpl = new QuestionnairePrintingServiceImpl();
            this.context.checking((ExpectationBuilder)new Expectations(){
                {
                    ((BusinessObjectService)this.one(businessObjectService)).findByPrimaryKey(Questionnaire.class, pkMap);
                    this.will(1.returnValue((Object)questionnaire));
                    ((BusinessObjectService)this.one(businessObjectService)).findMatching(Protocol.class, keyValues);
                    this.will(1.returnValue((Object)protocols));
                }
            });
            qnPrintingServiceImpl.setBusinessObjectService(businessObjectService);
            qnPrintingServiceImpl.setQuestionnairePrint(questionnairePrint);
            List printables = qnPrintingServiceImpl.getQuestionnairePrintable((KraPersistableBusinessObjectBase)document.getProtocol(), questionnairesToPrints);
            QuestionnairePrintingServiceTest.assertEquals((long)printables.size(), (long)1L);
            QuestionnairePrintingServiceTest.assertEquals(((AbstractPrint)printables.get(0)).getReportParameters().get("questionnaireId"), (Object)1);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private QuestionnairePrintingService getPrintingService() {
        if (this.questionnairePrintingService == null) {
            this.questionnairePrintingService = (QuestionnairePrintingService)KraServiceLocator.getService(QuestionnairePrintingService.class);
        }
        return this.questionnairePrintingService;
    }
}

