/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.questionnaire.question;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.questionnaire.question.Question;
import org.kuali.kra.questionnaire.question.QuestionAuthorizationService;
import org.kuali.kra.questionnaire.question.QuestionLookupableHelperServiceImpl;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kns.document.MaintenanceDocumentBase;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;

public class QuestionLookupableHelperServiceTest
extends KcUnitTestBase {
    private static final String SEQUENCE_STATUS_CURRENT = "C";
    private static final String SEQUENCE_STATUS_ARCHIVED = "A";
    private QuestionLookupableHelperServiceImpl questionLookupableHelperServiceImpl;
    private DocumentService documentService;
    private Mockery context = new JUnit4Mockery();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.questionLookupableHelperServiceImpl = new QuestionLookupableHelperServiceImpl();
        this.questionLookupableHelperServiceImpl.setBusinessObjectClass(Question.class);
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        parameters.put("multipleValues", new String[]{"Yes"});
        this.questionLookupableHelperServiceImpl.setParameters(parameters);
        this.documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.questionLookupableHelperServiceImpl = null;
        this.documentService = null;
        GlobalVariables.setUserSession(null);
        super.tearDown();
    }

    @Test
    public void testGetSearchResults() throws Exception {
        MaintenanceDocumentBase maintDocument = (MaintenanceDocumentBase)this.documentService.getNewDocument(((MaintenanceDocumentDictionaryService)KraServiceLocator.getService(MaintenanceDocumentDictionaryService.class)).getDocumentTypeName(Question.class));
        maintDocument.getDocumentHeader().setDocumentDescription("test 1111");
        maintDocument.getNewMaintainableObject().setBusinessObject((PersistableBusinessObject)this.createQuestion(1111, SEQUENCE_STATUS_ARCHIVED));
        this.documentService.routeDocument((Document)maintDocument, null, null);
        maintDocument = (MaintenanceDocumentBase)this.documentService.getNewDocument(((MaintenanceDocumentDictionaryService)KraServiceLocator.getService(MaintenanceDocumentDictionaryService.class)).getDocumentTypeName(Question.class));
        maintDocument.getDocumentHeader().setDocumentDescription("test 1112");
        maintDocument.getNewMaintainableObject().setBusinessObject((PersistableBusinessObject)this.createQuestion(1112, SEQUENCE_STATUS_CURRENT));
        this.documentService.routeDocument((Document)maintDocument, null, null);
        List searchResults = this.questionLookupableHelperServiceImpl.getSearchResults(new HashMap());
        Assert.assertThat((Object)searchResults.isEmpty(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)true)));
        for (Question q : searchResults) {
            Assert.assertThat((String)("question retrieved " + q.getQuestionId() + " did not have a status of " + SEQUENCE_STATUS_CURRENT), (Object)q.getSequenceStatus(), (Matcher)CoreMatchers.is((Object)SEQUENCE_STATUS_CURRENT));
        }
    }

    @Test
    public void testGetCustomActionUrlsWithViewQuestionPermission() throws Exception {
        final QuestionAuthorizationService questionAuthorizationService = (QuestionAuthorizationService)this.context.mock(QuestionAuthorizationService.class);
        this.questionLookupableHelperServiceImpl.setQuestionAuthorizationService(questionAuthorizationService);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((QuestionAuthorizationService)this.one(questionAuthorizationService)).hasPermission("Modify Question");
                this.will(1.returnValue((Object)false));
                ((QuestionAuthorizationService)this.one(questionAuthorizationService)).hasPermission("View Question");
                this.will(1.returnValue((Object)true));
            }
        });
        Question question = this.createQuestion(1111, SEQUENCE_STATUS_CURRENT);
        MaintenanceDocumentBase maintDocument = (MaintenanceDocumentBase)this.documentService.getNewDocument(((MaintenanceDocumentDictionaryService)KraServiceLocator.getService(MaintenanceDocumentDictionaryService.class)).getDocumentTypeName(Question.class));
        maintDocument.getDocumentHeader().setDocumentDescription("test 1111");
        maintDocument.getNewMaintainableObject().setBusinessObject((PersistableBusinessObject)question);
        this.documentService.routeDocument((Document)maintDocument, null, null);
        ArrayList<String> pkNames = new ArrayList<String>();
        pkNames.add("questionRefId");
        String docNumber = maintDocument.getDocumentNumber();
        List htmldata = this.questionLookupableHelperServiceImpl.getCustomActionUrls((BusinessObject)maintDocument.getNewMaintainableObject().getBusinessObject(), pkNames);
        Assert.assertEquals((long)htmldata.size(), (long)1L);
        Assert.assertEquals((Object)this.getTailOfUrl(((HtmlData.AnchorHtmlData)htmldata.get(0)).getHref()), (Object)("DocHandler.do?command=displayDocSearchView&readOnly=true&docId=" + docNumber));
    }

    @Test
    public void testGetCustomActionUrlsWithModifyQuestionPermission() throws Exception {
        final QuestionAuthorizationService questionAuthorizationService = (QuestionAuthorizationService)this.context.mock(QuestionAuthorizationService.class);
        this.questionLookupableHelperServiceImpl.setQuestionAuthorizationService(questionAuthorizationService);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((QuestionAuthorizationService)this.one(questionAuthorizationService)).hasPermission("Modify Question");
                this.will(2.returnValue((Object)true));
                ((QuestionAuthorizationService)this.one(questionAuthorizationService)).hasPermission("View Question");
                this.will(2.returnValue((Object)false));
            }
        });
        Question question = this.createQuestion(1111, SEQUENCE_STATUS_CURRENT);
        MaintenanceDocumentBase maintDocument = (MaintenanceDocumentBase)this.documentService.getNewDocument(((MaintenanceDocumentDictionaryService)KraServiceLocator.getService(MaintenanceDocumentDictionaryService.class)).getDocumentTypeName(Question.class));
        maintDocument.getDocumentHeader().setDocumentDescription("test 1111");
        maintDocument.getNewMaintainableObject().setBusinessObject((PersistableBusinessObject)question);
        this.documentService.routeDocument((Document)maintDocument, null, null);
        ArrayList<String> pkNames = new ArrayList<String>();
        pkNames.add("questionRefId");
        String docNumber = maintDocument.getDocumentNumber();
        List htmldata = this.questionLookupableHelperServiceImpl.getCustomActionUrls((BusinessObject)maintDocument.getNewMaintainableObject().getBusinessObject(), pkNames);
        Assert.assertEquals((long)4L, (long)htmldata.size());
        Assert.assertEquals((Object)((HtmlData.AnchorHtmlData)htmldata.get(0)).getHref(), (Object)("../maintenanceQ.do?questionRefId=" + question.getQuestionRefId() + "&businessObjectClassName=org.kuali.kra.questionnaire.question.Question&methodToCall=edit"));
        Assert.assertEquals((Object)((HtmlData.AnchorHtmlData)htmldata.get(1)).getHref(), (Object)("../maintenanceQ.do?questionRefId=" + question.getQuestionRefId() + "&businessObjectClassName=org.kuali.kra.questionnaire.question.Question&methodToCall=copy"));
        Assert.assertEquals((Object)((HtmlData.AnchorHtmlData)htmldata.get(2)).getHref(), (Object)("../maintenanceQ.do?questionRefId=" + question.getQuestionRefId() + "&businessObjectClassName=org.kuali.kra.questionnaire.question.Question&methodToCall=delete"));
        Assert.assertEquals((Object)this.getTailOfUrl(((HtmlData.AnchorHtmlData)htmldata.get(3)).getHref()), (Object)("DocHandler.do?command=displayDocSearchView&readOnly=true&docId=" + docNumber));
    }

    private String getTailOfUrl(String url) {
        int inx = url.indexOf("kew");
        return url.substring(inx + 4);
    }

    @Test
    public void testGetCustomActionUrlsWithNoPermissions() throws Exception {
        final QuestionAuthorizationService questionAuthorizationService = (QuestionAuthorizationService)this.context.mock(QuestionAuthorizationService.class);
        this.questionLookupableHelperServiceImpl.setQuestionAuthorizationService(questionAuthorizationService);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((QuestionAuthorizationService)this.one(questionAuthorizationService)).hasPermission("Modify Question");
                this.will(3.returnValue((Object)false));
                ((QuestionAuthorizationService)this.one(questionAuthorizationService)).hasPermission("View Question");
                this.will(3.returnValue((Object)false));
            }
        });
        Question question = this.createQuestion(1111, SEQUENCE_STATUS_CURRENT);
        MaintenanceDocumentBase maintDocument = (MaintenanceDocumentBase)this.documentService.getNewDocument(((MaintenanceDocumentDictionaryService)KraServiceLocator.getService(MaintenanceDocumentDictionaryService.class)).getDocumentTypeName(Question.class));
        maintDocument.getDocumentHeader().setDocumentDescription("test 1111");
        maintDocument.getNewMaintainableObject().setBusinessObject((PersistableBusinessObject)question);
        this.documentService.routeDocument((Document)maintDocument, null, null);
        ArrayList<String> pkNames = new ArrayList<String>();
        pkNames.add("questionRefId");
        List htmldata = this.questionLookupableHelperServiceImpl.getCustomActionUrls((BusinessObject)maintDocument.getNewMaintainableObject().getBusinessObject(), pkNames);
        Assert.assertEquals((long)htmldata.size(), (long)0L);
    }

    private Question createQuestion(int questionRefId, String sequenceStatus) {
        Question question = new Question();
        question.setQuestionRefId(Long.valueOf(questionRefId));
        question.setQuestionIdFromInteger(Integer.valueOf(questionRefId));
        question.setSequenceStatus(sequenceStatus);
        question.setQuestion("test" + questionRefId);
        question.setStatus(SEQUENCE_STATUS_ARCHIVED);
        question.setCategoryTypeCode(Integer.valueOf(1));
        question.setQuestionTypeId(Integer.valueOf(1));
        return question;
    }
}

