/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.questionnaire.question;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.maintenance.MaintenanceRuleTestBase;
import org.kuali.kra.questionnaire.question.Question;
import org.kuali.kra.questionnaire.question.QuestionMaintenanceDocumentRule;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.springframework.util.AutoPopulatingList;

public class QuestionMaintenanceDocumentRuleTest
extends MaintenanceRuleTestBase {
    private QuestionMaintenanceDocumentRule rule = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new QuestionMaintenanceDocumentRule();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        super.tearDown();
    }

    @Test
    public void testDataDictionaryValidateErrorPaths() throws Exception {
        Question question = new Question();
        MaintenanceDocument questionMaintenanceDocument = this.newMaintDoc((PersistableBusinessObject)question);
        this.rule.dataDictionaryValidate(questionMaintenanceDocument);
        MessageMap errorMap = GlobalVariables.getMessageMap();
        QuestionMaintenanceDocumentRuleTest.assertEquals((long)4L, (long)errorMap.getErrorCount());
        this.assertError("document.newMaintainableObject.businessObject.question");
        this.assertError("document.newMaintainableObject.businessObject.status");
        this.assertError("document.newMaintainableObject.businessObject.categoryTypeCode");
        this.assertError("document.newMaintainableObject.businessObject.questionTypeId");
    }

    @Test
    public void testValidYesNoQuestion() throws Exception {
        Question question = new Question();
        question.setQuestionTypeId(Integer.valueOf(1));
        question.setStatus("A");
        MaintenanceDocument questionMaintenanceDocument = this.newMaintDoc((PersistableBusinessObject)question, (PersistableBusinessObject)question);
        QuestionMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomRouteDocumentBusinessRules(questionMaintenanceDocument));
        MessageMap errorMap = GlobalVariables.getMessageMap();
        QuestionMaintenanceDocumentRuleTest.assertEquals((long)0L, (long)errorMap.getErrorCount());
    }

    @Test
    public void testValidYesNoNaQuestion() throws Exception {
        Question question = new Question();
        question.setQuestionTypeId(Integer.valueOf(2));
        question.setStatus("A");
        MaintenanceDocument questionMaintenanceDocument = this.newMaintDoc((PersistableBusinessObject)question, (PersistableBusinessObject)question);
        QuestionMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomRouteDocumentBusinessRules(questionMaintenanceDocument));
        MessageMap errorMap = GlobalVariables.getMessageMap();
        QuestionMaintenanceDocumentRuleTest.assertEquals((long)0L, (long)errorMap.getErrorCount());
    }

    @Test
    public void testValidNumberQuestion() throws Exception {
        Question question = new Question();
        question.setQuestionTypeId(Integer.valueOf(3));
        question.setStatus("A");
        question.setDisplayedAnswers(Integer.valueOf(1));
        question.setAnswerMaxLength(Integer.valueOf(10));
        question.setMaxAnswers(Integer.valueOf(1));
        MaintenanceDocument questionMaintenanceDocument = this.newMaintDoc((PersistableBusinessObject)question, (PersistableBusinessObject)question);
        QuestionMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomRouteDocumentBusinessRules(questionMaintenanceDocument));
        MessageMap errorMap = GlobalVariables.getMessageMap();
        QuestionMaintenanceDocumentRuleTest.assertEquals((long)0L, (long)errorMap.getErrorCount());
    }

    @Test
    public void testNumberMissingData() throws Exception {
        Question question = new Question();
        question.setQuestionTypeId(Integer.valueOf(3));
        question.setStatus("A");
        MaintenanceDocument questionMaintenanceDocument = this.newMaintDoc((PersistableBusinessObject)question, (PersistableBusinessObject)question);
        QuestionMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomRouteDocumentBusinessRules(questionMaintenanceDocument));
        MessageMap errorMap = GlobalVariables.getMessageMap();
        QuestionMaintenanceDocumentRuleTest.assertEquals((long)3L, (long)errorMap.getErrorCount());
        this.assertError("document.newMaintainableObject.businessObject.displayedAnswers", "error.question.displayed.answers.invalid.boxes");
        this.assertError("document.newMaintainableObject.businessObject.answerMaxLength", "error.question.answer.max.length.invalid");
        this.assertError("document.newMaintainableObject.businessObject.maxAnswers", "error.question.max.answers.invalid.answers.boxes");
    }

    @Test
    public void testValidDateQuestion() throws Exception {
        Question question = new Question();
        question.setQuestionTypeId(Integer.valueOf(4));
        question.setStatus("A");
        question.setDisplayedAnswers(Integer.valueOf(1));
        question.setMaxAnswers(Integer.valueOf(1));
        MaintenanceDocument questionMaintenanceDocument = this.newMaintDoc((PersistableBusinessObject)question, (PersistableBusinessObject)question);
        QuestionMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomRouteDocumentBusinessRules(questionMaintenanceDocument));
        MessageMap errorMap = GlobalVariables.getMessageMap();
        QuestionMaintenanceDocumentRuleTest.assertEquals((long)0L, (long)errorMap.getErrorCount());
    }

    @Test
    public void testDateMissingData() throws Exception {
        Question question = new Question();
        question.setQuestionTypeId(Integer.valueOf(4));
        question.setStatus("A");
        MaintenanceDocument questionMaintenanceDocument = this.newMaintDoc((PersistableBusinessObject)question, (PersistableBusinessObject)question);
        QuestionMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomRouteDocumentBusinessRules(questionMaintenanceDocument));
        MessageMap errorMap = GlobalVariables.getMessageMap();
        QuestionMaintenanceDocumentRuleTest.assertEquals((long)2L, (long)errorMap.getErrorCount());
        this.assertError("document.newMaintainableObject.businessObject.displayedAnswers", "error.question.displayed.answers.invalid.boxes");
        this.assertError("document.newMaintainableObject.businessObject.maxAnswers", "error.question.max.answers.invalid.answers.boxes");
    }

    @Test
    public void testValidTextQuestion() throws Exception {
        Question question = new Question();
        question.setQuestionTypeId(Integer.valueOf(5));
        question.setStatus("A");
        question.setDisplayedAnswers(Integer.valueOf(1));
        question.setAnswerMaxLength(Integer.valueOf(10));
        question.setMaxAnswers(Integer.valueOf(1));
        MaintenanceDocument questionMaintenanceDocument = this.newMaintDoc((PersistableBusinessObject)question, (PersistableBusinessObject)question);
        QuestionMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomRouteDocumentBusinessRules(questionMaintenanceDocument));
        MessageMap errorMap = GlobalVariables.getMessageMap();
        QuestionMaintenanceDocumentRuleTest.assertEquals((long)0L, (long)errorMap.getErrorCount());
    }

    @Test
    public void testTextMissingData() throws Exception {
        Question question = new Question();
        question.setQuestionTypeId(Integer.valueOf(5));
        question.setStatus("A");
        MaintenanceDocument questionMaintenanceDocument = this.newMaintDoc((PersistableBusinessObject)question, (PersistableBusinessObject)question);
        QuestionMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomRouteDocumentBusinessRules(questionMaintenanceDocument));
        MessageMap errorMap = GlobalVariables.getMessageMap();
        QuestionMaintenanceDocumentRuleTest.assertEquals((long)3L, (long)errorMap.getErrorCount());
        this.assertError("document.newMaintainableObject.businessObject.displayedAnswers", "error.question.displayed.answers.invalid.areas");
        this.assertError("document.newMaintainableObject.businessObject.answerMaxLength", "error.question.answer.max.length.invalid");
        this.assertError("document.newMaintainableObject.businessObject.maxAnswers", "error.question.max.answers.invalid.answers.areas");
    }

    @Test
    public void testValidLookupQuestion() throws Exception {
        Question question = new Question();
        question.setQuestionTypeId(Integer.valueOf(6));
        question.setStatus("A");
        question.setLookupClass("org.kuali.kra.proposaldevelopment.bo.AbstractType");
        question.setLookupReturn("abstractTypeCode");
        question.setMaxAnswers(Integer.valueOf(1));
        MaintenanceDocument questionMaintenanceDocument = this.newMaintDoc((PersistableBusinessObject)question, (PersistableBusinessObject)question);
        QuestionMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomRouteDocumentBusinessRules(questionMaintenanceDocument));
        MessageMap errorMap = GlobalVariables.getMessageMap();
        QuestionMaintenanceDocumentRuleTest.assertEquals((long)0L, (long)errorMap.getErrorCount());
    }

    @Test
    public void testLookupMissingData() throws Exception {
        Question question = new Question();
        question.setQuestionIdFromInteger(Integer.valueOf(1));
        question.setQuestionTypeId(Integer.valueOf(6));
        question.setStatus("A");
        MaintenanceDocument questionMaintenanceDocument = this.newMaintDoc((PersistableBusinessObject)question, (PersistableBusinessObject)question);
        QuestionMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomRouteDocumentBusinessRules(questionMaintenanceDocument));
        MessageMap errorMap = GlobalVariables.getMessageMap();
        QuestionMaintenanceDocumentRuleTest.assertEquals((long)3L, (long)errorMap.getErrorCount());
        this.assertError("document.newMaintainableObject.businessObject.lookupClass", "error.question.lookup.class.not.specified");
        this.assertError("document.newMaintainableObject.businessObject.lookupReturn", "error.question.lookup.return.not.specified");
        this.assertError("document.newMaintainableObject.businessObject.maxAnswers", "error.question.max.answers.invalid.returns");
    }

    @Test
    public void testInvalidLookupReturn() throws Exception {
        Question question = new Question();
        question.setQuestionIdFromInteger(Integer.valueOf(1));
        question.setStatus("A");
        question.setQuestionTypeId(Integer.valueOf(6));
        question.setLookupClass("org.kuali.kra.proposaldevelopment.bo.AbstractType");
        question.setLookupReturn("eomProcessFlag");
        question.setMaxAnswers(Integer.valueOf(1));
        MaintenanceDocument questionMaintenanceDocument = this.newMaintDoc((PersistableBusinessObject)question, (PersistableBusinessObject)question);
        QuestionMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomRouteDocumentBusinessRules(questionMaintenanceDocument));
        MessageMap errorMap = GlobalVariables.getMessageMap();
        QuestionMaintenanceDocumentRuleTest.assertEquals((long)1L, (long)errorMap.getErrorCount());
        this.assertError("document.newMaintainableObject.businessObject.lookupReturn", "error.question.lookup.return.invalid");
    }

    @Test
    public void testMissingQuestionResponseType() throws Exception {
        Question question = new Question();
        question.setQuestionIdFromInteger(Integer.valueOf(1));
        question.setStatus("A");
        MaintenanceDocument questionMaintenanceDocument = this.newMaintDoc((PersistableBusinessObject)question, (PersistableBusinessObject)question);
        QuestionMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomRouteDocumentBusinessRules(questionMaintenanceDocument));
        MessageMap errorMap = GlobalVariables.getMessageMap();
        QuestionMaintenanceDocumentRuleTest.assertEquals((long)1L, (long)errorMap.getErrorCount());
        this.assertError("document.newMaintainableObject.businessObject.questionTypeId", "error.question.response.type.not.specified");
    }

    @Test
    public void testInvalidQuestionResponseType() throws Exception {
        Question question = new Question();
        question.setStatus("A");
        question.setQuestionId("1");
        question.setQuestionTypeId(Integer.valueOf(999));
        MaintenanceDocument questionMaintenanceDocument = this.newMaintDoc((PersistableBusinessObject)question, (PersistableBusinessObject)question);
        QuestionMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomRouteDocumentBusinessRules(questionMaintenanceDocument));
        MessageMap errorMap = GlobalVariables.getMessageMap();
        QuestionMaintenanceDocumentRuleTest.assertEquals((long)1L, (long)errorMap.getErrorCount());
        this.assertError("document.newMaintainableObject.businessObject.questionTypeId", "error.question.response.type.invalid");
    }

    protected void assertError(String propertyKey) {
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages(propertyKey);
        QuestionMaintenanceDocumentRuleTest.assertNotNull((Object)errors);
        QuestionMaintenanceDocumentRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        QuestionMaintenanceDocumentRuleTest.assertNotNull((Object)message);
    }

    protected void assertError(String propertyKey, String errorKey) {
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages(propertyKey);
        QuestionMaintenanceDocumentRuleTest.assertNotNull((Object)errors);
        QuestionMaintenanceDocumentRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        QuestionMaintenanceDocumentRuleTest.assertNotNull((Object)message);
        QuestionMaintenanceDocumentRuleTest.assertEquals((Object)message.getErrorKey(), (Object)errorKey);
    }
}

