/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.questionnaire.question;

import java.util.ArrayList;
import java.util.HashMap;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kra.questionnaire.question.Question;
import org.kuali.kra.questionnaire.question.QuestionServiceImpl;
import org.kuali.rice.krad.service.BusinessObjectService;

@RunWith(value=JMock.class)
public class QuestionServiceTest {
    private Mockery context = new JUnit4Mockery();

    @Test
    public void testGetQuestionByRefIdFound() {
        QuestionServiceImpl questionService = new QuestionServiceImpl();
        final HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("questionRefId", "999");
        final Question question = new Question();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findByPrimaryKey(Question.class, fieldValues);
                this.will(1.returnValue((Object)question));
            }
        });
        questionService.setBusinessObjectService(businessObjectService);
        Assert.assertEquals((Object)question, (Object)questionService.getQuestionByRefId("999"));
    }

    @Test
    public void testGetQuestionByRefIdNotFound() {
        QuestionServiceImpl questionService = new QuestionServiceImpl();
        final HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("questionRefId", "999");
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findByPrimaryKey(Question.class, fieldValues);
                this.will(2.returnValue(null));
            }
        });
        questionService.setBusinessObjectService(businessObjectService);
        Assert.assertEquals(null, (Object)questionService.getQuestionByRefId("999"));
    }

    @Test
    public void testGetQuestionByIdFound() {
        QuestionServiceImpl questionService = new QuestionServiceImpl();
        final HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("questionId", "999");
        final ArrayList<Question> questions = new ArrayList<Question>();
        Question question = new Question();
        questions.add(question);
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(Question.class, fieldValues);
                this.will(3.returnValue((Object)questions));
            }
        });
        questionService.setBusinessObjectService(businessObjectService);
        Assert.assertEquals((Object)question, (Object)questionService.getQuestionById("999"));
    }

    @Test
    public void testGetQuestionByIdNotFound() {
        QuestionServiceImpl questionService = new QuestionServiceImpl();
        final HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("questionId", "999");
        final ArrayList questions = new ArrayList();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(Question.class, fieldValues);
                this.will(4.returnValue((Object)questions));
            }
        });
        questionService.setBusinessObjectService(businessObjectService);
        Assert.assertEquals(null, (Object)questionService.getQuestionById("999"));
    }
}

