/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.questionnaire.question;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.questionnaire.question.Question;
import org.kuali.kra.service.VersioningService;
import org.kuali.kra.service.impl.VersioningServiceImpl;

public class QuestionVersioningTest {
    private transient VersioningService versioningService;
    private Question originalQuestion;

    @Before
    public void setUp() {
        this.versioningService = new VersioningServiceImpl();
        this.originalQuestion = this.createQuestion(1, "What is your first name?");
    }

    @After
    public void tearDown() {
        this.versioningService = null;
        this.originalQuestion = null;
    }

    @Test
    public void testQuestionVersioning() throws Exception {
        Question versionedQuestion = (Question)this.versioningService.createNewVersion((SequenceOwner)this.originalQuestion);
        this.verifyVersioning(this.originalQuestion, versionedQuestion);
    }

    public void testQuestionExplanationVersioning() throws Exception {
        this.originalQuestion.setExplanation("Explanation text");
        this.originalQuestion.setPolicy("Policy text");
        this.originalQuestion.setRegulation("Regulation text");
        Question versionedQuestion = (Question)this.versioningService.createNewVersion((SequenceOwner)this.originalQuestion);
        this.verifyVersioning(this.originalQuestion, versionedQuestion);
        Assert.assertEquals((Object)this.originalQuestion.getExplanation(), (Object)versionedQuestion.getExplanation());
        Assert.assertEquals((Object)this.originalQuestion.getPolicy(), (Object)versionedQuestion.getPolicy());
        Assert.assertEquals((Object)this.originalQuestion.getRegulation(), (Object)versionedQuestion.getRegulation());
    }

    private Question createQuestion(Integer questionId, String questionText) {
        Question question = new Question();
        question.setQuestionIdFromInteger(questionId);
        question.setQuestion(questionText);
        return question;
    }

    private void verifyVersioning(Question originalQuestion, Question versionedQuestion) {
        Assert.assertEquals((Object)originalQuestion.getQuestionId(), (Object)versionedQuestion.getQuestionId());
        Assert.assertEquals((Object)originalQuestion.getQuestion(), (Object)versionedQuestion.getQuestion());
        Integer expectedSequenceNumber = originalQuestion.getSequenceNumber() + 1;
        Assert.assertEquals((Object)expectedSequenceNumber, (Object)versionedQuestion.getSequenceNumber());
    }
}

