/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.rice.integration;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentProtocol;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.irb.test.ProtocolTestUtil;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentBase;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kns.service.DictionaryValidationService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ManyToManyValidationTest
extends KcUnitTestBase {
    private DictionaryValidationService dictionaryValidationService;
    private ProtocolDocument doc;
    private Mockery mockery = new JUnit4Mockery();

    @Before
    public void setupDocument() throws Exception {
        this.doc = (ProtocolDocument)((DocumentService)KraServiceLocator.getService(DocumentService.class)).getNewDocument(ProtocolDocument.class);
        Protocol protocol = ProtocolTestUtil.getProtocol(this.mockery);
        this.doc.setProtocol((ProtocolBase)protocol);
        ProtocolFactory.setProtocolRequiredFields(this.doc, null);
        protocol.setProtocolId(Long.valueOf(1L));
        ProtocolAttachmentProtocol attachment = new ProtocolAttachmentProtocol(protocol);
        protocol.addAttachmentsByType((ProtocolAttachmentBase)attachment);
    }

    @Before
    public void setupServices() {
        this.dictionaryValidationService = KNSServiceLocator.getKNSDictionaryValidationService();
    }

    @Test
    public void testManyToManyDocumentValidation() {
        this.dictionaryValidationService.validateDocumentAndUpdatableReferencesRecursively((Document)this.doc, 5, true);
        String badPattern = "protocolList[0].attachmentProtocols[0].sequenceOwners[0].attachmentProtocols[0].*";
        Assert.assertThat((String)GlobalVariables.getMessageMap().toString(), (Object)GlobalVariables.getMessageMap().containsKeyMatchingPattern("protocolList[0].attachmentProtocols[0].sequenceOwners[0].attachmentProtocols[0].*"), (Matcher)Is.is((Object)false));
    }
}

