/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.rules;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.CustomAttributeDocument;
import org.kuali.kra.maintenance.MaintenanceRuleTestBase;
import org.kuali.kra.rules.CustomAttributeDocumentMaintenanceDocumentRule;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.AutoPopulatingList;

public class CustomAttributeDocumentMaintenanceDocumentRuleTest
extends MaintenanceRuleTestBase {
    private CustomAttributeDocumentMaintenanceDocumentRule rule = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new CustomAttributeDocumentMaintenanceDocumentRule();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        super.tearDown();
    }

    @Test
    public void testOK() throws Exception {
        CustomAttributeDocument customAttributeDocument = new CustomAttributeDocument();
        customAttributeDocument.setCustomAttributeId(new Integer(1));
        customAttributeDocument.setActive(true);
        MaintenanceDocument customAttributeDocumentMaintDoc = this.newMaintDoc((PersistableBusinessObject)customAttributeDocument);
        CustomAttributeDocumentMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomRouteDocumentBusinessRules(customAttributeDocumentMaintDoc));
        CustomAttributeDocumentMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomApproveDocumentBusinessRules(customAttributeDocumentMaintDoc));
    }

    @Test
    public void testOkToInactivate() throws Exception {
        CustomAttributeDocument customAttributeDocument = new CustomAttributeDocument();
        customAttributeDocument.setCustomAttributeId(new Integer(8));
        MaintenanceDocument customAttributeDocumentMaintDoc = this.newMaintDoc((PersistableBusinessObject)customAttributeDocument);
        CustomAttributeDocumentMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomRouteDocumentBusinessRules(customAttributeDocumentMaintDoc));
        CustomAttributeDocumentMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomApproveDocumentBusinessRules(customAttributeDocumentMaintDoc));
    }

    @Test
    public void testInvalidCustomAttributeId() throws Exception {
        CustomAttributeDocument customAttributeDocument = new CustomAttributeDocument();
        customAttributeDocument.setCustomAttributeId(new Integer(99));
        MaintenanceDocument customAttributeDocumentMaintDoc = this.newMaintDoc((PersistableBusinessObject)customAttributeDocument);
        CustomAttributeDocumentMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomRouteDocumentBusinessRules(customAttributeDocumentMaintDoc));
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages("document.newMaintainableObject.customAttributeId");
        CustomAttributeDocumentMaintenanceDocumentRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        CustomAttributeDocumentMaintenanceDocumentRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.invalid.customAttributeid");
        CustomAttributeDocumentMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomApproveDocumentBusinessRules(customAttributeDocumentMaintDoc));
        errors = GlobalVariables.getMessageMap().getMessages("document.newMaintainableObject.customAttributeId");
        CustomAttributeDocumentMaintenanceDocumentRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        message = (ErrorMessage)errors.get(0);
        CustomAttributeDocumentMaintenanceDocumentRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.invalid.customAttributeid");
    }
}

