/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.rules;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.CustomAttribute;
import org.kuali.kra.maintenance.MaintenanceRuleTestBase;
import org.kuali.kra.rules.CustomAttributeMaintenanceDocumentRule;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.AutoPopulatingList;

public class CustomAttributeMaintenanceDocumentRuleTest
extends MaintenanceRuleTestBase {
    private CustomAttributeMaintenanceDocumentRule rule = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new CustomAttributeMaintenanceDocumentRule();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        super.tearDown();
    }

    @Test
    public void testOK() throws Exception {
        CustomAttribute customAttribute = new CustomAttribute();
        customAttribute.setLookupClass("org.kuali.kra.bo.DegreeType");
        customAttribute.setLookupReturn("degreeCode");
        MaintenanceDocument customAttributeDocument = this.newMaintDoc((PersistableBusinessObject)customAttribute);
        CustomAttributeMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomRouteDocumentBusinessRules(customAttributeDocument));
        CustomAttributeMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomApproveDocumentBusinessRules(customAttributeDocument));
    }

    @Test
    public void testUnspecifiedLookupReturn() throws Exception {
        CustomAttribute customAttribute = new CustomAttribute();
        customAttribute.setLookupClass("org.kuali.kra.bo.DegreeType");
        MaintenanceDocument customAttributeDocument = this.newMaintDoc((PersistableBusinessObject)customAttribute);
        CustomAttributeMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomRouteDocumentBusinessRules(customAttributeDocument));
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages("document.newMaintainableObject.lookupReturn");
        CustomAttributeMaintenanceDocumentRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        CustomAttributeMaintenanceDocumentRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.required");
        CustomAttributeMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomApproveDocumentBusinessRules(customAttributeDocument));
        errors = GlobalVariables.getMessageMap().getMessages("document.newMaintainableObject.lookupReturn");
        CustomAttributeMaintenanceDocumentRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        message = (ErrorMessage)errors.get(0);
        CustomAttributeMaintenanceDocumentRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.required");
    }
}

