/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.rules;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.CustomAttribute;
import org.kuali.kra.bo.CustomAttributeDocValue;
import org.kuali.kra.bo.CustomAttributeDocument;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.rules.ResearchDocumentBaseAuditRule;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;

public class ResearchDocumentBaseAuditRuleTest
extends KcUnitTestBase {
    private static final String DEFAULT_PROPOSAL_SPONSOR_CODE = "123456";
    private static final String DEFAULT_PROPOSAL_TITLE = "Project title";
    private static final String DEFAULT_PROPOSAL_ACTIVITY_TYPE = "1";
    private static final String DEFAULT_PROPOSAL_OWNED_BY_UNIT = "000002";
    private static final String PROPOSAL_TYPE_NEW = "1";
    private DocumentService documentService = null;
    private ResearchDocumentBaseAuditRule auditRule = null;
    private Date defaultProposalRequestedStartDate = null;
    private Date defaultProposalRequestedEndDate = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        KNSGlobalVariables.setAuditErrorMap(new HashMap());
        this.documentService = KRADServiceLocatorWeb.getDocumentService();
        this.auditRule = new ResearchDocumentBaseAuditRule();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        this.defaultProposalRequestedStartDate = new Date(dateFormat.parse("08/14/2007").getTime());
        this.defaultProposalRequestedEndDate = new Date(dateFormat.parse("08/21/2007").getTime());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        GlobalVariables.setUserSession(null);
        KNSGlobalVariables.setAuditErrorMap(null);
        this.documentService = null;
        this.auditRule = null;
        this.defaultProposalRequestedStartDate = null;
        this.defaultProposalRequestedEndDate = null;
        super.tearDown();
    }

    @Test
    public void testRequiredCustomAttributeFieldsMissing() throws Exception {
        ProposalDevelopmentDocument document = this.getNewDocument();
        HashMap<String, CustomAttribute> requiredFields = new HashMap<String, CustomAttribute>();
        Map customAttributeDocuments = document.getCustomAttributeDocuments();
        for (Map.Entry customAttributeDocumentEntry : customAttributeDocuments.entrySet()) {
            CustomAttributeDocument customAttributeDocument = (CustomAttributeDocument)customAttributeDocumentEntry.getValue();
            CustomAttribute customAttribute = customAttributeDocument.getCustomAttribute();
            if (customAttributeDocument.isRequired()) {
                requiredFields.put("customData." + customAttribute.getGroupName() + customAttribute.getName(), customAttribute);
            }
            CustomAttributeDocValue newValue = new CustomAttributeDocValue();
            newValue.setCustomAttribute(customAttributeDocument.getCustomAttribute());
            newValue.setCustomAttributeId(Long.valueOf(customAttributeDocument.getCustomAttributeId().longValue()));
            newValue.setValue(null);
            document.getCustomDataList().add(newValue);
        }
        ResearchDocumentBaseAuditRuleTest.assertFalse((String)"Audit Rule should produce an audit error", (boolean)this.auditRule.processRunAuditBusinessRules((Document)document));
        ResearchDocumentBaseAuditRuleTest.assertEquals((long)requiredFields.size(), (long)KNSGlobalVariables.getAuditErrorMap().size());
        for (String key : requiredFields.keySet()) {
            CustomAttributeDocValue value;
            CustomAttribute customAttribute = (CustomAttribute)requiredFields.get(key);
            AuditCluster auditCluster = (AuditCluster)KNSGlobalVariables.getAuditErrorMap().get("CustomData" + StringUtils.deleteWhitespace((String)customAttribute.getGroupName()) + "Errors");
            ResearchDocumentBaseAuditRuleTest.assertEquals((long)1L, (long)auditCluster.getSize());
            ResearchDocumentBaseAuditRuleTest.assertEquals((Object)customAttribute.getGroupName(), (Object)auditCluster.getLabel());
            ResearchDocumentBaseAuditRuleTest.assertEquals((Object)"Validation Errors", (Object)auditCluster.getCategory());
            AuditError auditError = (AuditError)auditCluster.getAuditErrorList().get(0);
            int index = 0;
            Iterator i$ = document.getCustomDataList().iterator();
            while (i$.hasNext() && (value = (CustomAttributeDocValue)i$.next()).getCustomAttributeId().longValue() != customAttribute.getId().longValue()) {
                ++index;
            }
            ResearchDocumentBaseAuditRuleTest.assertEquals((Object)("customDataHelper.customDataList[" + index + "].value"), (Object)auditError.getErrorKey());
            ResearchDocumentBaseAuditRuleTest.assertEquals((Object)("customData." + StringUtils.deleteWhitespace((String)customAttribute.getGroupName())), (Object)auditError.getLink());
            ResearchDocumentBaseAuditRuleTest.assertEquals((Object)customAttribute.getLabel(), (Object)auditError.getParams()[0]);
            ResearchDocumentBaseAuditRuleTest.assertEquals((Object)"error.required", (Object)auditError.getMessageKey());
        }
    }

    @Test
    public void testRequiredCustomAttributeFieldsPopulated() throws Exception {
        ProposalDevelopmentDocument document = this.getNewDocument();
        Map customAttributeDocuments = document.getCustomAttributeDocuments();
        for (Map.Entry customAttributeDocumentEntry : customAttributeDocuments.entrySet()) {
            CustomAttributeDocument customAttributeDocument = (CustomAttributeDocument)customAttributeDocumentEntry.getValue();
            CustomAttribute customAttribute = customAttributeDocument.getCustomAttribute();
            if (!customAttributeDocument.isRequired()) continue;
            customAttribute.setValue("5");
        }
        ResearchDocumentBaseAuditRuleTest.assertTrue((String)"Audit Rule shouldn't produce any audit errors", (boolean)this.auditRule.processRunAuditBusinessRules((Document)document));
        ResearchDocumentBaseAuditRuleTest.assertEquals((long)0L, (long)KNSGlobalVariables.getAuditErrorMap().size());
    }

    private ProposalDevelopmentDocument getNewDocument() throws WorkflowException {
        ProposalDevelopmentDocument document = (ProposalDevelopmentDocument)this.documentService.getNewDocument("ProposalDevelopmentDocument");
        document.initialize();
        this.setRequiredDocumentFields(document, DEFAULT_PROPOSAL_SPONSOR_CODE, DEFAULT_PROPOSAL_TITLE, this.defaultProposalRequestedStartDate, this.defaultProposalRequestedEndDate, "1", "1", DEFAULT_PROPOSAL_OWNED_BY_UNIT);
        return document;
    }

    private void setRequiredDocumentFields(ProposalDevelopmentDocument document, String sponsorCode, String title, Date requestedStartDateInitial, Date requestedEndDateInitial, String activityTypeCode, String proposalTypeCode, String ownedByUnit) {
        document.getDevelopmentProposal().setSponsorCode(sponsorCode);
        document.getDevelopmentProposal().setTitle(title);
        document.getDevelopmentProposal().setRequestedStartDateInitial(requestedStartDateInitial);
        document.getDevelopmentProposal().setRequestedEndDateInitial(requestedEndDateInitial);
        document.getDevelopmentProposal().setActivityTypeCode(activityTypeCode);
        document.getDevelopmentProposal().setProposalTypeCode(proposalTypeCode);
        document.getDevelopmentProposal().setOwnedByUnitNumber(ownedByUnit);
    }
}

