/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.rules;

import java.util.UUID;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.CustomAttributeDocValue;
import org.kuali.kra.bo.CustomAttributeDocument;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.document.ResearchDocumentBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.infrastructure.TestUtilities;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentRuleTestBase;
import org.kuali.kra.proposaldevelopment.service.ProposalRoleTemplateService;
import org.kuali.kra.rule.event.SaveCustomDataEvent;
import org.kuali.kra.rules.CustomDataRule;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.AutoPopulatingList;

public class SaveCustomAttributeRuleTest
extends ProposalDevelopmentRuleTestBase {
    private CustomDataRule rule = null;
    private BusinessObjectService bos;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new CustomDataRule();
        this.bos = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        this.bos = null;
        super.tearDown();
    }

    protected void setCustomAttributeValue(ProposalDevelopmentDocument document, CustomAttributeDocument customAttribute, String value) {
        CustomAttributeDocValue newValue = new CustomAttributeDocValue();
        newValue.setCustomAttribute(customAttribute.getCustomAttribute());
        newValue.setCustomAttributeId(Long.valueOf(customAttribute.getCustomAttributeId().longValue()));
        newValue.setValue(value);
        document.getCustomDataList().add(newValue);
    }

    @Test
    public void testOK() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        document.setCustomAttributeDocuments(TestUtilities.setupTestCustomAttributeDocuments());
        this.setCustomAttributeValue(document, (CustomAttributeDocument)document.getCustomAttributeDocuments().get("1"), "This is billing element");
        this.setCustomAttributeValue(document, (CustomAttributeDocument)document.getCustomAttributeDocuments().get("4"), "5");
        this.setCustomAttributeValue(document, (CustomAttributeDocument)document.getCustomAttributeDocuments().get("8"), "02/08/2008");
        this.setCustomAttributeValue(document, (CustomAttributeDocument)document.getCustomAttributeDocuments().get("9"), "Yes");
        this.setCustomAttributeValue(document, (CustomAttributeDocument)document.getCustomAttributeDocuments().get("5"), "quickstart");
        SaveCustomDataEvent saveCustomAttributeEvent = new SaveCustomDataEvent((ResearchDocumentBase)document);
        SaveCustomAttributeRuleTest.assertTrue((boolean)this.rule.processRules(saveCustomAttributeEvent));
    }

    @Test
    public void testUnspecifiedRequiredField() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        document.setCustomAttributeDocuments(TestUtilities.setupTestCustomAttributeDocuments());
        this.setCustomAttributeValue(document, (CustomAttributeDocument)document.getCustomAttributeDocuments().get("4"), "5");
        this.setCustomAttributeValue(document, (CustomAttributeDocument)document.getCustomAttributeDocuments().get("8"), "02/08/2008");
        SaveCustomDataEvent saveCustomAttributeEvent = new SaveCustomDataEvent((ResearchDocumentBase)document);
        SaveCustomAttributeRuleTest.assertTrue((boolean)this.rule.processRules(saveCustomAttributeEvent));
        UserSession currentSession = GlobalVariables.getUserSession();
        String kualiSessionId = currentSession.getKualiSessionId();
        if (kualiSessionId == null) {
            kualiSessionId = UUID.randomUUID().toString();
            currentSession.setKualiSessionId(kualiSessionId);
        }
        PessimisticLock lock = KRADServiceLocatorWeb.getPessimisticLockService().generateNewLock(document.getDocumentNumber(), "PROPOSAL-" + document.getDocumentNumber(), currentSession.getPerson());
        document.addPessimisticLock(lock);
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        KraAuthorizationService kraAuthService = (KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class);
        try {
            ((DocumentService)KraServiceLocator.getService(DocumentService.class)).saveDocument((Document)document);
            if (!kraAuthService.hasRole(userId, (Permissionable)document, "Aggregator")) {
                kraAuthService.addRole(userId, "Aggregator", (Permissionable)document);
            }
            ProposalRoleTemplateService proposalRoleTemplateService = (ProposalRoleTemplateService)KraServiceLocator.getService(ProposalRoleTemplateService.class);
            proposalRoleTemplateService.addUsers(document);
            ((DocumentService)KraServiceLocator.getService(DocumentService.class)).routeDocument((Document)document, "just testing", null);
        }
        catch (ValidationException ex) {
            SaveCustomAttributeRuleTest.assertEquals((Object)ex.getMessage(), (Object)"business rule evaluation failed");
        }
    }

    @Test
    public void testInvalidNumberFormat() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        document.setCustomAttributeDocuments(TestUtilities.setupTestCustomAttributeDocuments());
        this.setCustomAttributeValue(document, (CustomAttributeDocument)document.getCustomAttributeDocuments().get("1"), "This is billing element");
        this.setCustomAttributeValue(document, (CustomAttributeDocument)document.getCustomAttributeDocuments().get("4"), "5a");
        this.setCustomAttributeValue(document, (CustomAttributeDocument)document.getCustomAttributeDocuments().get("8"), "02/08/2008");
        SaveCustomDataEvent saveCustomAttributeEvent = new SaveCustomDataEvent((ResearchDocumentBase)document);
        SaveCustomAttributeRuleTest.assertFalse((boolean)this.rule.processRules(saveCustomAttributeEvent));
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages("customDataHelper.customDataList[1].value");
        SaveCustomAttributeRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        SaveCustomAttributeRuleTest.assertEquals((Object)"error.invalidFormat.withFormat", (Object)message.getErrorKey());
    }

    @Test
    public void testInvalidLength() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        document.setCustomAttributeDocuments(TestUtilities.setupTestCustomAttributeDocuments());
        this.setCustomAttributeValue(document, (CustomAttributeDocument)document.getCustomAttributeDocuments().get("1"), "This is billing element123456789012345678901234567890");
        this.setCustomAttributeValue(document, (CustomAttributeDocument)document.getCustomAttributeDocuments().get("4"), "5");
        this.setCustomAttributeValue(document, (CustomAttributeDocument)document.getCustomAttributeDocuments().get("8"), "02/08/2008");
        SaveCustomDataEvent saveCustomAttributeEvent = new SaveCustomDataEvent((ResearchDocumentBase)document);
        SaveCustomAttributeRuleTest.assertFalse((boolean)this.rule.processRules(saveCustomAttributeEvent));
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages("customDataHelper.customDataList[0].value");
        SaveCustomAttributeRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        SaveCustomAttributeRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.maxLength");
    }

    @Test
    public void testInvalidDateFormat() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        document.setCustomAttributeDocuments(TestUtilities.setupTestCustomAttributeDocuments());
        this.setCustomAttributeValue(document, (CustomAttributeDocument)document.getCustomAttributeDocuments().get("1"), "This is billing element");
        this.setCustomAttributeValue(document, (CustomAttributeDocument)document.getCustomAttributeDocuments().get("4"), "5");
        this.setCustomAttributeValue(document, (CustomAttributeDocument)document.getCustomAttributeDocuments().get("8"), "2008-02-08");
        SaveCustomDataEvent saveCustomAttributeEvent = new SaveCustomDataEvent((ResearchDocumentBase)document);
        SaveCustomAttributeRuleTest.assertFalse((boolean)this.rule.processRules(saveCustomAttributeEvent));
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages("customDataHelper.customDataList[2].value");
        SaveCustomAttributeRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        SaveCustomAttributeRuleTest.assertEquals((Object)"error.invalidFormat", (Object)message.getErrorKey());
    }

    @Test
    public void testInvalidDateValue() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        document.setCustomAttributeDocuments(TestUtilities.setupTestCustomAttributeDocuments());
        this.setCustomAttributeValue(document, (CustomAttributeDocument)document.getCustomAttributeDocuments().get("1"), "This is billing element");
        this.setCustomAttributeValue(document, (CustomAttributeDocument)document.getCustomAttributeDocuments().get("4"), "5");
        this.setCustomAttributeValue(document, (CustomAttributeDocument)document.getCustomAttributeDocuments().get("8"), "02/29/2010");
        SaveCustomDataEvent saveCustomAttributeEvent = new SaveCustomDataEvent((ResearchDocumentBase)document);
        SaveCustomAttributeRuleTest.assertFalse((boolean)this.rule.processRules(saveCustomAttributeEvent));
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages("customDataHelper.customDataList[2].value");
        SaveCustomAttributeRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        SaveCustomAttributeRuleTest.assertEquals((Object)"error.date", (Object)message.getErrorKey());
    }

    @Test
    public void testInvalidPerson() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        document.setCustomAttributeDocuments(TestUtilities.setupTestCustomAttributeDocuments());
        this.setCustomAttributeValue(document, (CustomAttributeDocument)document.getCustomAttributeDocuments().get("1"), "This is billing element");
        this.setCustomAttributeValue(document, (CustomAttributeDocument)document.getCustomAttributeDocuments().get("4"), "5");
        this.setCustomAttributeValue(document, (CustomAttributeDocument)document.getCustomAttributeDocuments().get("8"), "02/08/2008");
        this.setCustomAttributeValue(document, (CustomAttributeDocument)document.getCustomAttributeDocuments().get("5"), "noarealperson");
        SaveCustomDataEvent saveCustomAttributeEvent = new SaveCustomDataEvent((ResearchDocumentBase)document);
        SaveCustomAttributeRuleTest.assertFalse((boolean)this.rule.processRules(saveCustomAttributeEvent));
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages("customDataHelper.customDataList[3].value");
        SaveCustomAttributeRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        SaveCustomAttributeRuleTest.assertEquals((Object)"error.existence", (Object)message.getErrorKey());
    }

    @Test
    public void testInvalidLookup() throws Exception {
        ProposalDevelopmentDocument document = this.getNewProposalDevelopmentDocument();
        document.setCustomAttributeDocuments(TestUtilities.setupTestCustomAttributeDocuments());
        this.setCustomAttributeValue(document, (CustomAttributeDocument)document.getCustomAttributeDocuments().get("1"), "This is billing element");
        this.setCustomAttributeValue(document, (CustomAttributeDocument)document.getCustomAttributeDocuments().get("4"), "5");
        this.setCustomAttributeValue(document, (CustomAttributeDocument)document.getCustomAttributeDocuments().get("8"), "02/08/2008");
        this.setCustomAttributeValue(document, (CustomAttributeDocument)document.getCustomAttributeDocuments().get("9"), "Uh");
        SaveCustomDataEvent saveCustomAttributeEvent = new SaveCustomDataEvent((ResearchDocumentBase)document);
        SaveCustomAttributeRuleTest.assertFalse((boolean)this.rule.processRules(saveCustomAttributeEvent));
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages("customDataHelper.customDataList[3].value");
        SaveCustomAttributeRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        SaveCustomAttributeRuleTest.assertEquals((Object)"error.existence", (Object)message.getErrorKey());
    }
}

