/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.rules;

import java.util.Collection;
import java.util.Map;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.home.AwardTemplate;
import org.kuali.kra.award.home.AwardTemplateTerm;
import org.kuali.kra.bo.SponsorTerm;
import org.kuali.kra.bo.SponsorTermType;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rules.SponsorTemplateTermsExistenceRule;
import org.kuali.kra.service.ServiceHelper;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.document.MaintenanceDocumentBase;
import org.kuali.rice.kns.maintenance.KualiMaintainableImpl;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class SponsorTemplateTermsExistenceRuleTest
extends KcUnitTestBase {
    MaintenanceDocument sponsorTemplateDoc;
    SponsorTemplateTermsExistenceRule rule;
    DocumentService docService;
    AwardTemplate awardTemplate;
    Maintainable maintainableObject;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.docService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        this.sponsorTemplateDoc = (MaintenanceDocumentBase)this.docService.getNewDocument(MaintenanceDocumentBase.class);
        this.rule = new SponsorTemplateTermsExistenceRule();
        this.awardTemplate = new AwardTemplate();
        KualiMaintainableImpl maintainable = new KualiMaintainableImpl();
        maintainable.setBusinessObject((PersistableBusinessObject)this.awardTemplate);
        this.sponsorTemplateDoc.setNewMaintainableObject((org.kuali.rice.krad.maintenance.Maintainable)maintainable);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.docService = null;
        this.sponsorTemplateDoc = null;
        this.rule = null;
        this.awardTemplate = null;
    }

    @Test
    public void testSponsorTemplateTermsExistenceRule() throws Exception {
        SponsorTemplateTermsExistenceRuleTest.assertFalse((boolean)this.rule.processCustomRouteDocumentBusinessRules(this.sponsorTemplateDoc));
        BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        Collection types = businessObjectService.findAll(SponsorTermType.class);
        for (SponsorTermType aType : types) {
            String aCode = aType.getSponsorTermTypeCode();
            Map map = ServiceHelper.getInstance().buildCriteriaMap("sponsorTermTypeCode", (Object)aCode);
            Collection terms = businessObjectService.findMatching(SponsorTerm.class, map);
            if (terms.isEmpty()) continue;
            SponsorTerm aSponsorTerm = (SponsorTerm)terms.iterator().next();
            Long aSponsorTermId = aSponsorTerm.getSponsorTermId();
            map = ServiceHelper.getInstance().buildCriteriaMap("sponsorTermId", (Object)aSponsorTermId.toString());
            Collection templateTerms = businessObjectService.findMatching(AwardTemplateTerm.class, map);
            if (!templateTerms.isEmpty()) {
                this.awardTemplate.getTemplateTerms().add(templateTerms.iterator().next());
                continue;
            }
            AwardTemplateTerm aTemplateTerm = new AwardTemplateTerm();
            aTemplateTerm.setSponsorTerm(aSponsorTerm);
            aTemplateTerm.setSponsorTermId(aSponsorTermId);
            this.awardTemplate.getTemplateTerms().add(aTemplateTerm);
        }
        SponsorTemplateTermsExistenceRuleTest.assertTrue((boolean)this.rule.processCustomRouteDocumentBusinessRules(this.sponsorTemplateDoc));
    }
}

