/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.rules;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.maintenance.MaintenanceRuleTestBase;
import org.kuali.kra.rules.UnitMaintenanceDocumentRule;
import org.kuali.kra.service.impl.mocks.MockUnitService;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.LookupService;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.AutoPopulatingList;

public class UnitMaintenanceDocumentRuleTest
extends MaintenanceRuleTestBase {
    private UnitMaintenanceDocumentRule rule = null;
    private MockUnitService unitService;
    private LookupService lookupService;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new UnitMaintenanceDocumentRule();
        this.lookupService = KRADServiceLocatorWeb.getLookupService();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        this.lookupService = null;
        super.tearDown();
    }

    @Test
    public void testOK() throws Exception {
        Unit unit = new Unit();
        String unitNumber = "BL-RCEN";
        unit.setUnitName(unitNumber);
        unit.setUnitNumber("BL-RCEN");
        unit.setParentUnitNumber("IN-IN");
        unit.setOrganizationId("00001");
        MaintenanceDocument unitmaintenancedocument = this.newMaintDoc((PersistableBusinessObject)unit);
        UnitMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomApproveDocumentBusinessRules(unitmaintenancedocument));
    }

    @Test
    public void testMoveUnitOwnDescendant() throws Exception {
        Unit unit = new Unit();
        unit.setUnitName("IN-IN");
        unit.setUnitNumber("IN-IN");
        unit.setParentUnitNumber("IN-MED");
        unit.setOrganizationId("00001");
        MaintenanceDocument unitmaintenancedocument = this.newMaintDoc((PersistableBusinessObject)unit);
        UnitMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomRouteDocumentBusinessRules(unitmaintenancedocument));
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages("ddocument.newMaintainableObject.parentUnitNumber");
        errors = GlobalVariables.getMessageMap().getMessages("document.newMaintainableObject.parentUnitNumber");
        UnitMaintenanceDocumentRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        UnitMaintenanceDocumentRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error_move_unit");
    }
}

