/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.rules;

import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.ValidSpecialReviewApproval;
import org.kuali.kra.maintenance.MaintenanceRuleTestBase;
import org.kuali.kra.rules.ValidSpecialReviewApprovalMaintenanceRule;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;

public class ValidSpecialReviewApprovalMaintenanceRuleTest
extends MaintenanceRuleTestBase {
    private ValidSpecialReviewApprovalMaintenanceRule rule;
    private MaintenanceDocument maintDoc;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new ValidSpecialReviewApprovalMaintenanceRule();
        ValidSpecialReviewApproval specialReviewApproval = new ValidSpecialReviewApproval();
        this.maintDoc = this.newMaintDoc((PersistableBusinessObject)specialReviewApproval);
    }

    @Test
    public void testBothInvalid() throws Exception {
        ValidSpecialReviewApproval specialReviewApproval = (ValidSpecialReviewApproval)this.maintDoc.getDocumentBusinessObject();
        specialReviewApproval.setApprovalTypeCode("-9999");
        specialReviewApproval.setSpecialReviewTypeCode("-9999");
        boolean valid = this.rule.processCustomRouteDocumentBusinessRules(this.maintDoc);
        ValidSpecialReviewApprovalMaintenanceRuleTest.assertFalse((boolean)valid);
        ValidSpecialReviewApprovalMaintenanceRuleTest.assertEquals((long)2L, (long)GlobalVariables.getMessageMap().getErrorCount());
        ValidSpecialReviewApprovalMaintenanceRuleTest.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorMessagesForProperty("document.newMaintainableObject.approvalTypeCode").size());
        ValidSpecialReviewApprovalMaintenanceRuleTest.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorMessagesForProperty("document.newMaintainableObject.specialReviewCode").size());
    }

    @Test
    public void testInvalidReviewCode() throws Exception {
        ValidSpecialReviewApproval specialReviewApproval = (ValidSpecialReviewApproval)this.maintDoc.getDocumentBusinessObject();
        specialReviewApproval.setApprovalTypeCode("2");
        specialReviewApproval.setSpecialReviewTypeCode("-9999");
        boolean valid = this.rule.processCustomRouteDocumentBusinessRules(this.maintDoc);
        ValidSpecialReviewApprovalMaintenanceRuleTest.assertFalse((boolean)valid);
        ValidSpecialReviewApprovalMaintenanceRuleTest.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        ValidSpecialReviewApprovalMaintenanceRuleTest.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorMessagesForProperty("document.newMaintainableObject.specialReviewCode").size());
    }

    @Test
    public void testInvalidApprovalCode() throws Exception {
        ValidSpecialReviewApproval specialReviewApproval = (ValidSpecialReviewApproval)this.maintDoc.getDocumentBusinessObject();
        specialReviewApproval.setApprovalTypeCode("-9999");
        specialReviewApproval.setSpecialReviewTypeCode("1");
        boolean valid = this.rule.processCustomRouteDocumentBusinessRules(this.maintDoc);
        ValidSpecialReviewApprovalMaintenanceRuleTest.assertFalse((boolean)valid);
        ValidSpecialReviewApprovalMaintenanceRuleTest.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        ValidSpecialReviewApprovalMaintenanceRuleTest.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorMessagesForProperty("document.newMaintainableObject.approvalTypeCode").size());
    }

    @Test
    public void testBothValid() throws Exception {
        ValidSpecialReviewApproval specialReviewApproval = (ValidSpecialReviewApproval)this.maintDoc.getDocumentBusinessObject();
        specialReviewApproval.setApprovalTypeCode("4");
        specialReviewApproval.setSpecialReviewTypeCode("1");
        boolean valid = this.rule.processCustomRouteDocumentBusinessRules(this.maintDoc);
        ValidSpecialReviewApprovalMaintenanceRuleTest.assertTrue((boolean)valid);
        ValidSpecialReviewApprovalMaintenanceRuleTest.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }
}

