/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.xmlbeans.XmlObject;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentService;
import org.kuali.kra.s2s.generator.S2SBaseFormGenerator;
import org.kuali.kra.s2s.service.S2SValidatorService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class S2STestBase<T>
extends KcUnitTestBase {
    private S2SBaseFormGenerator generatorObject;
    private static ProposalDevelopmentDocument document;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.initializeApp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        GlobalVariables.setUserSession(null);
        super.tearDown();
    }

    protected abstract void prepareData(ProposalDevelopmentDocument var1) throws Exception;

    protected abstract Class<T> getFormGeneratorClass();

    @Test
    public void testValidateForm() throws Exception {
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        this.prepareData(document);
        this.saveBO((PersistableBusinessObjectBase)document);
        ArrayList errors = new ArrayList();
        this.generatorObject.setAuditErrors(errors);
        this.generatorObject.setAttachments(new ArrayList());
        XmlObject object = this.generatorObject.getFormObject(document);
        this.getService(S2SValidatorService.class).validate(this.generatorObject.getFormObject(document), errors);
        for (AuditError auditError : errors) {
            S2STestBase.assertNull((String)(auditError.getMessageKey() + ":" + auditError.getErrorKey()), (Object)auditError.getErrorKey());
        }
    }

    private void saveProposalDocument(ProposalDevelopmentDocument pd) throws Exception {
        pd.setUpdateUser("quickst");
        pd.setUpdateTimestamp(new Timestamp(Calendar.getInstance().getTimeInMillis()));
        DocumentHeader docHeader = pd.getDocumentHeader();
        docHeader.setDocumentDescription("Test s2s service description");
        String docNumber = docHeader.getDocumentNumber();
        S2STestBase.assertNotNull((Object)docNumber);
        S2STestBase.assertNotNull((Object)pd.getDevelopmentProposal());
        S2STestBase.assertEquals((long)1L, (long)pd.getDevelopmentProposalList().size());
        this.getDocumentService().saveDocument((Document)pd);
    }

    private ProposalDevelopmentDocument initializeDocument() throws Exception {
        ProposalDevelopmentDocument pd = (ProposalDevelopmentDocument)this.getDocumentService().getNewDocument("ProposalDevelopmentDocument");
        ProposalDevelopmentService pdService = this.getService(ProposalDevelopmentService.class);
        pdService.initializeUnitOrganizationLocation(pd);
        pdService.initializeProposalSiteNumbers(pd);
        return pd;
    }

    private DevelopmentProposal initializeDevelopmentProposal(ProposalDevelopmentDocument pd) {
        DevelopmentProposal developmentProposal = pd.getDevelopmentProposal();
        developmentProposal.setPrimeSponsorCode("000120");
        developmentProposal.setActivityTypeCode("1");
        developmentProposal.refreshReferenceObject("activityType");
        developmentProposal.setSponsorCode("000162");
        developmentProposal.setOwnedByUnitNumber("000001");
        developmentProposal.refreshReferenceObject("ownedByUnit");
        developmentProposal.setProposalTypeCode("1");
        developmentProposal.setCreationStatusCode("1");
        developmentProposal.setApplicantOrganizationId("000001");
        developmentProposal.setPerformingOrganizationId("000001");
        developmentProposal.setNoticeOfOpportunityCode("1");
        developmentProposal.setRequestedStartDateInitial(new Date(Calendar.getInstance().getTimeInMillis()));
        developmentProposal.setRequestedEndDateInitial(new Date(Calendar.getInstance().getTimeInMillis()));
        developmentProposal.setTitle("Test s2s service title");
        developmentProposal.setDeadlineType("P");
        developmentProposal.setDeadlineDate(new Date(Calendar.getInstance().getTimeInMillis()));
        developmentProposal.setNsfCode("J.05");
        return developmentProposal;
    }

    protected void saveBO(PersistableBusinessObjectBase bo) {
        this.getService(BusinessObjectService.class).save((PersistableBusinessObject)bo);
    }

    private void initializeApp() throws Exception {
        try {
            this.generatorObject = (S2SBaseFormGenerator)this.getFormGeneratorClass().newInstance();
            document = this.initializeDocument();
            this.initializeDevelopmentProposal(document);
            this.saveProposalDocument(document);
            document = (ProposalDevelopmentDocument)this.getDocumentService().getByDocumentHeaderId(document.getDocumentHeader().getDocumentNumber());
            S2STestBase.assertNotNull((Object)document.getDevelopmentProposal());
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.tearDown();
            throw new RuntimeException(e);
        }
    }
}

