/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.util;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;

public class S2STestUtils {
    public static final String TEST_OPPORTUNITY_ID = "MOH-015";
    public static final String ATT_DIR_PATH = "src/test/resources/testAttachments/";

    public BudgetDocument createBudgetDocument(ProposalDevelopmentDocument pdDoc) throws Exception {
        DocumentService documentService = KRADServiceLocatorWeb.getDocumentService();
        Date requestedStartDateInitial = new Date(System.currentTimeMillis());
        Date requestedEndDateInitial = new Date(System.currentTimeMillis());
        this.setBaseDocumentFields(pdDoc, "ProposalDevelopmentDocumentTest test doc", "005770", "project title", requestedStartDateInitial, requestedEndDateInitial, "1", "1", "000001");
        BudgetDocument bd = (BudgetDocument)documentService.getNewDocument("BudgetDocument");
        this.setBaseDocumentFields(bd, pdDoc.getDevelopmentProposal().getProposalNumber());
        return bd;
    }

    private void setBaseDocumentFields(ProposalDevelopmentDocument document, String description, String sponsorCode, String title, Date requestedStartDateInitial, Date requestedEndDateInitial, String activityTypeCode, String proposalTypeCode, String ownedByUnit) {
        document.getDocumentHeader().setDocumentDescription(description);
        document.getDevelopmentProposal().setSponsorCode(sponsorCode);
        document.getDevelopmentProposal().setTitle(title);
        document.getDevelopmentProposal().setRequestedStartDateInitial(requestedStartDateInitial);
        document.getDevelopmentProposal().setRequestedEndDateInitial(requestedEndDateInitial);
        document.getDevelopmentProposal().setActivityTypeCode(activityTypeCode);
        document.getDevelopmentProposal().setProposalTypeCode(proposalTypeCode);
        document.getDevelopmentProposal().setOwnedByUnitNumber(ownedByUnit);
    }

    private void setBaseDocumentFields(BudgetDocument bdoc, String proposalNumber) {
        Budget bd = bdoc.getBudget();
        bdoc.getDocumentHeader().setDocumentDescription("Test budget calculation");
        bdoc.setParentDocumentKey(proposalNumber);
        bd.setBudgetVersionNumber(Integer.valueOf(1));
        bd.setStartDate(Date.valueOf("2002-01-01"));
        bd.setEndDate(Date.valueOf("2008-12-31"));
        bd.setUpdateTimestamp(new Timestamp(System.currentTimeMillis()));
        bd.setUpdateUser("KRADEV");
        bd.setOhRateClassCode("1");
        bd.setUrRateClassCode("1");
        bd.setModularBudgetFlag(Boolean.valueOf(false));
        bd.setActivityTypeCode("1");
        ArrayList<BudgetPeriod> periods = new ArrayList<BudgetPeriod>();
        BudgetPeriod bp = this.getBudgetPeriod(bd, 1, "2008-01-01", "2008-12-31");
        periods.add(bp);
        bd.setBudgetPeriods(periods);
    }

    private BudgetPeriod getBudgetPeriod(Budget bd, int period, String startDate, String endDate) {
        BudgetPeriod bp = new BudgetPeriod();
        bp.setBudgetId(bd.getBudgetId());
        bp.setBudgetPeriod(Integer.valueOf(period));
        bp.setStartDate(Date.valueOf(startDate));
        bp.setEndDate(Date.valueOf(endDate));
        bp.setUpdateUser(bd.getUpdateUser());
        bp.setUpdateTimestamp(bd.getUpdateTimestamp());
        bp.setTotalIndirectCost(BudgetDecimal.ZERO);
        return bp;
    }
}

