/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.polling;

import java.util.ArrayList;
import java.util.HashMap;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.s2s.polling.MailInfo;
import org.kuali.kra.s2s.polling.S2SPollingTask;
import org.kuali.kra.s2s.service.S2SService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class S2SPollingTaskTest
extends KcUnitTestBase {
    private DateTimeService dateTimeService = null;
    private BusinessObjectService businessObjectService = null;
    private S2SService s2sService = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        this.dateTimeService = (DateTimeService)KraServiceLocator.getService(DateTimeService.class);
        this.s2sService = (S2SService)KraServiceLocator.getService(S2SService.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.businessObjectService = null;
        this.dateTimeService = null;
        this.s2sService = null;
        super.tearDown();
    }

    @Test
    public void tests2sPolling() {
        S2SPollingTask s2sPollingTask = new S2SPollingTask();
        s2sPollingTask.setBusinessObjectService(this.businessObjectService);
        s2sPollingTask.setDateTimeService(this.dateTimeService);
        s2sPollingTask.sets2SService(this.s2sService);
        s2sPollingTask.setStopPollInterval("4320");
        s2sPollingTask.setMailInterval("20");
        HashMap<String, String> statusMap = new HashMap<String, String>();
        statusMap.put("1", "Submitted to Grants.Gov");
        statusMap.put("2", "Receiving");
        statusMap.put("3", "Received");
        statusMap.put("4", "Processing");
        s2sPollingTask.setStatusMap(statusMap);
        MailInfo mailInfo = new MailInfo();
        mailInfo.setTo("geot@mit.edu");
        mailInfo.setBcc("");
        mailInfo.setCc("");
        mailInfo.setDunsNumber("");
        mailInfo.setFooter("");
        mailInfo.setSubject("Grants.Gov Submissions");
        ArrayList<MailInfo> mailInfoList = new ArrayList<MailInfo>();
        mailInfoList.add(mailInfo);
        s2sPollingTask.setMailInfoList(mailInfoList);
        s2sPollingTask.execute();
    }
}

