/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.service;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.NarrativeAttachment;
import org.kuali.kra.proposaldevelopment.bo.ProposalSite;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.bo.S2sOppForms;
import org.kuali.kra.s2s.service.PrintService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;

public class PrintFormTest
extends KcUnitTestBase {
    private static final Log LOG = LogFactory.getLog(PrintFormTest.class);

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testPrint() throws IOException {
        ProposalDevelopmentDocument document = new ProposalDevelopmentDocument();
        Organization performOrganization = new Organization();
        performOrganization.setOrganizationName("Espace");
        Rolodex rolodex = new Rolodex();
        rolodex.setAddressLine1("1290 Avenue of the Americas");
        rolodex.setAddressLine2("Suite 550");
        rolodex.setCity("New York");
        rolodex.setCounty("County");
        rolodex.setPostalCode("10104");
        rolodex.setState("NY");
        rolodex.setCountryCode("USA");
        performOrganization.setRolodex(rolodex);
        ProposalSite performSite = new ProposalSite();
        performSite.setOrganization(performOrganization);
        document.getDevelopmentProposal().setPerformingOrganization(performSite);
        ArrayList<ProposalSite> proList = new ArrayList<ProposalSite>();
        ProposalSite proposalSite = new ProposalSite();
        proposalSite.setRolodex(rolodex);
        proList.add(proposalSite);
        document.getDevelopmentProposal().setOtherOrganizations(proList);
        Narrative narrative = new Narrative();
        narrative.setModuleNumber(Integer.valueOf(123));
        ArrayList<Narrative> naList = new ArrayList<Narrative>();
        NarrativeAttachment narrativeAttachment = new NarrativeAttachment();
        File file = new File("src/test/resources/testAttachments/exercise5.pdf");
        FileInputStream inStream = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(inStream);
        byte[] narrativePdf = new byte[bis.available()];
        bis.read(narrativePdf);
        narrativeAttachment.setNarrativeData(narrativePdf);
        ArrayList<NarrativeAttachment> narrativeList = new ArrayList<NarrativeAttachment>();
        narrativeList.add(0, narrativeAttachment);
        narrative.setNarrativeTypeCode("40");
        narrative.setNarrativeAttachmentList(narrativeList);
        narrative.setFileName("OpportunityForm");
        naList.add(narrative);
        document.getDevelopmentProposal().setNarratives(naList);
        S2sOppForms forms = new S2sOppForms();
        forms.setOppNameSpace("http://apply.grants.gov/forms/RR_PerformanceSite-V1.0");
        ArrayList<S2sOppForms> oppForms = new ArrayList<S2sOppForms>();
        oppForms.add(forms);
        document.getDevelopmentProposal().setS2sOppForms(oppForms);
        PrintService printService = (PrintService)KraServiceLocator.getService(PrintService.class);
        try {
            printService.printForm(document);
        }
        catch (S2SException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (PrintingException pe) {
            LOG.error((Object)pe.getMessage());
        }
    }
}

