/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.scheduling.quartz;

import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kra.scheduling.quartz.KcCronTriggerBean;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.impl.datetime.DateTimeServiceImpl;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.quartz.JobDetail;

@RunWith(value=JMock.class)
public class KcCronTriggerBeanTest {
    private static final String CRON_EXPRESSION = "1 3 22 * * ?";
    private Mockery context = new JUnit4Mockery();

    @Test
    public void testCronExpression() throws Exception {
        KcCronTriggerBean cronTrigger = new KcCronTriggerBean();
        final ParameterService parameterService = (ParameterService)this.context.mock(ParameterService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ParameterService)this.one(parameterService)).parameterExists("KC-PD", "Document", "pessimisticLocking.cronExpression");
                this.will(1.returnValue((Object)true));
                ((ParameterService)this.one(parameterService)).getParameterValueAsString("KC-PD", "Document", "pessimisticLocking.cronExpression");
                this.will(1.returnValue((Object)KcCronTriggerBeanTest.CRON_EXPRESSION));
            }
        });
        cronTrigger.setParameterService(parameterService);
        JobDetail jobDetail = new JobDetail();
        jobDetail.setName("test");
        cronTrigger.setBeanName("test");
        cronTrigger.setJobDetail(jobDetail);
        cronTrigger.setParameterNamespace("KC-PD");
        cronTrigger.setParameterComponent("Document");
        cronTrigger.setCronExpressionParameterName("pessimisticLocking.cronExpression");
        cronTrigger.setDateTimeService((DateTimeService)new DateTimeServiceImpl());
        cronTrigger.afterPropertiesSet();
        Assert.assertEquals((Object)CRON_EXPRESSION, (Object)cronTrigger.getCronExpression());
    }
}

