/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.scheduling.util;

import java.text.ParseException;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.kra.scheduling.util.Time24HrFmt;

public class Time24HrFmtTest {
    @Test
    public void testParseTime() throws Exception {
        try {
            new Time24HrFmt("10:30");
        }
        catch (ParseException e) {
            Assert.assertTrue((boolean)false);
        }
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testParseTimeWithIncorrectMinutes() throws Exception {
        try {
            new Time24HrFmt("10:79");
        }
        catch (ParseException e) {
            Assert.assertEquals((Object)"Time format exception, expects mm as 0-59", (Object)e.getMessage());
            Assert.assertTrue((boolean)true);
            return;
        }
        Assert.assertTrue((boolean)false);
    }

    @Test
    public void testParseTimeWithIncorrectHour() throws Exception {
        try {
            new Time24HrFmt("24:0");
        }
        catch (ParseException e) {
            Assert.assertEquals((Object)"Time format exception, expects hh as 0-23", (Object)e.getMessage());
            Assert.assertTrue((boolean)true);
            return;
        }
        Assert.assertTrue((boolean)false);
    }

    @Test
    public void testParseTimeWithNoMinutes() throws Exception {
        try {
            new Time24HrFmt("0");
        }
        catch (ParseException e) {
            Assert.assertEquals((Object)"Time format exception, expects hh:mm", (Object)e.getMessage());
            Assert.assertTrue((boolean)true);
            return;
        }
        Assert.assertTrue((boolean)false);
    }

    @Test
    public void testParseTimeWithNonInteger() throws Exception {
        try {
            new Time24HrFmt("10:1d");
        }
        catch (ParseException e) {
            Assert.assertEquals((Object)"Time format exception, expects hh as 0-23 & mm as 0-59", (Object)e.getMessage());
            Assert.assertTrue((boolean)true);
            return;
        }
        Assert.assertTrue((boolean)false);
    }
}

