/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service;

import java.io.Serializable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.service.impl.DeepCopyPostProcessorImpl;

public class DeepCopyPostProcessorTest {
    BudgetPeriod bp;

    @Before
    public void setUp() throws Exception {
        this.bp = new BudgetPeriod();
        this.bp.setBudgetPeriodId(Long.valueOf(1L));
        this.bp.setBudgetPeriod(Integer.valueOf(1));
        BudgetLineItem bli = new BudgetLineItem();
        bli.setBudgetLineItemId(Long.valueOf(1L));
        bli.setBudgetJustification("Test justification");
        this.bp.getBudgetLineItems().add(bli);
        BudgetLineItemCalculatedAmount blic = new BudgetLineItemCalculatedAmount();
        blic.setBudgetLineItemCalculatedAmountId(Long.valueOf(1L));
        blic.setBudgetPeriod(Integer.valueOf(2));
        bli.getBudgetCalculatedAmounts().add(blic);
    }

    @After
    public void tearDown() throws Exception {
        this.bp = null;
    }

    @Test
    public void testProcessDeepCopyWithDeepCopyIgnore() {
        BudgetPeriod copiedBp = (BudgetPeriod)new DeepCopyPostProcessorImpl().processDeepCopyWithDeepCopyIgnore((Serializable)this.bp);
        Assert.assertNull((Object)copiedBp.getBudgetPeriodId());
        Assert.assertNotNull((Object)copiedBp.getBudgetLineItems());
        Assert.assertEquals((Object)new Integer(1), (Object)copiedBp.getBudgetPeriod());
        Assert.assertNull((Object)copiedBp.getBudgetLineItem(0).getBudgetLineItemId());
        Assert.assertNotNull((Object)copiedBp.getBudgetLineItem(0).getBudgetJustification());
        Assert.assertNotNull((Object)copiedBp.getBudgetLineItem(0).getBudgetCalculatedAmounts());
        BudgetLineItemCalculatedAmount blic = (BudgetLineItemCalculatedAmount)copiedBp.getBudgetLineItem(0).getBudgetCalculatedAmounts().get(0);
        Assert.assertNull((Object)blic.getBudgetLineItemCalculatedAmountId());
        Assert.assertNotNull((Object)blic.getBudgetPeriod());
    }
}

